<?php
class Report extends MY_Controller
{
    public $module_name;
    public function __construct()
    {

        parent::__construct();
        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Muster_list_booking_model');

        $this->load->library('session');
        $view_data['menu_on'] = true;
        $this->load->vars($view_data);
    }

    /*
     * Get all reservation reports to view
     * */
    public function show_muster_list_report($date = null)
    {   
        
        //get user's shift information
        $date = (isset($date)) ? $date : $this->selling_date;
        
        $data['date'] = $date;
        $data['hotel_name'] = $this->company_name;

        $filters = array(
            'date' => $date,
            'order_by' => $this->session->userdata('reservation_order_by'),
            'order' => $this->session->userdata('reservation_order'),
        );

        $filters['include_customer_type'] = true;
        $filters['include_booking_fields'] = true;

        $company_id = $this->session->userdata('current_company_id');
        $data['bookings'] = $this->Muster_list_booking_model->get_bookings_for_report($filters, 0, null);

        $data['js_files'] = array(
            base_url() . 'js/moment.min.js',
        );
        
        $data['main_content'] = '../extensions/' . $this->module_name . '/views/muster_list_report';

        $this->template->load('bootstrapped_template', null, $data['main_content'], $data);

    }

    public function download_csv_export($date = null)
    {
        $date = (isset($date)) ? $date : $this->selling_date;
        
        $data['date'] = $date;

        $this->load->helper('download');

        $filters = array(
            'date' => $date,
            'order_by' => $this->session->userdata('reservation_order_by'),
            'order' => $this->session->userdata('reservation_order'),
        );

        $filters['include_customer_type'] = true;
        $filters['include_booking_fields'] = true;

        $data['bookings'] = $this->Muster_list_booking_model->get_bookings_for_report($filters, 0, null);
        
        // PREPARE KEY FOR THE CSV

        $reservation_settings = "booking_id,status,room,room_type,customer_name";
        
        $settings = explode(',', $reservation_settings);
        $csv_keys = [];

        $csv_lookup_keys = array(
            "booking_id" => "Booking Id",
            "customer_name" => "Guest Name",
            "room" => "Room",
            "room_type" => "Room Type",
            "status" => "Status"
        );

        foreach($csv_lookup_keys as $key => $value) {
           if(in_array($key,$settings)){
               $csv_keys[] = $value;
           }
        }

        $bookings = array($csv_keys);

        $states = array(
            "-1" => "All",
            '0' => "Confirmed",
            '1' => "In-House",
            '2' => "Checked-out",
            '3' => "Out of Order",
            '4' => "Cancelled",
            "5" => "No Show",
            '6' => "Deleted",
            '7' => "Unconfirmed",
            '10' => "Departure",
            '11' => "Arrivals",
        );
        

        foreach ($data['bookings'] as $key => $booking) {

            $booking_row = [];
            
            if (in_array('booking_id', $settings)) {
                $booking_row[] = $booking['booking_id'];
            }
            if (in_array('customer_name', $settings)) {
                $booking_row[] = $booking['customer_name'];
            }
            if (in_array('room', $settings)) {
                $booking_row[] = $booking['room_name'];
            }
            if (in_array('room_type', $settings)) {
                $booking_row[] = $booking['room_type_name'];
            }
            
            
            if (in_array('status', $settings)) {
                $status = $states[$booking['state']];
                $booking_row[] = $status;
            }

            $bookings[] = $booking_row;
        }

        force_download_csv($bookings, "muster_list_report.csv");
    }

}
