<h1>Add Whitelabel Partner</h1>

<!--Show success or error message-->
<?php 
    if($this->session->flashdata('success_message'))
    {
?>
        <div class="alert alert-success">
            <?php echo $this->session->flashdata('success_message'); ?>.
        </div>
<?php
    }
    else if($this->session->flashdata('error_message'))
    {
?>
        <div class="alert alert-danger">
            <?php echo $this->session->flashdata('error_message'); ?>.
        </div>
<?php
    }
?>
<!--Show success or error message-->
<form id="add_whitelabel_partner" method="post">
        <div class=" form-horizontal">
                <div class="form-group">
                        <label for="name" class="col-sm-3 control-label">
                                <?php echo l('Name',true);?><span style="color: red;">*</span>
                        </label>
                        <div class="col-sm-3">
                                <input type="text" class="form-control" name="name" id="name" required>
                        </div>
                </div>
                <div class="form-group">
                        <label for="username" class="col-sm-3 control-label">
                                <?php echo l('Username',true);?><span style="color: red;">*</span>
                        </label>
                        <div class="col-sm-3">
                                <input type="text" class="form-control" name="username" id="username" required>
                        </div>
                </div>
                <div class="form-group">
                        <label for="type" class="col-sm-3 control-label">
                                <?php echo l('Type',true);?><span style="color: red;">*</span>
                        </label>
                        <div class="col-sm-3">
                            <select class="form-control" name="type" id="type" required>
                                <?php foreach($whitelabel_partner_types as $type){ ?>
                                    <option value="<?php echo $type['id']; ?>"><?php echo $type['name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                </div>
               <div class="form-group">
                        <label for="domain" class="col-sm-3 control-label">
                                <?php echo l('Domain',true);?><span style="color: red;">*</span>
                        </label>
                        <div class="col-sm-3">
                            <input type="text" class="form-control" name="domain" id="domain" placeholder="eg: whitelabel-partner-domain.com">
                        </div>
                </div>
                <div class="form-group">
                        <label for="privacy_policy" class="col-sm-3 control-label">
                                <?php echo l('Privacy Policy Link',true);?>
                        </label>
                        <div class="col-sm-3">
                            <input type="url" class="form-control" name="privacy_policy" id="privacy_policy" placeholder="eg: http://privacy_policy.com">
                        </div>
                </div>
                <div class="form-group">
                        <label for="terms_of_service" class="col-sm-3 control-label">
                                <?php echo l('Terms of Service Link',true);?> 
                        </label>
                        <div class="col-sm-3">
                            <input type="url" class="form-control" name="terms_of_service" id="terms_of_service" placeholder="eg: http://terms_of_service.com">
                        </div>
                </div>
                <div class="form-group">
                        <label for="logo" class="col-sm-3 control-label">
                                <?php echo l('Logo',true);?><span style="color: red;">*</span>
                        </label>
                        <div class="col-sm-3">
                                <input type="text" class="form-control" name="logo" id="logo" required>
                        </div>
                </div>
                <div class="whitelabel_admin">
                    <div class="form-group">
                        <label for="admin_access_id" class="col-sm-3 control-label">
                                <?php echo l('Admin User Email',true);?><span style="color: red;">*</span>
                        </label>
                        <div class="col-sm-3">
                                <input type="text" class="form-control" name="admin_user_id" id="admin_user_id" required>
                        </div>
                        <div class="col-sm-3">
                            <!-- <button type="button" id="add_more_admin_id" count="0" class="btn btn-sm btn-success"><i class="fa fa-plus"></i></button> -->
                            <input type="hidden" name="add_more_admin_id" class="add_more_admin_id"> 
                        </div>
                    </div>
                </div>
                <div class="form-group">
                        <label for="timezone" class="col-sm-3 control-label">
                                <?php echo l('Timezone',true);?><span style="color: red;">*</span>
                        </label>
                        <div class="col-sm-3">
                                <select name="time_zone" class="form-control">
				<?php
					foreach ($timezones as $timezone => $timezone_name):
				?>
						<option value="<?php echo $timezone; ?>" 
						>
							<?php echo $timezone_name ?>
						</option>
				<?php
					endforeach;
				?>
			</select>
                        </div>
                </div>           
                <div class="form-group">
                        <label for="default_currency" class="col-sm-3 control-label">
                                <?php echo l('Default Currency',true);?><span style="color: red;">*</span>
                        </label>
                        <div class="col-sm-3">
                                <select name="default_currency" class="form-control">
				<?php	foreach ($available_currencies as $available_currency): ?>
					<option 
						value="<?php echo $available_currency['currency_id']; ?>"					

					 ><?php echo $available_currency['currency_name']." (".$available_currency['currency_code'].")"; ?></option>
				<?php endforeach; ?>
			</select>
                        </div>
                </div>
                <div class="form-group">
                        <label for="status" class="col-sm-3 control-label">
                                <?php echo l('Status',true);?><span style="color: red;">*</span>
                        </label>
                        <div class="col-sm-3">
                                <select class="form-control" name="status" id="status" required>
                                        <option value="0">0</option>
                                        <option value="1" selected>1</option>							
                                </select>
                        </div>
                </div>
				<div class="form-group">
                    <label for="type" class="col-sm-3 control-label"><?php echo l('Location', true);?>
                    </label>
                    <div class="col-sm-3">
						<?php $country_array = json_decode(COUNTRIES, true); ?>
                        <select class="form-control select-multiple" name="location[]" id="location" multiple="multiple" required>
							<?php foreach($country_array as $c){ ?>	
								<option value="<?= $c;?>"><?= $c;?></option>
							<?php } ?>
						</select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="show_on_partners_page" class="col-sm-3 control-label">
                        <?php echo l('Show on partners page',true);?>
                    </label>
                    <div class="col-sm-3">
                        <input type="checkbox" name="show_on_partners_page" id="show_on_partners_page"
                            value="1" style="margin: 12px 0;">
                    </div>
                </div>
                <div class="form-group">
                    <label for="support_email" class="col-sm-3 control-label">
                        <?php echo l('Support email',true);?><span style="color: red;">*</span>
                    </label>
                    <div class="col-sm-3">
                        <input type="email" class="form-control" name="support_email" id="support_email" readonly disabled>
                        <small><?php echo l('Default:  support@minical.io',true);?><br/><?php echo l('Please contact support to change this, it requires a few DNS changes.',true);?></small>
                    </div>
                </div>
                <div class="form-group">
                    <label for="do_not_reply_email" class="col-sm-3 control-label">
                        <?php echo l('Do not reply email',true);?><span style="color: red;">*</span>
                    </label>
                    <div class="col-sm-3">
                        <input type="email" class="form-control" name="do_not_reply_email" id="do_not_reply_email" readonly disabled>
                        <small><?php echo l('Default: donotreply@minical.io',true);?><br/><?php echo l('contact support to change this, it requires a few DNS changes.',true);?></small>
                    </div>
                </div>
                <div class="form-group">
                    <label for="intercom_app_id" class="col-sm-3 control-label">
                        <?php echo l('Intercom App ID',true);?>
                    </label>
                    <div class="col-sm-3">
                        <input type="text" class="form-control" name="intercom_app_id" id="intercom_app_id">
                    </div>
                </div>

                <div class="form-group <?php echo $this->user_id == SUPER_ADMIN_USER_ID ? '' : 'hidden'; ?>">
                    <label for="auto_close_io" class="col-sm-3 control-label">
                        <?php echo l('Auto import new signup to close.io',true);?>
                    </label>
                    <div class="col-sm-3">
                        <input type="checkbox" style="margin: 11px 0px;" name="auto_close_io" id="auto_close_io" value="1">
                    </div>
                </div>


                <div class="form-group">
                        <label for="submit" class="col-sm-3 control-label">
                                
                        </label>
                        <div class="col-sm-3">
                                <button type="submit" count="1" class="btn btn-success btn_submit" name="add_whitelabel_partner" id="add_whitelabel_partner">
                                        <?php echo l('Add',true);?> 
                                </button>
                        </div>
                </div>

        </div>
</form>