<?php

class Whitelabel_partners_model extends CI_Model {

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();		
    }
    
    function get_partners($condition = array(), $is_reference = false){
        if($condition)
        {
            if($is_reference){
                $this->db->like($condition);
            }else{
                $this->db->where($condition);
            }
            
        }
        $query = $this->db->get('whitelabel_partner');
        return $query->result_array();
    }
    
    function update_partner_detail($user_id, $data){
        $this->db->where('id', $user_id);
        $this->db->update('users', $data);
    }
    
    
    // fucntion for fetching all whitelabel partners 
    function get_whitelabel_partners()
    {
        $this->db->where('status', '1');
        $this->db->where('is_deleted', '0');
        $this->db->from('whitelabel_partner');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }
        return NULL;
    }

    function add_whitelabel_partner($data = array())
    {
        $query = $this->db->insert('whitelabel_partner', $data);
        return $this->db->insert_id();
    }
    
    function add_whitelabel_partner_x_admin($data = array())
    {
        $query = $this->db->insert('whitelabel_partner_x_admin', $data);
        return $this->db->insert_id();
    }

    function update_whitelabel_partner($partner_id, $data)
    {
        $this->db->where('id', $partner_id);
        $this->db->update('whitelabel_partner', $data); 
        if ($this->db->_error_message())
        {
            show_error($this->db->_error_message());
        }
    }
    
    function delete_whitelabel_partner_x_admin($partner_id)
    {
        $this->db->where('partner_id', $partner_id);
		$this->db->delete('whitelabel_partner_x_admin');
        
        if ($this->db->_error_message())
        {
            show_error($this->db->_error_message());
        }
    }

    function delete_whitelabel_partner($partner_id)
    {
        $data = array (
                    'is_deleted' => '1'
            );
        $this->db->where('id', $partner_id);
        $this->db->update("whitelabel_partner", $data);  
        if ($this->db->_error_message())
        {
            show_error($this->db->_error_message());
        }
    }
    
    // function to get whitelabel admin_id 
    function get_whitelabel_admin_ids($user_id = null, $partner_id = null)
    {
        $this->db->select('wpxa.admin_id');
        $this->db->from('whitelabel_partner as wp');
        $this->db->join('whitelabel_partner_x_admin AS wpxa', "wp.id = wpxa.partner_id", "left");
        
        if($user_id !== null){
            $this->db->join('users as u', 'u.partner_id = wp.id', 'left');
            $this->db->where('u.id', $user_id);
        }
        if($partner_id !== null){
            $this->db->where('wp.id', $partner_id);
        }
       
        $query = $this->db->get();
        $admins = array();
        if($query->num_rows() > 0)
        {
            foreach($query->result_array() as $admin){
                $admins[] = $admin['admin_id'];
            }
        }
        return $admins;
    }
    
    function get_partner_company_ids($partner_id)
    {
        $this->db->where('u.partner_id', $partner_id);
        $this->db->where('up.permission', 'is_owner');
        $this->db->select('up.company_id');
        $this->db->from('users as u');
        $this->db->join('user_permissions as up', 'up.user_id = u.id', 'left');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }
        return NULL;
    }

    function delete_previous_permissions($admin_user_id)
    {
        $this->db->where('user_id', $admin_user_id);
        $this->db->where('permission', 'is_admin');
        $this->db->delete('user_permissions');            
    }

    function add_new_permissions($admin_user_id, $company_id) 
    {
        $data = array(
                'company_id' => $company_id ,
                'user_id' => $admin_user_id ,
                'permission' => 'is_admin'
             );
        $query = $this->db->insert('user_permissions', $data); 
        return $this->db->insert_id();
    }
    
    function get_whitelabel_partner_types()
    {
        $this->db->from('whitelabel_partner_type');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }
        return NULL;
    }

    function get_partner_detail($partner_id = null)
    {
        $partner = null;
        if($partner_id)
        {
            $this->db->select('wp.*, wpxa.*, wpt.slug as partner_slug');
            $this->db->where('wp.id', $partner_id);
            $this->db->where('wp.status', '1');
            $this->db->from('whitelabel_partner AS wp');
            $this->db->join('whitelabel_partner_x_admin AS wpxa', "wp.id = wpxa.partner_id", "left");
            $this->db->join('whitelabel_partner_type AS wpt', "wp.type_id = wpt.id", "left");
            $this->db->group_by('wp.id');
            $query = $this->db->get();
            if($query->num_rows() > 0)
            {
                $partner = $query->result_array()[0];
            }
        }
        
        if(!$partner && $this->user_id){ // if current user is a admin of any whitelabel partner
            $this->db->select('wp.*, wpxa.*, wpt.slug as partner_slug');
            $this->db->where('wpxa.admin_id', $this->user_id);
            $this->db->where('wp.status', '1');
            $this->db->from('whitelabel_partner AS wp');
            $this->db->join('whitelabel_partner_x_admin AS wpxa', "wp.id = wpxa.partner_id", "left");
            $this->db->join('whitelabel_partner_type AS wpt', "wp.type_id = wpt.id", "left");
            $this->db->group_by('wp.id');
            $query = $this->db->get();
            if($query->num_rows() > 0)
            {
                $partner = $query->result_array()[0];
            }
        }
        
        if ($partner) { 
            $partner['admins'] = $this->get_whitelabel_admin_ids(null, $partner_id);
        }
        
        return $partner;
    }

    function get_total_rooms_partner($partner_id,$currentDate = null){

        if($partner_id >= 0)
        {
            $tenDaysAgo = date('Y-m-d', strtotime('-14 days'));

            $this->db->select('count(r.room_name) as room_count');
            $this->db->where('wp.id', $partner_id);
            $this->db->where('wp.status', '1');
            $this->db->where('r.is_deleted', '0');
            $this->db->where('r.is_hidden', '0');
            $this->db->where('c.is_deleted', '0');
            $this->db->where('cs.subscription_state', 'active');
            if($currentDate){
            $this->db->where('c.last_login BETWEEN "'.$tenDaysAgo.'" AND "'.$currentDate.'"');   
            }
            $this->db->from('whitelabel_partner AS wp');
            $this->db->join('company AS c', "wp.id = c.partner_id", "left");
            $this->db->join('company_subscription AS cs', "cs.company_id = c.company_id", "left");
            $this->db->join('room AS r', "r.company_id = c.company_id", "left");
            
            $query = $this->db->get();
            
            if ($this->db->_error_message()) // error checking
            show_error($this->db->_error_message());

             $result =  $query->row_array();
        
             return $result;
        }
    }
    function get_total_hotels_partner($partner_id,$currentDate = null,$state){

            //$currentDate = date('Y-m-d');
            $tenDaysAgo = date('Y-m-d', strtotime('-14 days'));
           // BETWEEN '$tenDaysAgo' AND '$currentDate'";
           //$this->db->where('login_date BETWEEN', array($tenDaysAgo, $currentDate));

            $this->db->select('count(c.company_id) as hotels_count');
            $this->db->where('wp.id', $partner_id);
            if($currentDate){
            $this->db->where('c.last_login BETWEEN "'.$tenDaysAgo.'" AND "'.$currentDate.'"');   
            }

            $this->db->where('wp.status', '1');
            $this->db->where('c.is_deleted', '0');
            if($state =='active'){
             $this->db->where('cs.subscription_state', 'active');
            }else{

             $this->db->where('cs.subscription_state !=', 'deleted');
            }
            $this->db->from('whitelabel_partner AS wp');
            $this->db->join('company AS c', "wp.id = c.partner_id", "left");
            $this->db->join('company_subscription AS cs', "cs.company_id = c.company_id", "left");
            
            $query = $this->db->get();
            
            if ($this->db->_error_message()) // error checking
            show_error($this->db->_error_message());

             $result =  $query->row_array();
        
             return $result;
      
    }
    
    function get_first_property_partner($partner_id){

            $query = $this->db->query('select c.company_id ,c.name FROM whitelabel_partner AS wp INNER JOIN company AS c ON wp.id = c.partner_id INNER JOIN user_permissions AS up ON wp.admin_user_id = up.user_id AND up.company_id = c.company_id where c.is_deleted = 0 AND wp.id = '.$partner_id.' ORDER by up.permission_id ASC LIMIT 1

             ');
            if ($this->db->_error_message()) // error checking
            show_error($this->db->_error_message());

             $result =  $query->row_array();
        
             return $result;
      
    }
    
    function get_paid_properties_partner($partner_id){

            $query = $this->db->query('SELECT count(c.company_id) as hotels_count FROM                      company as c 
                        INNER JOIN company_subscription AS cs on c.company_id = cs.company_id
                        where c.partner_id ='.$partner_id.' and cs.subscription_id is not null and cs.subscription_state ="active" and cs.payment_method in("stripe_customer_poral","chargify_v1","chargify","waveapps")');
            if ($this->db->_error_message()) // error checking
            show_error($this->db->_error_message());

             $result =  $query->row_array();
        
             return $result;
      
    }

    function get_month_usage_hotels_count($partner_id,$daterang){

            
        $query = $this->db->query("SELECT 
                                    DATE_FORMAT(dt, '%Y-%m') AS month,
                                     COUNT(c.company_id) AS total_hotels
                                    FROM
                                (
                                SELECT DATE_ADD('".$daterang."', INTERVAL n MONTH) AS dt
                                                    FROM (
                                SELECT n1.n + n10.n * 10 + n100.n * 100 AS n
                                FROM
                                    (SELECT 0 AS n
                                     UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4
                                     UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7 UNION ALL SELECT 8
                                     UNION ALL SELECT 9) AS n1
                                CROSS JOIN
                                    (SELECT 0 AS n
                                     UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4
                                     UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7 UNION ALL SELECT 8
                                     UNION ALL SELECT 9) AS n10
                                CROSS JOIN
                                    (SELECT 0 AS n
                                     UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4
                                     UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7 UNION ALL SELECT 8
                                     UNION ALL SELECT 9) AS n100
                                ) AS numbers
                            WHERE DATE_ADD('".$daterang."', INTERVAL n MONTH) <= CURRENT_DATE
                            ) AS months
                        LEFT JOIN company_admin_panel_info AS capi ON DATE_FORMAT(capi.creation_date, '%Y-%m') = DATE_FORMAT(months.dt, '%Y-%m')

                            LEFT JOIN
                            company_subscription AS cs ON cs.company_id = capi.company_id
                            LEFT JOIN 
                            company AS c ON capi.company_id = c.company_id 
                             WHERE
                            c.is_deleted = '0' AND cs.subscription_state != 'deleted' AND
                            c.partner_id = ".$partner_id."
                        GROUP BY month
                        ORDER BY month");
                if ($this->db->_error_message()) // error checking
                show_error($this->db->_error_message());

                $result =  $query->result_array();
        
                return $result;
      
    }

    function get_month_usage_rooms_count($partner_id, $daterang){

            
        $query = $this->db->query("SELECT 
                                    DATE_FORMAT(dt, '%Y-%m') AS month,
                                     count(r.room_name) as room_count
                                    FROM
                                (
                                SELECT DATE_ADD('".$daterang."', INTERVAL n MONTH) AS dt
                                                    FROM (
                                SELECT n1.n + n10.n * 10 + n100.n * 100 AS n
                                FROM
                                    (SELECT 0 AS n
                                     UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4
                                     UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7 UNION ALL SELECT 8
                                     UNION ALL SELECT 9) AS n1
                                CROSS JOIN
                                    (SELECT 0 AS n
                                     UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4
                                     UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7 UNION ALL SELECT 8
                                     UNION ALL SELECT 9) AS n10
                                CROSS JOIN
                                    (SELECT 0 AS n
                                     UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4
                                     UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7 UNION ALL SELECT 8
                                     UNION ALL SELECT 9) AS n100
                                ) AS numbers
                            WHERE DATE_ADD('".$daterang."', INTERVAL n MONTH) <= CURRENT_DATE
                            ) AS months
                        LEFT JOIN company_admin_panel_info AS capi ON DATE_FORMAT(capi.creation_date, '%Y-%m') = DATE_FORMAT(months.dt, '%Y-%m')

                            LEFT JOIN
                            company_subscription AS cs ON cs.company_id = capi.company_id
                            LEFT JOIN 
                            company AS c ON capi.company_id = c.company_id 
                            LEFT JOIN 
                            room AS r  ON r.company_id = c.company_id 
                             WHERE
                            c.is_deleted = '0' AND cs.subscription_state != 'deleted' AND
                            c.partner_id = ".$partner_id." AND  r.is_deleted = 0 AND r.is_hidden = 0
                        GROUP BY month
                        ORDER BY month");
                if ($this->db->_error_message()) // error checking
                show_error($this->db->_error_message());

                $result =  $query->result_array();
        
                return $result;
      
    }

    function get_month_usage_booking_count($partner_id,$daterang){

            
        $query = $this->db->query("SELECT
                                    DATE_FORMAT(dt, '%Y-%m') AS month,
                                    COUNT(bl.booking_id) AS total_bookings
                                    FROM
                                    (
                                    SELECT DATE_ADD('".$daterang."', INTERVAL n MONTH) AS dt
                                    FROM (
                                        SELECT n1.n + n10.n * 10 + n100.n * 100 AS n
                                        FROM
                                            (SELECT 0 AS n
                                             UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4
                                             UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7 UNION ALL SELECT 8
                                             UNION ALL SELECT 9) AS n1
                                        CROSS JOIN
                                            (SELECT 0 AS n
                                             UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4
                                             UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7 UNION ALL SELECT 8
                                             UNION ALL SELECT 9) AS n10
                                        CROSS JOIN
                                            (SELECT 0 AS n
                                             UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4
                                             UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7 UNION ALL SELECT 8
                                             UNION ALL SELECT 9) AS n100
                                        ) AS numbers
                                        
                                    WHERE DATE_ADD('".$daterang."', INTERVAL n MONTH) <= CURRENT_DATE
                                    ) AS months
                                    LEFT JOIN  booking_log  AS bl ON
                                    DATE_FORMAT(bl.date_time, '%Y-%m') = DATE_FORMAT(months.dt, '%Y-%m')
                                    LEFT JOIN
                                    booking AS b ON b.booking_id = bl.booking_id
                                    LEFT JOIN
                                    company AS c ON b.company_id = c.company_id 
                                    LEFT JOIN 
                                    company_subscription AS cs ON cs.company_id = c.company_id
                                    WHERE
                                    b.is_deleted = 0 AND
                                    c.is_deleted = 0 AND cs.subscription_state != 'deleted' AND
                                    c.partner_id = ".$partner_id." AND bl.log IN ('Booking created', 'OTA Booking created')    
                                    GROUP BY month
                                    ORDER BY month");
                if ($this->db->_error_message()) // error checking
                show_error($this->db->_error_message());

                $result =  $query->result_array();
        
                return $result;
      
    }
}
