<?php 

class Admin extends MY_Controller
{
    public $module_name;
    function __construct()
    {
        parent::__construct();

        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Admin_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Whitelabel_partners_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Currency_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Company_subscription_model');
        $this->load->library('pagination');
        $this->load->library('Form_validation');
        $this->load->helper('language_translation');
        $this->load->helper('timezone');
    }

    function dashboard()
    {
        
        $partner = $this->Whitelabel_partners_model->get_partner_detail();
        
        if($this->vendor_id) {
            $data['tables']['Main Property']  = $this->Admin_model->get_company_list(array(
                                                                        'main_property' => true
                                                                    ));
        }

        $data['tables']['Trialing']  = $this->Admin_model->get_company_list(array(
                                                                    'active_subscriptions' => false,
                                                                    'status' => 'trialing',
                                                                    //'last_login' => 10
                                                                ));
        
        $data['tables']['Promising']  = $this->Admin_model->get_company_list(array(
                                                                    'active_subscriptions' => false,
                                                                    'status'=> 'promising'                                                           
                                                                ));
        
        $data['tables']['Unpaid']  = $this->Admin_model->get_company_list(array(
                                                                     'active_subscriptions' => false,
                                                                     'status'=> 'unpaid'
                                                                ));
        
        $data['tables']['Onhold']  = $this->Admin_model->get_company_list(array(
                                                                    'active_subscriptions' => false,
                                                                      'status'=> 'on_hold'
                                                                ));
        $data['tables']['Review']  = $this->Admin_model->get_company_list(array(
                                                                    'active_subscriptions' => false,
                                                                    'status'=> 'review'
                                                                ));
        $data['tables']['Deleted'] = $this->Admin_model->get_company_list(array(
                                                                    'active_subscriptions' => false,
                                                                    'status' => 'deleted'
                                                                ));
        $data['tables']['Past Due'] = $this->Admin_model->get_company_list(array(
                                                                    'status' => 'past_due'
                                                                ));
        
        if(
            (isset($partner['partner_slug']) && 
            $partner['partner_slug'] == "channel_manager" &&
            in_array($this->user_id, $partner['admins'])) ||
            $this->user_id == SUPER_ADMIN_USER_ID
        )
        {
            $data['tables']['Active - Not Paying']  = $this->Admin_model->get_company_list(array(
                                                                    'active_subscriptions' => false,
                                                                      'status'=> 'active_not_paying'
                                                                ));
        }

        $data['tables']['Recent Cancellations'] = $this->Admin_model->get_company_list(array(
                                                                    'active_subscriptions' => false,
                                                                    'status' => 'canceled'
                                                                ));
        
        // $data['tables']['Active']  = $this->Admin_model->get_company_list(array(
        //                                                             'active_subscriptions' => true,
        //                                                               'status'=> 'active'
        //                                                         ));

        $data['tables']['Active'] = []; // load via AJAX


        // if($this->vendor_id) {
        //     array_shift($data['tables']['Active']);
        // }

        $data['menu_on'] = TRUE;

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/dashboard';
        $this->template->load('admin_template', null , $data['main_content'], $data);
    }

    public function ajax_active_companies()
    {
        $limit = 10;
        $page  = $this->input->post('page') ? (int)$this->input->post('page') : 1;
        if ($page < 1) $page = 1;
        $start = ($page - 1) * $limit;

        // Get total count
        $total = count($this->Admin_model->get_company_list([
            'active_subscriptions' => true,
            'status' => 'active'
        ]));

        // Get paginated data
        $companies = $this->Admin_model->get_company_list([
            'active_subscriptions' => true,
            'status' => 'active',
            'limit' => $limit,
            'offset' => $start
        ]); 

        // lq();

        // Build table rows using same HTML logic (reuse part of your dashboard code)
        $html = $this->load->view('../extensions/'.$this->module_name.'/views/active_companies', ['companies' => $companies, 'total' => $total], true);
         
        // Pagination
        $total_pages = ceil($total / $limit);

        $pagination = '<ul class="pagination justify-content-center">';

        // Show "First" button if not on first page
        if ($page > 1) {
            $pagination .= '<li class="page-item">
                                <a href="#" class="page-link" data-page="1">First</a>
                            </li>';
            $pagination .= '<li class="page-item">
                                <a href="#" class="page-link" data-page="'.($page-1).'">Previous</a>
                            </li>';
        }

        // Limit how many numbers you show (optional)
        $max_links = 5;
        $start_page = max(1, $page - floor($max_links / 2));
        $end_page = min($total_pages, $start_page + $max_links - 1);

        if ($end_page - $start_page < $max_links - 1) {
            $start_page = max(1, $end_page - $max_links + 1);
        }

        // Loop through page numbers
        for ($i = $start_page; $i <= $end_page; $i++) {
            $active_class = ($i == $page) ? 'active' : '';
            $pagination .= '<li class="page-item '.$active_class.'">
                                <a href="#" class="page-link" data-page="'.$i.'">'.$i.'</a>
                            </li>';
        }

        // Show "Next" and "Last"
        if ($page < $total_pages) {
            $pagination .= '<li class="page-item">
                                <a href="#" class="page-link" data-page="'.($page+1).'">Next</a>
                            </li>';
            $pagination .= '<li class="page-item">
                                <a href="#" class="page-link" data-page="'.$total_pages.'">Last</a>
                            </li>';
        }

        $pagination .= '</ul>';


        echo json_encode([
            'html' => $html,
            'pagination' => $pagination
        ]);
    }



    function translate_keywords($language_id = 0)
    {
        $languages = $this->translation_model->get_records('language');

        if($this->input->post())
        {
            $this->form_validation->set_rules('phrase_keyword[]', 'Phrase Keyword', 'trim|required');

            if ($this->form_validation->run()) 
            { 
                $insert_data = array();
                $insert_translation_data = array();
                $language_id = $this->input->post('language_id');
                $language_name = $this->input->post('language_name');
                $default_language_id = $this->input->post('default_language_id');
                $phrase_keyword = $this->input->post('phrase_keyword');
                $selected_language_phrase = $this->input->post('selected_language_phrase');
                
                foreach ($phrase_keyword as $key => $value) 
                {
                    $insert_data['phrase_keyword'] = $value;
                    $insert_translation_data['language_id'] = $language_id;
                    $insert_translation_data['phrase'] = $selected_language_phrase[$key];
                  
                    $check_if_exists = $this->translation_model->check_phrase_keyword_with_language($value, $language_id);
                    
                    if(empty($check_if_exists))
                    {
                        $phrase_id = $this->translation_model->insert_records('language_phrases', $insert_data); 
                        
                        if(!empty($phrase_id))
                        {
                            $insert_translation_data['phrase_id'] = $phrase_id;
                            $insert_translation_data_array = array();
                            
                            foreach ($languages as $language) 
                            {
                                $insert_translation_data['language_id'] = $language['id'];
                                if($language_id == '1')
                                {
                                    if ($language['id']==$language_id) 
                                    {
                                        $insert_translation_data['phrase'] = $selected_language_phrase[$key];
                                    }else{
                                        $insert_translation_data['phrase'] = $selected_language_phrase[$key];
                                    }
                                }
                                else
                                {
                                    if($language['id'] == $language_id)
                                    {
                                        $insert_translation_data['phrase'] = $selected_language_phrase[$key];
                                    }
                                    else
                                    {
                                        $insert_translation_data['phrase'] = '';
                                    }                                             
                                }
                                     
                                $insert_translation_data_array[] = $insert_translation_data;
                            }
                            $translation_id = $this->translation_model->insert_translation_records('language_translation', $insert_translation_data_array);
                        }
                    }else{
                        $this->session->set_flashdata('error_message', $value.' phrase kewyword already exists for '.$language_name.' language');
                        redirect('admin/translate_keywords');
                    }
                }
                
                if($translation_id > 0)
                {
                    $this->session->set_flashdata('success_message', 'Saved Successfully!!');
                    redirect('admin/translate_keywords/'.$language_id);
                }else{
                    $this->session->set_flashdata('error_message', 'Error in insertion');
                    redirect('admin/translate_keywords/'.$language_id);
                }
            }
            else
            {
                $this->session->set_flashdata('error_message', 'Please fill required Fields');
                redirect('admin/translate_keywords/'.$language_id);
            }

        }

        $view_data['non_translated_phrase'] = false;
        if(isset($_GET['non_translated_phrase'])) {
            $view_data['non_translated_phrase'] = true;
        }

        $view_data['translationRecords'] = $this->translation_model->get_all_phrases($language_id, $view_data['non_translated_phrase']);

        $language_status = $this->translation_model->get_record_where('language',array('id' => $language_id));
        $view_data['language_status'] = isset($language_status[0]['is_enable']) ? $language_status[0]['is_enable'] : '';
        
        $view_data['language_id'] = $language_id;
        $view_data['menu_on'] = TRUE;

        $view_data['main_content'] = '../extensions/'.$this->module_name.'/views/language_translation';

        $this->template->load('admin_template', null , $view_data['main_content'], $view_data);
    }
    
    // Get translation data by language using ajax
    function get_translation_data() {

        $language_id = $this->input->post('language_id');
        $data['translationRecords'] = $this->translation_model->get_translation_data($language_id);
        
        $english_translations = $this->translation_model->get_translation_data("1");
        foreach($english_translations as $key => $translation){
            $data['translationRecords'][$key]['default_key'] = isset($translation['phrase']) && $translation['phrase'] != '' ? $translation['phrase'] : (isset($translation['phrase_keyword']) && $translation['phrase_keyword'] ? $translation['phrase_keyword'] : "");
        }

        foreach ($data['translationRecords'] as $key => $value) {
            if(isset($value['phrase']) && $value['phrase'] != '') {
                unset($data['translationRecords'][$key]);
            }
        }

        $data['language_id'] = $language_id;
        $this->load->view('admin/language_translation_ajax_view', $data);
    }
    
    // Change language status using ajax
    function change_language_status() {
        
        $language_id = $this->input->post('language_id');
        $language_value = $this->input->post('value');
        $where = array('id'=>$language_id);
        $data['is_enable'] = $language_value;
        $this->translation_model->update_records('language', $data, $where);
        echo l('Data Saved Successfully!', true);
    }

    function update_translation_phrase() {
        $data = array();
        $tid = $this->input->post('tid');
        $pid = $this->input->post('pid');
        $language_id = $this->input->post('language_id');
        $phrase_value = $this->input->post('phrase_value');

        $where = array('id' => $tid);
        $data['phrase'] = $phrase_value;

        $is_exist_translation = $this->translation_model->get_record_where('language_translation', array('phrase_id' => $pid, 'language_id' => $language_id));
        
        if($is_exist_translation) {
            $this->translation_model->update_records('language_translation', $data, $where);
        } else {
            $data['phrase_id'] = $pid;
            $data['language_id'] = $language_id;
            $this->translation_model->insert_records('language_translation', $data);
        }
        
        echo l('success', true);
    }

    // whitelabel functionality start

    function whitelabel_partners()
    {

        $data['whitelabel_rooms'] =array();
        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        $data['whitelabel_partners'] = $this->Whitelabel_partners_model->get_whitelabel_partners();
        $data['whitelabel_partner_types'] = $this->Whitelabel_partners_model->get_whitelabel_partner_types();
        
        foreach ($data['whitelabel_partners'] as $key => $partners) {
           
            $data['whitelabel_rooms'][$partners['id']] = $this->Whitelabel_partners_model->get_total_rooms_partner($partners['id'],null);
            $data['whitelabel_rooms_last'][$partners['id']] = $this->Whitelabel_partners_model->get_total_rooms_partner($partners['id'],date('Y-m-d'));
            $data['whitelabel_hotels'][$partners['id']] = $this->Whitelabel_partners_model->get_total_hotels_partner($partners['id'],null,null);
            $data['whitelabel_hotels_active'][$partners['id']] = $this->Whitelabel_partners_model->get_total_hotels_partner($partners['id'],null,'active');
            $data['whitelabel_hotels_last'][$partners['id']] = $this->Whitelabel_partners_model->get_total_hotels_partner($partners['id'],date('Y-m-d'),null);
            $data['first_hotel_details'][$partners['id']] = $this->Whitelabel_partners_model->get_first_property_partner($partners['id']);
            
            $data['paid_hotel_details'][$partners['id']] = $this->Whitelabel_partners_model->get_paid_properties_partner($partners['id']);
        }

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/whitelabel_partners';
        $this->template->load('admin_template', null , $data['main_content'], $data);
    }
    

    function partners_usage_report($partner_id)
    {  
        $currentDate = new DateTime();
        // Subtract 6 months from the current date
        $currentDate->sub(new DateInterval('P6M'));
        // Set the day of the date to 01
        $currentDate->setDate($currentDate->format('Y'), $currentDate->format('m'), 01);
        // Get the first date of the last 6th month in the 'Y-m-d' format
        // Create a DateTime object for January 1, 2020
        $startDate = new DateTime('2020-01-01');
        // Initialize an empty array to store the date options
        $dateOptions = array();

        // Loop from the start date to the last 6th month and add each first date of the month to the array
        while ($startDate <= $currentDate) {
            $dateOptions[] = $startDate->format('Y-m-d');
            $startDate->add(new DateInterval('P6M'));
        }

        $search = $this->input->post('filter');
       if(isset($search) && $search !=""){
          $firstDateOfLast6thMonth = $this->input->post('dateoption');
          $data['daterange'] = $firstDateOfLast6thMonth;
       }else{
        
        $firstDateOfLast6thMonth = $currentDate->format('Y-m-d');
        $data['daterange'] = $firstDateOfLast6thMonth;
       }

       $data['whitelabel_partners'] = $this->Whitelabel_partners_model->get_whitelabel_partners();
       $hotels_count = $this->Whitelabel_partners_model->get_month_usage_hotels_count($partner_id,$firstDateOfLast6thMonth);
       $rooms_count = $this->Whitelabel_partners_model->get_month_usage_rooms_count($partner_id,$firstDateOfLast6thMonth);
       $booking_count = $this->Whitelabel_partners_model->get_month_usage_booking_count($partner_id,$firstDateOfLast6thMonth);

       function sortByMonth($a, $b) {
            return strcmp($a['month'], $b['month']);
       }
       //prx($booking_count,1);
       $mergedArray1 = $this->mergeArrays($hotels_count, $rooms_count ,'month');
       usort($mergedArray1, 'sortByMonth');
       $mergedArray = $this->mergeArraysuniqe($mergedArray1,$booking_count);
       //prx($mergedArray,1);
       // Sort the array by 'month' key in ascending order
        
        usort($mergedArray, 'sortByMonth');
        $data['partners_usage'] = $mergedArray;
       
       $hotels_count_accum = $this->Whitelabel_partners_model->get_month_usage_hotels_count($partner_id,'2020-01-01');
       $rooms_count_accum = $this->Whitelabel_partners_model->get_month_usage_rooms_count($partner_id,'2020-01-01');
       $accummergedArray = $this->mergeArrays($hotels_count_accum, $rooms_count_accum ,'month');
       // Initialize accumulative total hotels and rooms variable
        $accumulativeTotalHotels = 0;
        $accumulativeTotalRooms = 0;
        $accumulativeDataHotel = array();
        $accumulativeDataRoom = array();
        // Calculate accumulative total hotels
        //prx($accummergedArray,1);
        foreach ($accummergedArray as $item) {
        $month = $item['month'];
        $totalHotels = isset($item['total_hotels']) ? $item['total_hotels'] : 0;

        $accumulativeTotalHotels += $totalHotels;
        $accumulativeDataHotel[$month] = $accumulativeTotalHotels;
        }
        // prx($accumulativeDataHotel,1);
        // Calculate accumulative total rooms
        foreach ($accummergedArray as $item) {
        $month = $item['month'];
        $totalrooms = isset($item['room_count']) ? $item['room_count'] : 0;

        $accumulativeTotalRooms += $totalrooms;
        $accumulativeDataRoom[$month] = $accumulativeTotalRooms;
        }
        //prx($accumulativeDataRoom,1);
        $data['accumulativeDataHotel']= $accumulativeDataHotel;
        $data['accumulativeDataRoom']= $accumulativeDataRoom;
        $data['dateOptions']= $dateOptions;
        $data['main_content'] = '../extensions/'.$this->module_name.'/views/partners_usage_report';
        $this->template->load('admin_template', null , $data['main_content'], $data); 
    }
    // Custom comparison function to sort by 'month'
    


    // Function to merge two arrays based on a common key
    function mergeArrays($array1, $array2, $commonKey) {
        $mergedArray = array();

        foreach ($array1 as $item1) {
            $id = $item1[$commonKey];
            
            foreach ($array2 as $item2) {
                if ($item2[$commonKey] === $id) {
                    $mergedArray[] = array_merge($item1, $item2);
                    break;
                }
            }
        }

        return $mergedArray;
    }

    function mergeArraysuniqe($array1, $array2)
    {
        $result = [];

        // Merge elements from array1
        foreach ($array1 as $item) {
            $key = $item['month']; // Change 'id' to your common key
            if (!isset($result[$key])) {
                $result[$key] = $item;
            } else {
                // Merge all other keys except the common key
                foreach ($item as $itemKey => $itemValue) {
                    if ($itemKey !== 'month' && !isset($result[$key][$itemKey])) {
                        $result[$key][$itemKey] = $itemValue;
                    }
                }
            }
        }

        // Merge elements from array2
        foreach ($array2 as $item) {
            $key = $item['month']; // Change 'id' to your common key
            if (!isset($result[$key])) {
                $result[$key] = $item;
            } else {
                // Merge all other keys except the common key
                foreach ($item as $itemKey => $itemValue) {
                    if ($itemKey !== 'month' && !isset($result[$key][$itemKey])) {
                        $result[$key][$itemKey] = $itemValue;
                    }
                }
            }
        }

        return array_values($result);
    }

    function add_whitelabel_partner()
    {
        // Loading required model 
       
        $data['timezones'] = get_timezones();
        
        $data['available_currencies'] = $this->Currency_model->get_available_currency_list($this->company_id);

        if($this->input->post())
        {
            $this->form_validation->set_rules('name', 'Name', 'trim|required');
            $this->form_validation->set_rules('username', 'Username', 'trim|required');
            $this->form_validation->set_rules('logo', 'Logo', 'trim|required');
            $this->form_validation->set_rules('admin_user_id', 'Admin Id', 'trim|required');
            $this->form_validation->set_rules('domain', 'Domain', 'trim');
            $this->form_validation->set_rules('time_zone', 'Timezone', 'trim|required');
            $this->form_validation->set_rules('default_currency', 'Currency', 'trim|required');
          
            if ($this->form_validation->run()) {
                $insert_data = array();
                $insert_data['name'] = $this->input->post('name');
                $insert_data['username'] = $this->input->post('username');
                $insert_data['logo'] = $this->input->post('logo');
                $insert_data['domain'] = $this->input->post('domain');
                $insert_data['status'] = $this->input->post('status');
                $insert_data['type_id'] = $this->input->post('type');
                $insert_data['timezone'] = $this->input->post('time_zone');
                $insert_data['currency_id'] = $this->input->post('default_currency');
                $insert_data['location'] = json_encode($this->input->post('location'), true);
                $insert_data['privacy_policy'] = $this->input->post('privacy_policy');
                $insert_data['terms_of_service'] = $this->input->post('terms_of_service');
                $insert_data['support_email'] = $this->input->post('support_email') ? $this->input->post('support_email') : '';
                $insert_data['do_not_reply_email'] = $this->input->post('do_not_reply_email') ? $this->input->post('do_not_reply_email') : '';
                $insert_data['intercom_app_id'] = $this->input->post('intercom_app_id');
                $insert_data['auto_close_io'] = $this->input->post('auto_close_io');
                $insert_data['show_on_partners_page'] = $this->input->post('show_on_partners_page');
               
                $user_email = $this->input->post('admin_user_id');
                $user_data = $this->User_model->get_user_by_email($user_email);
                $user_id = $user_data['id'];
                $insert_data['admin_user_id'] = $user_id;
                $added_admin_ids = $this->input->post('add_more_admin_id');
                
                $whitelabel_partner_id = $this->Whitelabel_partners_model->add_whitelabel_partner($insert_data);
              
                   
                if($whitelabel_partner_id > 0)
                {
                    for($i = 0; $i <= $added_admin_ids; $i++)
                    {
                        if($i==0){
                            $user_data = $this->User_model->get_user_by_email($this->input->post('admin_user_id'));
                            $admin_ids_data['admin_id'] = $user_data['id'];
                        }else{
                            $user_data = $this->User_model->get_user_by_email($this->input->post('admin_user_id_'.$i));
                            $admin_ids_data['admin_id'] = $user_data['id'];
                        }

                        $comapny_data = $this->User_model->get_company_id($user_id);

                        $admin_ids_data['partner_id'] = $whitelabel_partner_id;
                        $this->Whitelabel_partners_model->add_whitelabel_partner_x_admin($admin_ids_data);
                        $this->User_model->add_user_permission($comapny_data->company_id, $user_id, 'is_admin');
                        
                        // update user's partner id
                        $this->User_model->update_user($user_id, array('partner_id' => $whitelabel_partner_id));

                        // update company's partner id

                        $this->Company_model->update_company($comapny_data->company_id, array('partner_id' => $whitelabel_partner_id));
                        
                        // update installed extensions
                        $active_extensions = $this->Extension_model->get_active_extensions($comapny_data->company_id);
                        
                        if($active_extensions && count($active_extensions) > 0){
                            $new_extensions = array();
                            foreach ($active_extensions as $extension) {
                                $new_extensions[] = array(
                                                            'extension_name' => $extension['extension_name'],
                                                            'vendor_id' => $whitelabel_partner_id,
                                                            'is_installed' => 1
                                                        );
                            }

                            for ($i = 0, $total = count($new_extensions); $i < $total; $i = $i + 50)
                            {
                                $ext_batch = array_slice($new_extensions, $i, 50);

                                $this->db->insert_batch("extensions_x_vendor", $ext_batch);

                                if ($this->db->_error_message())
                                {
                                    show_error($this->db->_error_message());
                                }
                            }
                        } 
                            
                        // install vendor only extensions
                        // $vendor_extension[] = array(
                        //                         'extension_name' => 'reseller_package',
                        //                         'vendor_id' => $whitelabel_partner_id,
                        //                         'is_installed' => 1
                        //                     );
                        $vendor_extension[] = array(
                                                'extension_name' => 'white_labeler',
                                                'vendor_id' => $whitelabel_partner_id,
                                                'is_installed' => 1
                                            );

                        for ($i = 0, $total = count($vendor_extension); $i < $total; $i = $i + 50)
                        {
                            $ext_batch = array_slice($vendor_extension, $i, 50);

                            $this->db->insert_batch("extensions_x_vendor", $ext_batch);

                            if ($this->db->_error_message())
                            {
                                show_error($this->db->_error_message());
                            }
                        }

                        // activate vendor only extensions
                        // $vendor_ext[] = array(
                        //                         'extension_name' => 'reseller_package',
                        //                         'company_id' => $comapny_data->company_id,
                        //                         'is_favourite' => 0,
                        //                         'is_active' => 1
                        //                     );
                        $vendor_ext[] = array(
                                                'extension_name' => 'white_labeler',
                                                'company_id' => $comapny_data->company_id,
                                                'is_favourite' => 0,
                                                'is_active' => 1
                                            );
                        
                        for ($i = 0, $total = count($vendor_ext); $i < $total; $i = $i + 50)
                        {
                            $ext_batch = array_slice($vendor_ext, $i, 50);

                            $this->db->insert_batch("extensions_x_company", $ext_batch);

                            if ($this->db->_error_message())
                            {
                                show_error($this->db->_error_message());
                            }
                        }

                        if ($this->db->_error_message())
                        {
                            show_error($this->db->_error_message());
                        }
                    }
                    
                    $this->session->set_flashdata('success_message', 'Added Successfully');
                    redirect('admin/whitelabel_partners');
                }
            }
            else
            {
                $this->session->set_flashdata('error_message', 'Please fill required Feilds');
                redirect('admin/add_whitelabel_partner');
            }
            
        }
        $data['whitelabel_partner_types'] = $this->Whitelabel_partners_model->get_whitelabel_partner_types();

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/add_whitelabel_partner';
        $this->template->load('admin_template', null , $data['main_content'], $data);


    }   
    
    //function for editing whitelabel partner 
    function edit_whitelabel_partner()
    {
        // Loading required model 
        
        $data['timezones'] = get_timezones();        
        $data['available_currencies'] = $this->Currency_model->get_available_currency_list($this->company_id);
        
        $partner_id = $this->uri->segment(3);

        if($this->input->post())
        {
            $this->form_validation->set_rules('name', 'Name', 'trim|required');
            $this->form_validation->set_rules('username', 'Username', 'trim|required');
            $this->form_validation->set_rules('logo', 'Logo', 'trim|required');
            $this->form_validation->set_rules('admin_user_id', 'Admin Id', 'trim|required');
            $this->form_validation->set_rules('domain', 'Domain', 'trim');
            $this->form_validation->set_rules('time_zone', 'Timezone', 'trim|required');
            $this->form_validation->set_rules('default_currency', 'Currency', 'trim|required');
            
            if ($this->form_validation->run()) {
                // admin user id 
                $old_admin_user_id = $this->input->post('old_admin_user_id');
                $admin_user_id = $this->input->post('admin_user_id');
                
                $old_user_data = $this->User_model->get_user_by_email($old_admin_user_id);
                $user_data = $this->User_model->get_user_by_email($admin_user_id);
                $old_admin_user_id = $old_user_data['id'];
                $admin_user_id = $user_data['id'];
                
                if(($old_admin_user_id != $admin_user_id))
                {
                    // get company id
                    $company_ids = $this->Whitelabel_partners_model->get_partner_company_ids($partner_id);
                    if($company_ids)
                    {                        
                        foreach($company_ids as $row)
                        {
                            if($admin_user_id != 0)
                            {
                                // Adding new permissions
                                $add_permission_result = $this->Whitelabel_partners_model->add_new_permissions($admin_user_id, $row['company_id']);
                            }
                            
                        }
                    }

                    // deleting previous permissions 
                    $delete_result = $this->Whitelabel_partners_model->delete_previous_permissions($old_admin_user_id);
                }
                
                
                $update_data = array();
                $update_data['name'] = $this->input->post('name');
                $update_data['username'] = $this->input->post('username');
                $update_data['logo'] = $this->input->post('logo');
                $update_data['admin_user_id'] = $admin_user_id;
                $update_data['domain'] = $this->input->post('domain');
                $update_data['status'] = $this->input->post('status');
                $update_data['type_id'] = $this->input->post('type');
                $update_data['timezone'] = $this->input->post('time_zone');
                $update_data['currency_id'] = $this->input->post('default_currency');

                $update_data['location'] = json_encode($this->input->post('location'), true);
                $update_data['privacy_policy'] = $this->input->post('privacy_policy');
                $update_data['terms_of_service'] = $this->input->post('terms_of_service');
                $update_data['support_email'] = $this->input->post('support_email') ? $this->input->post('support_email') : '';
                $update_data['do_not_reply_email'] = $this->input->post('do_not_reply_email') ? $this->input->post('do_not_reply_email') : '';
                $update_data['intercom_app_id'] = $this->input->post('intercom_app_id');
                $update_data['auto_close_io'] = $this->input->post('auto_close_io');
                $update_data['show_on_partners_page'] = $this->input->post('show_on_partners_page');
                
                $update_status = $this->Whitelabel_partners_model->update_whitelabel_partner($partner_id,$update_data);
                
                $update_admin_ids = $this->input->post('add_more_admin_id');
                

                $update_status = $this->Whitelabel_partners_model->update_whitelabel_partner($partner_id,$update_data);
                $this->Whitelabel_partners_model->delete_whitelabel_partner_x_admin($partner_id);
                
                for($i = 0; $i <= $update_admin_ids; $i++)
                {
                    if($i==0){
                        $user_data = $this->User_model->get_user_by_email($this->input->post('admin_user_id'));
                                                

                        $admin_ids_data['admin_id'] = $user_data['id'];
                    }else{
                        $user_data = $this->User_model->get_user_by_email($this->input->post('admin_user_id_'.$i));
                       
                        $admin_ids_data['admin_id'] = $user_data['id'];
                    }
                    $admin_ids_data['partner_id'] = $partner_id;
                    $this->Whitelabel_partners_model->add_whitelabel_partner_x_admin($admin_ids_data);
                }

                $this->session->set_flashdata('success_message', 'Updated Successfully');
                redirect('admin/whitelabel_partners');
                
            }
            else
            {
                $this->session->set_flashdata('error_message', 'Please fill required Feilds');
                redirect('admin/edit_whitelabel_partner');
            }            
        }
        
        // getting whitelabel partner detail        
        $data['partner_detail'] = $this->Whitelabel_partners_model->get_partner_detail($partner_id);
        $data['whitelabel_partner_types'] = $this->Whitelabel_partners_model->get_whitelabel_partner_types();
      
        $data['main_content'] = '../extensions/'.$this->module_name.'/views/edit_whitelabel_partner';
        $this->template->load('admin_template', null , $data['main_content'], $data);


    }
    
    //function to dlete white label partner
    function delete_whitelabel_partner()
    {
        // Loading required model 
      
        $partner_id = $this->uri->segment(3);
        $result = $this->Whitelabel_partners_model->delete_whitelabel_partner($partner_id);
                
        $this->session->set_flashdata('success_message', 'Deleted Successfully');
        redirect('admin/whitelabel_partners');
    }

    function profile_setting(){

        $data['partner_detail'] = $this->Whitelabel_partners_model->get_partner_detail();

        $partner_id = $data['partner_detail']['id'];

        if($this->input->post()){
            $update_data['privacy_policy'] = $this->input->post('privacy_policy');
            $update_data['terms_of_service'] = $this->input->post('terms_of_service');
                
            $update_status = $this->Whitelabel_partners_model->update_whitelabel_partner($partner_id, $update_data);

            $this->session->set_flashdata('success_message', 'Updated Successfully');
            redirect('admin/profile_setting');
        } else {
            $data['main_content'] = '../extensions/'.$this->module_name.'/views/profile_setting';
            $this->template->load('admin_template', null , $data['main_content'], $data);
        }
    }

    function update_company_AJAX()
    {
        $company_id = $this->input->post('company_id');
        $company_data = $this->input->post('company_data');
        $company_subscription_data = $this->input->post('company_subscription_data');
        $company_admin_data = $this->input->post('company_admin_data');
        $company_owner_email = $this->input->post('company_owner_email');
        $user_id = $this->input->post('user_id');
        $partner_id = $this->input->post('partner_id');
       
        $company_admin_info = $this->Company_model->get_company($company_id); 
        if($company_admin_info['partner_id'] != $partner_id){
            $partner_data = $this->Whitelabel_partners_model->get_partners(array('id'=>$partner_id));
           
            if($company_admin_info['subscription_id']==''){
            
                $company_subscription_data['subscription_state']= $partner_data[0]['default_property_status'];
                
                $company_subscription_data['meta_data'] = json_encode("Partner updated from [partner_id => {$company_admin_info['partner_id']}] by [user_id => {$this->user_id}]");
            }
        }
        if($company_admin_info['subscription_state'] != 'active' && $company_subscription_data['subscription_state'] == 'active' && (!$company_admin_info['conversion_date'] || $company_admin_info['conversion_date'] == "0000-00-00"))
        {
            $company_subscription_data['conversion_date'] =  $company_admin_data['conversion_date'] = date('Y-m-d');
        }
        if($company_admin_info['subscription_state'] != 'canceled' && $company_subscription_data['subscription_state'] == 'canceled')
        {
            $company_subscription_data['churn_date'] = $company_admin_data['churn_date'] = date('Y-m-d');
        }
        
        $company_subscription_data['conversion_date'] = $company_admin_data['conversion_date'] = $company_admin_data['conversion_date'] ? $company_admin_data['conversion_date'] : null;
        $company_subscription_data['churn_date'] = $company_admin_data['churn_date'] = $company_admin_data['churn_date'] ? $company_admin_data['churn_date'] : null;
        $company_subscription_data['expiration_date'] = $company_admin_data['trial_expiry_date'] = $company_admin_data['trial_expiry_date'] ? $company_admin_data['trial_expiry_date'] : null;
        //$company_admin_data['utm_source'] = $company_admin_data['utm_source'] ? $company_admin_data['utm_source'] : null;

        $company_subscription_data['renewal_cost'] = isset($company_subscription_data['renewal_cost']) && $company_subscription_data['renewal_cost'] ? $company_subscription_data['renewal_cost'] : 0;
        
        $company_subscription_data['cost_amount'] = isset($company_subscription_data['cost_amount']) && $company_subscription_data['cost_amount'] ? $company_subscription_data['cost_amount'] : 0;

        $company_subscription_data['tax'] = isset($company_subscription_data['tax']) && $company_subscription_data['tax'] ? $company_subscription_data['tax'] : 0;
        
        $company_subscription_data['limit_feature'] = $company_subscription_data['limit_feature'] == "true" ? 1 : 0;

        if(
            $company_subscription_data['subscription_state'] == 'unpaid' ||
            $company_subscription_data['subscription_state'] == 'deleted' ||
            $company_subscription_data['subscription_state'] == 'past_due'
        ){
            $company_subscription_data['meta_data'] = json_encode("State updated by [user_id => {$this->user_id}]");
        }

        // prx($company_subscription_data);
        
        // $company_data['enable_card_tokenization'] = $company_data['enable_card_tokenization'] == "true" ? 1 : 0;
        // $company_data['is_cc_visualization_enabled'] = $company_data['is_cc_visualization_enabled'] == "true" ? 1 : 0;
        $company_data['partner_id'] = $partner_id;
        
        $this->Company_model->update_company($company_id, $company_data);
        $this->Company_subscription_model->update_company_subscription($company_id, $company_subscription_data);
        $this->Company_model->update_company_admin_panel_info($company_id, $company_admin_data);
        $this->User_model->set_owner($company_owner_email, $company_id);
        echo json_encode("success!");
    }

    function delete_company_AJAX()
    {
        $company_id = $this->input->post('company_id');        
       
        $data = array('is_deleted' => '1');
        $this->Company_model->update_company($company_id, $data);

        //deconfigure
        $res = $this->Admin_model->get_channex_data($company_id);
        
        if($res && count($res) > 0)
            $this->Admin_model->deconfigure_channex($res['id']);

        echo json_encode("success!");
    }

    // search
    function company_list()
    {
        $data['main_content'] = '../extensions/'.$this->module_name.'/views/company_list';
        $this->template->load('admin_template', null , $data['main_content'], $data);
    }

    function get_company_list_JSON()
    {
        $search_query = $this->input->get('search_query');
        
        echo json_encode(
                    $this->Admin_model->get_company_list(array(
                                                        'actively_using' => null,
                                                        'active_subscriptions' => null,
                                                        'search_query' => $search_query
                                                    ))
                );
    }
}