$(function (){
	$('.popoverData').popover();
	$('.property_table').each(function(){
		if($(this).find('tbody tr').length) {

			if($(this).attr('id') == 'Trialing'){
				$(this).DataTable({
					// paginate: false,
					searching: false
				});
			} else if($(this).attr('id') == 'Active') {
				// $(this).DataTable({
				// 	//paginate: false
				// });
			} else {
				$(this).DataTable({
					paginate: false
				});
			}
		}
	});
});


$(document).ready(function() {

	console.log('ajax run');

    loadActiveCompanies(1);

    function loadActiveCompanies(page) {
        $.ajax({
            url: getBaseURL() + 'admin/ajax_active_companies',
            type: "POST",
            data: { page: page },
            dataType: "json",
            success: function(res) {
                $('#active-companies-body').html(res.html);
                $('#active-pagination').html(res.pagination);

                // Reinitialize popovers for newly added rows
		        $('[rel="popover"]').popover({
		            html: true,
		            trigger: 'hover',
		            placement: 'bottom'
		        });
            }
        });
    }

    $(document).on('click', '#active-pagination a', function(e) {
        e.preventDefault();
        let page = $(this).data('page');
        loadActiveCompanies(page);
    });
});