<?php 

class Guest_signature extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();

        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Company_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Guest_signature_model');
        $this->load->model('Booking_model');

        $this->load->library('email');

        $view_data['menu_on']          = true;
        $this->load->vars($view_data);
    }

    function set_language($company_language_id) {
        load_translations($company_language_id);
    }

    function reset_language($company_language_id) {
        if(empty($this->ci->session->userdata('language_id')))
        {
            get_language_id($this->ci->session->userdata('language'));
        }
        $language_id = $this->ci->session->userdata('language_id');
        if ($company_language_id != $language_id) {
            load_translations($language_id);
        }
    }

    function send_sign_link_email()
    {
        $booking_id = $this->input->post('booking_id', true); // 'true' enables XSS filtering

        $company = $this->company_data;

        // Get signature details
        $signature = $this->Guest_signature_model->get_signature_detail($booking_id);

        // Get booking details to access email
        $booking = $this->Booking_model->get_booking_detail($booking_id);
        $guest_name = $booking['booking_customer_name'];

        if ($booking['booking_customer_email'] == '') {
            echo "Guest email is not available. Please update the guest's email to proceed.";
            return;
        }

        if ($signature && !empty($signature->guest_signature)) {
            echo "Already sent email to " . $guest_name;
            return;
        }
        
        $whitelabelinfo = $this->ci->session->userdata('white_label_information');

        // $from_email = isset($whitelabelinfo['do_not_reply_email']) && $whitelabelinfo['do_not_reply_email'] ? $whitelabelinfo['do_not_reply_email'] : (isset($company['email']) && $company['email'] ? $company['email'] : 'donotreply@minical.io');

        if(
            isset($company['email']) &&
            $company['email']
        ) {
            $from_email = $company['email'];
        } else if(
            isset($whitelabelinfo['do_not_reply_email']) &&
            $whitelabelinfo['do_not_reply_email']
        ) {
            $from_email = $whitelabelinfo['do_not_reply_email'];
        } else {
            $from_email = 'donotreply@minical.io';
        }

        $signature_url = base_url() . "public/show_signature_form/" . $booking['company_id'] .'/'. $booking['invoice_hash'];

        $email_body = "Hi {$guest_name},
        <br/><br/>
        <h4>Welcome to ".$booking['company_name']."! <br/>
        Please Sign Your Registration Card Before Arrival</h4>
        <br/>
        $signature_url
        <br/><br/>
        Thank you!";

        $this->email->from($from_email);
        $this->email->to($booking['booking_customer_email']);
        $this->email->subject($booking['company_name']." - Signature Request for Your Upcoming Stay");
        $this->email->message($email_body);
        $this->email->send();

        echo "sent email to ".$booking['booking_customer_email'];
    }

    public function show_signature_form($company_id, $hash)
    {
        $data['company_id'] = $company_id;
        $data['hash'] = $hash;

        $booking_id = $this->Booking_model->get_booking_id_from_invoice_hash($hash);
        if (!$booking_id) {
            show_404(); // Or a custom "Invalid Link" view
            return;
        }

        $booking = $this->Booking_model->get_booking_detail($booking_id);
        if (!$booking) {
            show_404();
            return;
        }

        // ✅ Check if already signed
        $signature = $this->Guest_signature_model->get_signature_detail($booking_id, $company_id);

        if ($signature && !empty($signature->guest_signature)) {
            // Already submitted — show thank-you page
            $data['booking'] = $booking;
            $this->load->view('../extensions/' . $this->module_name . '/views/sign_submitted', $data);
            return;
        }

        // Not yet submitted — show form
        $data['booking'] = $booking;

        $data['check_in_policies'] = $this->Company_model->get_check_in_policies($this->company_id);
        $this->load->view('../extensions/' . $this->module_name . '/views/signature_form', $data);
    }


    public function save_guest_signature()
    {
        // Read raw JSON input
        $json = file_get_contents('php://input');
        $data = json_decode($json, true);

        $booking_id     = $data['booking_id'] ?? null;
        $company_id     = $data['company_id'] ?? null;
        $signature_data = $data['signature_data'] ?? null;
        $signature_date = $data['signature_date'] ?? null;
        $signed_via = $data['signed_via'] ?? null;

        if (!$booking_id || !$signature_data) {
            echo json_encode(['status' => 'error', 'message' => 'Missing data']);
            return;
        }

        // Check if already signed
        $exists = $this->Guest_signature_model->get_signature_detail($booking_id);
        if ($exists && !empty($exists->guest_signature)) {
            echo json_encode(['status' => 'error', 'message' => 'Signature already submitted.']);
            return;
        }

        // Clean base64
        $signature_data = str_replace(' ', '+', $signature_data);
        $signature_data = preg_replace('#^data:image/\w+;base64,#i', '', $signature_data);

        $decoded = base64_decode($signature_data, true);

        if (!$decoded) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid signature image data']);
            return;
        }

        // Path and save logic
        $file_name = 'signature_' . $booking_id . '_' . time() . '.png';
        $upload_path = FCPATH . 'application/extensions/' . $this->module_name . '/signatures/booking_' . $booking_id;

        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, true);
        }

        $file_path = $upload_path . '/' . $file_name;
        file_put_contents($file_path, $decoded);

        $insert_data = array(
            'booking_id'      => $booking_id,
            'company_id'      => $company_id,
            'guest_signature' => $file_name,
            'signed_via'      => $signed_via,
            'signature_at'    => $signature_date ? $signature_date : date('Y-m-d H:i:s')
        );

        $this->Guest_signature_model->insert_signature($insert_data);

        echo json_encode(['status' => 'success', 'file' => $file_name]);
    }


    public function thank_you()
    {
        $booking_id = $this->input->get('booking_id'); // sent via URL
        $data['booking_id'] = $booking_id;

        // Optional: Get guest name or other info if you want to personalize the message
        $booking = $this->Booking_model->get_booking_detail($booking_id);
        $data['guest_name'] = isset($booking['booking_customer_name']) ? $booking['booking_customer_name'] : 'Guest';

        $this->load->view('../extensions/' . $this->module_name . '/views/thank_you', $data);
    }


}