<?php

class Company_subscription_model extends CI_Model {
	
    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
	
	function get_subscription_id($company_id) {
		$selling_date = null;
		$this->db->select("subscription_id");
		$this->db->where('company_id', $company_id);

		$q = $this->db->get("company_subscription");
		
		if ($this->db->_error_message()) // error checking
			show_error($this->db->_error_message());
		
		$subscription_id = null;

		foreach ($q->result() as $row) {        
			$subscription_id = $row->subscription_id;
		}		
		//echo $this->db->last_query();
		return $subscription_id;
	}

    function get_company_subscription($company_id = null, $payment_method = null, $is_full_data = false)
    {
        $this->db->select('`company_id`, `subscription_id`, `subscription_type`, `subscription_state`, `renewal_period`, `renewal_cost`, `balance`, `region`, `payment_method`, `expiration_date`, `transition_after_expired`, `chargify_subscription_link`, `invoice_link`, `subscription_level`, `limit_feature`');
        $this->db->from('company_subscription');
		if($company_id)
			$this->db->where('company_id', $company_id);
		if($payment_method)
			$this->db->where('payment_method', $payment_method);

        $query = $this->db->get();

        if ($this->db->_error_message()) // error checking
        {   
            show_error($this->db->_error_message());
        }

        if ($query->num_rows() >= 1) {
            $result = $query->result_array();
            $result = !$is_full_data ? $result[0] : $result;
        } else {
            $this->db->insert('company_subscription', compact('company_id'));
            $result = $this->get_company_subscription($company_id);
        }

        return $result;
    }

    function update_company_balance($company_id)
    {
        $this->load->model('Company_charge_model');
        $this->load->model('Company_payment_model');
        $charge_total  = $this->Company_charge_model->get_company_charge_total($company_id);
        $payment_total = $this->Company_payment_model->get_company_payment_total($company_id);
        $balance       = $charge_total - $payment_total;
        $data          = array("balance" => $balance);
        $this->update_company_subscription($company_id, $data);
    }
	
	function update_company_subscription($company_id, $data)
	{
		$data = (object) $data;

		$this->db->where('company_id', $company_id);
        //$this->db->where('company_id', $company_id);
		$this->db->update('company_subscription', $data);

		//echo $this->db->last_query();

		if ($this->db->_error_message()) // error checking
			show_error($this->db->_error_message());

        return TRUE;
	}

    function insert_or_update_company_subscription($company_id, $data)
    {

        $company = $this->get_company_subscription($company_id);

        if(isset($data['api_key'])) { // junk
            unset($data['api_key']);
        }

        // prevent clearing up id
        // if(isset($data['subscription_id']) and empty($data['subscription_id'])){
        //     unset($data['subscription_id']);
        // }

        if($company){
            // update
            if(isset($data['company_id'])){ //conflicts
                unset($data['company_id']);
            }
            $this->update_company_subscription($company_id,$data);
        }else{
            // insert
            $this->db->insert('company_subscription', $data);
        }

    }

    function get_vendors_no_of_rooms($vendor_id) {
        $number_of_rooms = null;

        $this->db->where('partner_id', $vendor_id);
        $this->db->select('number_of_rooms');
        $q = $this->db->get('company');

        foreach ($q->result() as $row) {
            $number_of_rooms += $row->number_of_rooms;
        }
        if ($this->db->_error_message()) // error checking
            show_error($this->db->_error_message());

        return $number_of_rooms;
    }

    function get_vendors_company($vendor_id){
        if($vendor_id != 0){
            $this->db->where('c.partner_id', $vendor_id);
        }
        //$this->db->where('cs.subscription_state', 'active');
        $this->db->where('c.is_deleted', 0);
        $this->db->select('c.company_id,c.name');
        $this->db->from('company AS c');
        $this->db->join('company_subscription AS cs', "cs.company_id = c.company_id", "left");
        
        $query = $this->db->get();
        
       if ($this->db->_error_message()) // error checking
            show_error($this->db->_error_message());
        
        if($query->num_rows() >= 1)
        {
            return $query->result_array();
        }
        
        return NULL;
    }

    function get_stripe_user_company($stripe_user_id)
    {
        $sql = "SELECT company_id FROM `options` WHERE option_value like '%$stripe_user_id%'";

        $query = $this->db->query($sql);
        if ($this->db->_error_message())
        {
            show_error($this->db->_error_message());
        } else  {// otherwise, return insert_id;
            return $query->row_array();
        }
    }

    function get_first_vendor_company($id) {
        $selling_date = null;
        $this->db->select("current_company_id");
        $this->db->where('user_id', $id);

        $q = $this->db->get("user_profiles");
        
        if ($this->db->_error_message()) // error checking
            show_error($this->db->_error_message());
        
        $current_company_id = null;

        foreach ($q->result() as $row) {        
            $current_company_id = $row->current_company_id;
        }       
        //echo $this->db->last_query();
        return $current_company_id;
    }

}