/*! hotel-datepicker 3.6.5 - Copyright 2017 Benito Lopez (http://lopezb.com) - https://github.com/benitolopez/hotel-datepicker - MIT */
var HotelDatepicker=function(){"use strict";var t=0,e=function t(e,s){this._boundedEventHandlers={},this.id=t.getNewId();var a=s||{};this.format=a.format||"YYYY-MM-DD",this.infoFormat=a.infoFormat||this.format,this.separator=a.separator||" - ",this.startOfWeek=a.startOfWeek||"sunday",this.startDate=a.startDate||new Date,this.endDate=a.endDate||!1,this.minNights=a.minNights||1,this.maxNights=a.maxNights||0,this.selectForward=a.selectForward||!1,this.disabledDates=a.disabledDates||[],this.noCheckInDates=a.noCheckInDates||[],this.noCheckOutDates=a.noCheckOutDates||[],this.disabledDaysOfWeek=a.disabledDaysOfWeek||[],this.enableCheckout=a.enableCheckout||!1,this.container=a.container||"",this.animationSpeed=a.animationSpeed||".5s",this.hoveringTooltip=a.hoveringTooltip||!0,this.autoClose=void 0===a.autoClose||a.autoClose,this.showTopbar=void 0===a.showTopbar||a.showTopbar,this.moveBothMonths=a.moveBothMonths||!1,this.i18n=a.i18n||{selected:"Your stay:",night:"Night",nights:"Nights",button:"Close","checkin-disabled":"Check-in disabled","checkout-disabled":"Check-out disabled","day-names-short":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"day-names":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],"month-names-short":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"month-names":["January","February","March","April","May","June","July","August","September","October","November","December"],"error-more":"Date range should not be more than 1 night","error-more-plural":"Date range should not be more than %d nights","error-less":"Date range should not be less than 1 night","error-less-plural":"Date range should not be less than %d nights","info-more":"Please select a date range of at least 1 night","info-more-plural":"Please select a date range of at least %d nights","info-range":"Please select a date range between %d and %d nights","info-default":"Please select a date range"},this.getValue=a.getValue||function(){return e.value},this.setValue=a.setValue||function(t){e.value=t},this.onDayClick=void 0!==a.onDayClick&&a.onDayClick,this.onOpenDatepicker=void 0!==a.onOpenDatepicker&&a.onOpenDatepicker,this.onSelectRange=void 0!==a.onSelectRange&&a.onSelectRange,this.input=e,this.init()};return e.prototype.addBoundedListener=function(t,e,s,a){t in this._boundedEventHandlers||(this._boundedEventHandlers[t]={}),e in this._boundedEventHandlers[t]||(this._boundedEventHandlers[t][e]=[]);var i=s.bind(this);this._boundedEventHandlers[t][e].push([i,a]),t.addEventListener(e,i,a)},e.prototype.removeAllBoundedListeners=function(t,e){if(t in this._boundedEventHandlers){var s=this._boundedEventHandlers[t];if(e in s)for(var a=s[e],i=a.length;i--;){var n=a[i];t.removeEventListener(e,n[0],n[1])}}},e.getNewId=function(){return++t},e.prototype.setFechaI18n=function(){fecha.i18n.dayNamesShort=this.i18n["day-names-short"],fecha.i18n.dayNames=this.i18n["day-names"],fecha.i18n.monthNamesShort=this.i18n["month-names-short"],fecha.i18n.monthNames=this.i18n["month-names"]},e.prototype.getWeekDayNames=function(){var t="";if("monday"===this.startOfWeek){for(var e=0;e<7;e++)t+='<th class="datepicker__week-name">'+this.lang("day-names-short")[(1+e)%7]+"</th>";return t}for(var s=0;s<7;s++)t+='<th class="datepicker__week-name">'+this.lang("day-names-short")[s]+"</th>";return t},e.prototype.getMonthDom=function(t){return document.getElementById(this.getMonthTableId(t))},e.prototype.getMonthName=function(t){return this.lang("month-names")[t]},e.prototype.getDatepickerId=function(){return"datepicker-"+this.generateId()},e.prototype.getMonthTableId=function(t){return"month-"+t+"-"+this.generateId()},e.prototype.getCloseButtonId=function(){return"close-"+this.generateId()},e.prototype.getTooltipId=function(){return"tooltip-"+this.generateId()},e.prototype.getNextMonth=function(t){var e=new Date(t.valueOf());return new Date(e.setMonth(e.getMonth()+1))},e.prototype.getPrevMonth=function(t){var e=new Date(t.valueOf());return new Date(e.setMonth(e.getMonth()-1))},e.prototype.getDateString=function(t,e){return void 0===e&&(e=this.format),this.setFechaI18n(),fecha.format(t,e)},e.prototype.parseDate=function(t,e){return void 0===e&&(e=this.format),this.setFechaI18n(),fecha.parse(t,e)},e.prototype.init=function(){this.parent=this.container?this.container:this.input.parentElement,this.start=!1,this.end=!1,this.minDays=1<this.minNights?this.minNights+1:2,this.maxDays=0<this.maxNights?this.maxNights+1:0,this.startDate&&"string"==typeof this.startDate&&(this.startDate=this.parseDate(this.startDate)),this.endDate&&"string"==typeof this.endDate&&(this.endDate=this.parseDate(this.endDate)),this.isTouchDevice()&&(this.hoveringTooltip=!1),this.isOpen=!1,this.changed=!1,this.createDom();var t=new Date;this.startDate&&this.compareMonth(t,this.startDate)<0&&(t=this.startDate),this.endDate&&0<this.compareMonth(this.getNextMonth(t),this.endDate)&&(t=this.getPrevMonth(this.endDate)),0<this.disabledDates.length&&this.parseDisabledDates(),this.showMonth(t,1),this.showMonth(this.getNextMonth(t),2),this.topBarDefaultText(),this.addListeners()},e.prototype.addListeners=function(){for(var e=this,t=this.datepicker.getElementsByClassName("datepicker__month-button--next"),s=0;s<t.length;s++)t[s].addEventListener("click",function(t){return e.goToNextMonth(t)});for(var a=this.datepicker.getElementsByClassName("datepicker__month-button--prev"),i=0;i<a.length;i++)a[i].addEventListener("click",function(t){return e.goToPreviousMonth(t)});this.addBoundedListener(this.input,"click",function(t){return e.openDatepicker(t)}),this.showTopbar&&document.getElementById(this.getCloseButtonId()).addEventListener("click",function(t){return e.closeDatepicker(t)}),this.datepicker.addEventListener("mouseover",function(t){return e.datepickerHover(t)}),this.datepicker.addEventListener("mouseout",function(t){return e.datepickerMouseOut(t)}),this.addBoundedListener(this.input,"change",function(){return e.checkAndSetDefaultValue()})},e.prototype.generateId=function(){return this.input.id?this.input.id:this.id},e.prototype.createDom=function(){var t=this.createDatepickerDomString();this.parent.insertAdjacentHTML("beforeend",t),this.datepicker=document.getElementById(this.getDatepickerId())},e.prototype.createDatepickerDomString=function(){var t='<div id="'+this.getDatepickerId()+'" style="display:none" class="datepicker datepicker--closed">';t+='<div class="datepicker__inner">',this.showTopbar&&(t+='<div class="datepicker__topbar"><div class="datepicker__info datepicker__info--selected"><span class="datepicker__info datepicker__info--selected-label">'+this.lang("selected")+' </span> <strong class="datepicker__info-text datepicker__info-text--start-day">...</strong> <span class="datepicker__info-text datepicker__info--separator">'+this.separator+'</span> <strong class="datepicker__info-text datepicker__info-text--end-day">...</strong> <em class="datepicker__info-text datepicker__info-text--selected-days">(<span></span>)</em></div><div class="datepicker__info datepicker__info--feedback"></div><button type="button" id="'+this.getCloseButtonId()+'" class="datepicker__close-button">'+this.lang("button")+"</button></div>"),t+='<div class="datepicker__months">';for(var e=1;e<=2;e++)t+='<table id="'+this.getMonthTableId(e)+'" class="datepicker__month datepicker__month--month'+e+'"><thead><tr class="datepicker__month-caption"><th><span class="datepicker__month-button datepicker__month-button--prev" month="'+e+'">&lt;</span></th><th colspan="5" class="datepicker__month-name"></th><th><span class="datepicker__month-button datepicker__month-button--next" month="'+e+'">&gt;</span></th></tr><tr class="datepicker__week-days">'+this.getWeekDayNames(e)+"</tr></thead><tbody></tbody></table>";return t+="</div>",t+='<div style="display:none" id="'+this.getTooltipId()+'" class="datepicker__tooltip"></div>',t+="</div>",t+="</div>"},e.prototype.showMonth=function(t,e){var s=this.getMonthName(t.getMonth()),a=this.getMonthDom(e),i=a.getElementsByClassName("datepicker__month-name")[0],n=a.getElementsByTagName("tbody")[0];i.textContent=s+" "+t.getFullYear(),this.emptyElement(n),n.insertAdjacentHTML("beforeend",this.createMonthDomString(t)),this.updateSelectableRange(),this["month"+e]=t},e.prototype.createMonthDomString=function(t){var e,s=this,a=[],i="";t.setDate(1);var n=t.getDay(),o=t.getMonth();if(0===n&&"monday"===this.startOfWeek&&(n=7),0<n)for(var r=n;0<r;r--){var h=new Date(t.getTime()-864e5*r);e=s.isValidDate(h.getTime()),(s.startDate&&s.compareDay(h,s.startDate)<0||s.endDate&&0<s.compareDay(h,s.endDate))&&(e=!1),a.push({date:h,type:"lastMonth",day:h.getDate(),time:h.getTime(),valid:e})}for(var d=0;d<40;d++){var l=s.addDays(t,d);e=s.isValidDate(l.getTime()),(s.startDate&&s.compareDay(l,s.startDate)<0||s.endDate&&0<s.compareDay(l,s.endDate))&&(e=!1),a.push({date:l,type:l.getMonth()===o?"visibleMonth":"nextMonth",day:l.getDate(),time:l.getTime(),valid:e})}for(var c=0;c<6&&"nextMonth"!==a[7*c].type;c++){var p=0;i+='<tr class="datepicker__week-row">';for(var m=0;m<7;m++){var g="monday"===s.startOfWeek?m+1:m;g=a[7*c+g];var u=s.getDateString(g.time)===s.getDateString(new Date),y=!1,D=!1,f=!1,k=!1,v=!1;if(g.valid){var _=s.getDateString(g.time,"YYYY-MM-DD");if(0<s.disabledDates.length){var b=s.getClosestDates(g.date);if(b[0]&&b[1]&&s.compareDay(g.date,b[0])&&0<s.countDays(b[0],b[1])-2){var C=s.countDays(b[1],g.date)-1,M=s.countDays(g.date,b[0])-1;s.selectForward&&C<s.minDays?g.valid=!1:!s.selectForward&&C<s.minDays&&M<s.minDays&&(g.valid=!1),!g.valid&&s.enableCheckout&&2===C&&(v=!0)}-1<s.disabledDates.indexOf(_)?(y=!(g.valid=!1),p++):p=0}0<s.disabledDaysOfWeek.length&&-1<s.disabledDaysOfWeek.indexOf(fecha.format(g.time,"dddd"))&&(k=!(g.valid=!1)),0<s.noCheckInDates.length&&-1<s.noCheckInDates.indexOf(_)&&(D=!0),0<s.noCheckOutDates.length&&-1<s.noCheckOutDates.indexOf(_)&&(f=!0)}var T=["datepicker__month-day--"+g.type,"datepicker__month-day--"+(g.valid?"valid":"invalid"),u?"datepicker__month-day--today":"",y?"datepicker__month-day--disabled":"",y&&s.enableCheckout&&1===p?"datepicker__month-day--checkout-enabled":"",v?"datepicker__month-day--before-disabled-date":"",D?"datepicker__month-day--no-check-in":"",f?"datepicker__month-day--no-check-out":"",k?"datepicker__month-day--day-of-week-disabled":""],w="";D&&(w=s.i18n["checkin-disabled"]),f&&(w&&(w+=". "),w+=s.i18n["checkout-disabled"]);var S={time:g.time,class:T.join(" ")};w&&(S.title=w),i+='<td class="datepicker__month-day '+S.class+'" '+s.printAttributes(S)+">"+g.day+"</td>"}i+="</tr>"}return i},e.prototype.openDatepicker=function(){var e=this;this.isOpen||(this.removeClass(this.datepicker,"datepicker--closed"),this.addClass(this.datepicker,"datepicker--open"),this.checkAndSetDefaultValue(),this.slideDown(this.datepicker,this.animationSpeed),this.isOpen=!0,this.showSelectedDays(),this.disableNextPrevButtons(),this.addBoundedListener(document,"click",function(t){return e.documentClick(t)}),this.onOpenDatepicker&&this.onOpenDatepicker())},e.prototype.closeDatepicker=function(){if(this.isOpen){this.removeClass(this.datepicker,"datepicker--open"),this.addClass(this.datepicker,"datepicker--closed"),this.slideUp(this.datepicker,this.animationSpeed),this.isOpen=!1;var t=document.createEvent("Event");t.initEvent("afterClose",!0,!0),this.input.dispatchEvent(t),this.removeAllBoundedListeners(document,"click")}},e.prototype.autoclose=function(){this.autoClose&&this.changed&&this.isOpen&&this.start&&this.end&&this.closeDatepicker()},e.prototype.documentClick=function(t){this.parent.contains(t.target)||t.target===this.input?"td"===t.target.tagName.toLowerCase()&&this.dayClicked(t.target):this.closeDatepicker()},e.prototype.datepickerHover=function(t){t.target.tagName&&"td"===t.target.tagName.toLowerCase()&&this.dayHovering(t.target)},e.prototype.datepickerMouseOut=function(t){t.target.tagName&&"td"===t.target.tagName.toLowerCase()&&(document.getElementById(this.getTooltipId()).style.display="none")},e.prototype.checkAndSetDefaultValue=function(){var t=this.getValue(),e=t?t.split(this.separator):"";if(e&&2<=e.length){var s=this.format;s.match(/Do/)&&(s=s.replace(/Do/,"D"),e[0]=e[0].replace(/(\d+)(th|nd|st)/,"$1"),e[1]=e[1].replace(/(\d+)(th|nd|st)/,"$1")),this.changed=!1,this.setDateRange(this.parseDate(e[0],s),this.parseDate(e[1],s)),this.changed=!0}else if(this.showTopbar){this.datepicker.getElementsByClassName("datepicker__info--selected")[0].style.display="none"}},e.prototype.setDateRange=function(t,e){if(t.getTime()>e.getTime()){var s=e;e=t,t=s,s=null}var a=!0;if((this.startDate&&this.compareDay(t,this.startDate)<0||this.endDate&&0<this.compareDay(e,this.endDate))&&(a=!1),!a)return this.showMonth(this.startDate,1),this.showMonth(this.getNextMonth(this.startDate),2),this.showSelectedDays(),void this.disableNextPrevButtons();t.setTime(t.getTime()+432e5),e.setTime(e.getTime()+432e5),this.start=t.getTime(),this.end=e.getTime(),0<this.compareDay(t,e)&&0===this.compareMonth(t,e)&&(e=this.getNextMonth(t)),0===this.compareMonth(t,e)&&(e=this.getNextMonth(t)),this.showMonth(t,1),this.showMonth(e,2),this.showSelectedDays(),this.disableNextPrevButtons(),this.checkSelection(),this.showSelectedInfo(),this.autoclose()},e.prototype.showSelectedDays=function(){var t=this;if(this.start||this.end)for(var e=this.datepicker.getElementsByTagName("td"),s=0;s<e.length;s++){var a=parseInt(e[s].getAttribute("time"),10);t.start&&t.end&&t.end>=a&&t.start<=a||t.start&&!t.end&&t.getDateString(t.start,"YYYY-MM-DD")===t.getDateString(a,"YYYY-MM-DD")?t.addClass(e[s],"datepicker__month-day--selected"):t.removeClass(e[s],"datepicker__month-day--selected"),t.start&&t.getDateString(t.start,"YYYY-MM-DD")===t.getDateString(a,"YYYY-MM-DD")?t.addClass(e[s],"datepicker__month-day--first-day-selected"):t.removeClass(e[s],"datepicker__month-day--first-day-selected"),t.end&&t.getDateString(t.end,"YYYY-MM-DD")===t.getDateString(a,"YYYY-MM-DD")?t.addClass(e[s],"datepicker__month-day--last-day-selected"):t.removeClass(e[s],"datepicker__month-day--last-day-selected")}},e.prototype.showSelectedInfo=function(){if(this.showTopbar){var t=this.datepicker.getElementsByClassName("datepicker__info--selected")[0],e=t.getElementsByClassName("datepicker__info-text--start-day")[0],s=t.getElementsByClassName("datepicker__info-text--end-day")[0],a=t.getElementsByClassName("datepicker__info-text--selected-days")[0],i=document.getElementById(this.getCloseButtonId());if(e.textContent="...",s.textContent="...",a.style.display="none",this.start&&(t.style.display="",e.textContent=this.getDateString(new Date(parseInt(this.start,10)),this.infoFormat)),this.end&&(s.textContent=this.getDateString(new Date(parseInt(this.end,10)),this.infoFormat)),this.start&&this.end){var n=this.countDays(this.end,this.start)-1,o=1===n?n+" "+this.lang("night"):n+" "+this.lang("nights"),r=this.getDateString(new Date(this.start))+this.separator+this.getDateString(new Date(this.end));a.style.display="",a.firstElementChild.textContent=o,i.disabled=!1,this.setValue(r,this.getDateString(new Date(this.start)),this.getDateString(new Date(this.end))),this.changed=!0}else i.disabled=!0}else if(this.start&&this.end){var h=this.getDateString(new Date(this.start))+this.separator+this.getDateString(new Date(this.end));this.setValue(h,this.getDateString(new Date(this.start)),this.getDateString(new Date(this.end))),this.changed=!0}},e.prototype.dayClicked=function(t){if(!this.hasClass(t,"datepicker__month-day--invalid")){var e=this.start&&this.end||!this.start&&!this.end;if(e){if(this.hasClass(t,"datepicker__month-day--no-check-in"))return}else if(this.start&&this.hasClass(t,"datepicker__month-day--no-check-out"))return;var s=parseInt(t.getAttribute("time"),10);if(this.addClass(t,"datepicker__month-day--selected"),e?(this.start=s,this.end=!1):this.start&&(this.end=s),this.start&&this.end&&this.start>this.end){var a=this.end;this.end=this.start,this.start=a}this.start=parseInt(this.start,10),this.end=parseInt(this.end,10),this.clearHovering(),this.start&&!this.end&&this.dayHovering(t),this.updateSelectableRange(),this.checkSelection(),this.showSelectedInfo(),this.showSelectedDays(),this.autoclose(),this.onDayClick&&this.onDayClick(),this.end&&this.onSelectRange&&this.onSelectRange()}},e.prototype.isValidDate=function(t){if(t=parseInt(t,10),this.startDate&&this.compareDay(t,this.startDate)<0||this.endDate&&0<this.compareDay(t,this.endDate))return!1;if(this.start&&!this.end){if(0<this.maxDays&&this.countDays(t,this.start)>this.maxDays||0<this.minDays&&1<this.countDays(t,this.start)&&this.countDays(t,this.start)<this.minDays)return!1;if(this.selectForward&&t<this.start)return!1;if(0<this.disabledDates.length){var e=this.getClosestDates(new Date(parseInt(this.start,10)));if(e[0]&&this.compareDay(t,e[0])<=0)return!1;if(e[1]&&0<=this.compareDay(t,e[1]))return!1}}return!0},e.prototype.checkSelection=function(){var t=this,e=this.countDays(this.end,this.start),s=!!this.showTopbar&&this.datepicker.getElementsByClassName("datepicker__info--feedback")[0];if(this.maxDays&&e>this.maxDays){this.start=!1,this.end=!1;for(var a=this.datepicker.getElementsByTagName("td"),i=0;i<a.length;i++)t.removeClass(a[i],"datepicker__month-day--selected"),t.removeClass(a[i],"datepicker__month-day--first-day-selected"),t.removeClass(a[i],"datepicker__month-day--last-day-selected");if(this.showTopbar){var n=this.maxDays-1;this.topBarErrorText(s,"error-more",n)}}else if(this.minDays&&e<this.minDays){this.start=!1,this.end=!1;for(var o=this.datepicker.getElementsByTagName("td"),r=0;r<o.length;r++)t.removeClass(o[r],"datepicker__month-day--selected"),t.removeClass(o[r],"datepicker__month-day--first-day-selected"),t.removeClass(o[r],"datepicker__month-day--last-day-selected");if(this.showTopbar){var h=this.minDays-1;this.topBarErrorText(s,"error-less",h)}}else this.start||this.end?this.showTopbar&&(this.removeClass(s,"datepicker__info--error"),this.removeClass(s,"datepicker__info--help")):this.showTopbar&&(this.removeClass(s,"datepicker__info--error"),this.addClass(s,"datepicker__info--help"))},e.prototype.addDays=function(t,e){var s=new Date(t);return s.setDate(s.getDate()+e),s},e.prototype.countDays=function(t,e){return Math.abs(this.daysFrom1970(t)-this.daysFrom1970(e))+1},e.prototype.compareDay=function(t,e){var s=parseInt(this.getDateString(t,"YYYYMMDD"),10)-parseInt(this.getDateString(e,"YYYYMMDD"),10);return 0<s?1:0===s?0:-1},e.prototype.compareMonth=function(t,e){var s=parseInt(this.getDateString(t,"YYYYMM"),10)-parseInt(this.getDateString(e,"YYYYMM"),10);return 0<s?1:0===s?0:-1},e.prototype.daysFrom1970=function(t){return Math.floor(this.toLocalTimestamp(t)/864e5)},e.prototype.toLocalTimestamp=function(t){return"object"==typeof t&&t.getTime&&(t=t.getTime()),"string"!=typeof t||t.match(/\d{13}/)||(t=this.parseDate(t).getTime()),t=parseInt(t,10)-60*(new Date).getTimezoneOffset()*1e3},e.prototype.printAttributes=function(t){var e=t,s="";for(var a in t)Object.prototype.hasOwnProperty.call(e,a)&&(s+=a+'="'+e[a]+'" ');return s},e.prototype.goToNextMonth=function(t){var e=t.target.getAttribute("month"),s=1<e,a=s?this.month2:this.month1;a=this.getNextMonth(a),!this.isSingleMonth()&&!s&&0<=this.compareMonth(a,this.month2)||this.isMonthOutOfRange(a)||(this.moveBothMonths&&s&&this.showMonth(this.month2,1),this.showMonth(a,e),this.showSelectedDays(),this.disableNextPrevButtons())},e.prototype.goToPreviousMonth=function(t){var e=t.target.getAttribute("month"),s=1<e,a=s?this.month2:this.month1;a=this.getPrevMonth(a),s&&this.compareMonth(a,this.month1)<=0||this.isMonthOutOfRange(a)||(this.moveBothMonths&&!s&&this.showMonth(this.month1,2),this.showMonth(a,e),this.showSelectedDays(),this.disableNextPrevButtons())},e.prototype.isSingleMonth=function(){return!this.isVisible(this.getMonthDom(2))},e.prototype.isMonthOutOfRange=function(t){var e=new Date(t.valueOf());return!!(this.startDate&&new Date(e.getFullYear(),e.getMonth()+1,0,23,59,59)<this.startDate||this.endDate&&new Date(e.getFullYear(),e.getMonth(),1)>this.endDate)},e.prototype.disableNextPrevButtons=function(){if(!this.isSingleMonth()){var t=parseInt(this.getDateString(this.month1,"YYYYMM"),10),e=parseInt(this.getDateString(this.month2,"YYYYMM"),10),s=Math.abs(t-e),a=this.datepicker.getElementsByClassName("datepicker__month-button--next"),i=this.datepicker.getElementsByClassName("datepicker__month-button--prev");1<s&&89!==s?(this.removeClass(a[0],"datepicker__month-button--disabled"),this.removeClass(i[1],"datepicker__month-button--disabled")):(this.addClass(a[0],"datepicker__month-button--disabled"),this.addClass(i[1],"datepicker__month-button--disabled")),this.isMonthOutOfRange(this.getPrevMonth(this.month1))?this.addClass(i[0],"datepicker__month-button--disabled"):this.removeClass(i[0],"datepicker__month-button--disabled"),this.isMonthOutOfRange(this.getNextMonth(this.month2))?this.addClass(a[1],"datepicker__month-button--disabled"):this.removeClass(a[1],"datepicker__month-button--disabled")}},e.prototype.topBarDefaultText=function(){if(this.showTopbar){var t="";t=this.minDays&&this.maxDays?this.lang("info-range"):this.minDays&&2<this.minDays?this.lang("info-more-plural"):this.minDays?this.lang("info-more"):this.lang("info-default");var e=this.datepicker.getElementsByClassName("datepicker__info--feedback")[0];t=t.replace(/%d/,this.minDays-1).replace(/%d/,this.maxDays-1),this.addClass(e,"datepicker__info--help"),this.removeClass(e,"datepicker__info--error"),e.textContent=t}},e.prototype.topBarErrorText=function(t,e,s){this.showTopbar&&(this.addClass(t,"datepicker__info--error"),this.removeClass(t,"datepicker__info--help"),1<s?(e=(e=this.lang(e+"-plural")).replace("%d",s),t.textContent=e):e=this.lang(e),this.datepicker.getElementsByClassName("datepicker__info--selected")[0].style.display="none")},e.prototype.updateSelectableRange=function(){for(var t=this,e=this.datepicker.getElementsByTagName("td"),s=this.start&&!this.end,a=0;a<e.length;a++)if(t.hasClass(e[a],"datepicker__month-day--invalid")&&t.hasClass(e[a],"datepicker__month-day--tmp")&&(t.removeClass(e[a],"datepicker__month-day--tmp"),t.hasClass(e[a],"datepicker__month-day--tmpinvalid")?t.removeClass(e[a],"datepicker__month-day--tmpinvalid"):(t.removeClass(e[a],"datepicker__month-day--invalid"),t.addClass(e[a],"datepicker__month-day--valid"))),s){if(t.hasClass(e[a],"datepicker__month-day--visibleMonth")&&(t.hasClass(e[a],"datepicker__month-day--valid")||t.hasClass(e[a],"datepicker__month-day--disabled")||t.hasClass(e[a],"datepicker__month-day--before-disabled-date"))){var i=parseInt(e[a].getAttribute("time"),10);t.isValidDate(i)?(t.addClass(e[a],"datepicker__month-day--valid"),t.addClass(e[a],"datepicker__month-day--tmp"),t.removeClass(e[a],"datepicker__month-day--invalid"),t.removeClass(e[a],"datepicker__month-day--disabled")):(t.hasClass(e[a],"datepicker__month-day--invalid")&&t.addClass(e[a],"datepicker__month-day--tmpinvalid"),t.addClass(e[a],"datepicker__month-day--invalid"),t.addClass(e[a],"datepicker__month-day--tmp"),t.removeClass(e[a],"datepicker__month-day--valid"))}}else(t.hasClass(e[a],"datepicker__month-day--checkout-enabled")||t.hasClass(e[a],"datepicker__month-day--before-disabled-date"))&&(t.addClass(e[a],"datepicker__month-day--invalid"),t.removeClass(e[a],"datepicker__month-day--valid"),t.hasClass(e[a],"datepicker__month-day--before-disabled-date")||t.addClass(e[a],"datepicker__month-day--disabled"));return!0},e.prototype.dayHovering=function(t){var e=this,s=parseInt(t.getAttribute("time"),10),a="";if(!this.hasClass(t,"datepicker__month-day--invalid")){for(var i=this.datepicker.getElementsByTagName("td"),n=0;n<i.length;n++){var o=parseInt(i[n].getAttribute("time"),10);o===s?e.addClass(i[n],"datepicker__month-day--hovering"):e.removeClass(i[n],"datepicker__month-day--hovering"),e.start&&!e.end&&(e.start<o&&o<=s||e.start>o&&s<=o)?e.addClass(i[n],"datepicker__month-day--hovering"):e.removeClass(i[n],"datepicker__month-day--hovering")}if(this.start&&!this.end){var r=this.countDays(s,this.start)-1;if(this.hoveringTooltip)if("function"==typeof this.hoveringTooltip)a=this.hoveringTooltip(r,this.start,s);else if(!0===this.hoveringTooltip&&0<r){a=r+" "+(1===r?this.lang("night"):this.lang("nights"))}}}if(a){var h=t.getBoundingClientRect(),d=this.datepicker.getBoundingClientRect(),l=h.left-d.left,c=h.top-d.top;l+=h.width/2;var p=document.getElementById(this.getTooltipId());p.style.display="",p.textContent=a;var m=p.getBoundingClientRect().width,g=p.getBoundingClientRect().height;l-=m/2,c-=g,setTimeout(function(){p.style.left=l+"px",p.style.top=c+"px"},10)}else{document.getElementById(this.getTooltipId()).style.display="none"}},e.prototype.clearHovering=function(){for(var t=this.datepicker.getElementsByTagName("td"),e=0;e<t.length;e++)this.removeClass(t[e],"datepicker__month-day--hovering");document.getElementById(this.getTooltipId()).style.display="none"},e.prototype.clearSelection=function(){this.start=!1,this.end=!1;for(var t=this.datepicker.getElementsByTagName("td"),e=0;e<t.length;e++)this.removeClass(t[e],"datepicker__month-day--selected"),this.removeClass(t[e],"datepicker__month-day--first-day-selected"),this.removeClass(t[e],"datepicker__month-day--last-day-selected");this.setValue(""),this.checkSelection(),this.showSelectedInfo(),this.showSelectedDays()},e.prototype.parseDisabledDates=function(){var t=[];this.setFechaI18n();for(var e=0;e<this.disabledDates.length;e++)t[e]=fecha.parse(this.disabledDates[e],"YYYY-MM-DD");t.sort(function(t,e){return t-e}),this.disabledDatesTime=t},e.prototype.getClosestDates=function(t){var e=[!1,!1];if(t<this.disabledDatesTime[0])e=this.enableCheckout?[!1,this.addDays(this.disabledDatesTime[0],1)]:[!1,this.disabledDatesTime[0]];else if(t>this.disabledDatesTime[this.disabledDatesTime.length-1])e=[this.disabledDatesTime[this.disabledDatesTime.length-1],!1];else{var s,a=this.disabledDatesTime.length,i=this.disabledDatesTime.length,n=Math.abs(new Date(0,0,0).valueOf()),o=n,r=-n,h=0;for(s=0;s<this.disabledDatesTime.length;++s)(h=t-this.disabledDatesTime[s])<0&&r<h&&(i=s,r=h),0<h&&h<o&&(a=s,o=h);this.disabledDatesTime[a]&&(e[0]=this.disabledDatesTime[a]),void 0===this.disabledDatesTime[a]?e[1]=!1:this.enableCheckout?e[1]=this.addDays(this.disabledDatesTime[i],1):e[1]=this.disabledDatesTime[i]}return e},e.prototype.lang=function(t){return t in this.i18n?this.i18n[t]:""},e.prototype.emptyElement=function(t){for(;t.firstChild;)t.removeChild(t.firstChild)},e.prototype.classRegex=function(t){return new RegExp("(^|\\s+)"+t+"(\\s+|$)")},e.prototype.hasClass=function(t,e){return this.classRegex(e).test(t.className)},e.prototype.addClass=function(t,e){this.hasClass(t,e)||(t.className=t.className+" "+e)},e.prototype.removeClass=function(t,e){t.className=t.className.replace(this.classRegex(e)," ")},e.prototype.isVisible=function(t){return t.offsetWidth||t.offsetHeight||t.getClientRects().length},e.prototype.slideDown=function(t,e){t.style.display="";var s=t.getBoundingClientRect().height;t.style.height=0,this.recalc(t.offsetHeight),t.style.transition="height "+e,t.style.height=s+"px",t.addEventListener("transitionend",function(){t.style.height=t.style.transition=t.style.display=""})},e.prototype.slideUp=function(t,e){var s=t.getBoundingClientRect().height;t.style.height=s+"px",this.recalc(t.offsetHeight),t.style.transition="height "+e,t.style.height=0,t.addEventListener("transitionend",function(){t.style.display="none"})},e.prototype.recalc=function(t){return t.offsetHeight},e.prototype.isTouchDevice=function(){return"ontouchstart"in window||window.DocumentTouch&&document instanceof DocumentTouch},e.prototype.open=function(){this.openDatepicker()},e.prototype.close=function(){this.closeDatepicker()},e.prototype.getDatePicker=function(){return this.datepicker},e.prototype.setRange=function(t,e){"string"==typeof t&&"string"==typeof e&&(t=this.parseDate(t),e=this.parseDate(e)),this.setDateRange(t,e)},e.prototype.clear=function(){this.clearSelection()},e.prototype.getNights=function(){var t=0;if(this.start&&this.end)t=this.countDays(this.end,this.start)-1;else{var e=this.getValue(),s=e?e.split(this.separator):"";if(s&&2<=s.length){var a=this.format;a.match(/Do/)&&(a=a.replace(/Do/,"D"),s[0]=s[0].replace(/(\d+)(th|nd|st)/,"$1"),s[1]=s[1].replace(/(\d+)(th|nd|st)/,"$1")),t=this.countDays(this.parseDate(s[0],a),this.parseDate(s[1],a))-1}}return t},e.prototype.destroy=function(){document.getElementById(this.getDatepickerId())&&(this.removeAllBoundedListeners(this.input,"click"),this.removeAllBoundedListeners(document,"click"),this.removeAllBoundedListeners(this.input,"change"),this.datepicker.parentNode.removeChild(this.datepicker))},e}();
