

<div class="app-page-title">
    <div class="page-title-wrapper">
        <div class="page-title-heading">
            <div class="page-title-icon">
                <i class="pe-7s-notebook text-success"></i>
            </div>
            <div><?php echo l('Import'); ?>

            </div>
        </div>
    </div>
</div>


<div class="main-card card">
    <div class="card-body">

        <div id="import-form-section">
            <h4><?php echo l('Import zip file:'); ?> </h4>

            Download zip template <a target="_blank" href="/upload/import-template.zip">here.</a>
            <br/><br/><br/>

            <form id="import-form" enctype="multipart/form-data">
                <input type="file" name="file" id="import-file" accept=".zip">
                <br>
                <input type="checkbox" id="old_data" name="remove_old_data" value="1">
                <label for="old_data"><?php echo l('Remove old data (Recommended)'); ?></label><br>
                <br/>
                <button type="button" id="start-import-btn" class="btn btn-primary">Start Import</button>
            </form>
        </div>

        <div id="import-progress-section" style="display: none;">
            <h4><?php echo l('Import Progress'); ?></h4>

            <div class="progress" style="height: 25px; margin-bottom: 20px;">
                <div id="import-progress-bar" class="progress-bar progress-bar-striped progress-bar-animated"
                     role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                    0%
                </div>
            </div>

            <div id="import-status" style="margin-bottom: 20px;">
                <p id="current-step-text">Preparing...</p>
            </div>

            <div id="import-log" style="background: #f5f5f5; padding: 15px; border-radius: 5px; max-height: 300px; overflow-y: auto;">
                <ul id="import-log-list" style="list-style: none; padding: 0; margin: 0;">
                </ul>
            </div>
        </div>

        <div id="import-complete-section" style="display: none;">
            <div class="alert alert-success">
                <h4><i class="fa fa-check-circle"></i> Import Completed Successfully!</h4>
                <p>All data has been imported.</p>
            </div>
            <a href="<?php echo base_url(); ?>booking" class="btn btn-primary">Go to Calendar</a>
        </div>

        <div id="import-error-section" style="display: none;">
            <div class="alert alert-danger">
                <h4><i class="fa fa-times-circle"></i> Import Failed</h4>
                <p id="import-error-message"></p>
            </div>
            <button type="button" class="btn btn-primary" onclick="location.reload();">Try Again</button>
        </div>

    </div>
</div>

<script>
// Wait for jQuery to be available
(function checkJQuery() {
    if (typeof jQuery === 'undefined') {
        setTimeout(checkJQuery, 50);
        return;
    }

    $(document).ready(function() {
        var importSteps = [];
        var currentStepIndex = 0;
        var totalSteps = 0;
        var removeOldData = false;
        var importStartTime = null;

    $('#start-import-btn').click(function() {
        var fileInput = $('#import-file')[0];

        if (!fileInput.files || !fileInput.files[0]) {
            alert('Please select a ZIP file to import');
            return;
        }

        removeOldData = $('#old_data').is(':checked');
        importStartTime = new Date();

        // Show progress section
        $('#import-form-section').hide();
        $('#import-progress-section').show();

        // Start upload
        uploadZipFile(fileInput.files[0]);
    });

    function uploadZipFile(file) {
        updateStatus('Uploading ZIP file...', 'info');
        addLogEntry('Uploading ZIP file (chunked)...', 'info');

        var chunkSize = 2 * 1024 * 1024; // 2MB chunks
        var totalChunks = Math.ceil(file.size / chunkSize);
        var currentChunk = 0;
        var uploadId = Date.now() + '_' + Math.random().toString(36).substr(2, 9);

        function uploadNextChunk() {
            var start = currentChunk * chunkSize;
            var end = Math.min(start + chunkSize, file.size);
            var chunk = file.slice(start, end);

            var formData = new FormData();
            formData.append('chunk', chunk);
            formData.append('chunk_index', currentChunk);
            formData.append('total_chunks', totalChunks);
            formData.append('upload_id', uploadId);
            formData.append('file_name', file.name);

            var progressText = 'Uploading chunk ' + (currentChunk + 1) + ' of ' + totalChunks;
            updateStatus(progressText + '...', 'info');

            $.ajax({
                url: getBaseURL() + 'settings/company/import_upload_chunk_ajax',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        currentChunk++;
                        if (currentChunk < totalChunks) {
                            uploadNextChunk();
                        } else {
                            addLogEntry('All chunks uploaded', 'success');
                            finalizeUpload(uploadId, file.name);
                        }
                    } else {
                        showError(response.message);
                    }
                },
                error: function(xhr, status, error) {
                    showError('Upload chunk failed: ' + error);
                }
            });
        }

        uploadNextChunk();
    }

    function finalizeUpload(uploadId, fileName) {
        updateStatus('Processing ZIP file...', 'info');
        addLogEntry('Extracting ZIP file...', 'info');

        $.ajax({
            url: getBaseURL() + 'settings/company/import_finalize_upload_ajax',
            type: 'POST',
            data: {
                upload_id: uploadId,
                file_name: fileName
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    addLogEntry('ZIP file uploaded and extracted', 'success');
                    importSteps = response.steps;
                    totalSteps = response.total_steps + (removeOldData ? 2 : 1);
                    currentStepIndex = 0;

                    if (removeOldData) {
                        deleteOldData();
                    } else {
                        processNextStep();
                    }
                } else {
                    showError(response.message);
                }
            },
            error: function(xhr, status, error) {
                showError('Failed to process ZIP: ' + error);
            }
        });
    }

    function deleteOldData() {
        updateStatus('Deleting old data...', 'warning');
        addLogEntry('Deleting old data...', 'info');
        updateProgress(1, totalSteps);

        $.ajax({
            url: getBaseURL() + 'settings/company/import_delete_old_data_ajax',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    addLogEntry('Old data deleted', 'success');
                    processNextStep();
                } else {
                    showError(response.message);
                }
            },
            error: function(xhr, status, error) {
                showError('Failed to delete old data: ' + error);
            }
        });
    }

    function processNextStep(batchOffset) {
        batchOffset = batchOffset || 0;

        if (currentStepIndex >= importSteps.length) {
            // All steps completed, run cleanup
            runCleanup();
            return;
        }

        var step = importSteps[currentStepIndex];
        var stepNumber = (removeOldData ? 2 : 1) + currentStepIndex + 1;

        if (batchOffset === 0) {
            updateStatus('Importing ' + step.label + '...', 'info');
            addLogEntry('Importing ' + step.label + '...', 'info');
        }
        updateProgress(stepNumber, totalSteps);

        $.ajax({
            url: getBaseURL() + 'settings/company/import_step_ajax',
            type: 'POST',
            data: {
                step_name: step.name,
                file_name: step.file,
                batch_offset: batchOffset
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    if (response.has_more) {
                        // More batches to process for this step
                        var progressText = response.processed + ' of ' + response.total + ' rows';
                        updateStatus('Importing ' + step.label + '... (' + progressText + ')', 'info');
                        processNextStep(response.next_offset);
                    } else {
                        // Step complete, move to next
                        addLogEntry(step.label + ' imported (' + response.processed + ' rows)', 'success');
                        currentStepIndex++;
                        processNextStep(0);
                    }
                } else {
                    showError(response.message);
                }
            },
            error: function(xhr, status, error) {
                showError('Failed to import ' + step.label + ': ' + error);
            }
        });
    }

    function runCleanup() {
        updateStatus('Finishing up...', 'info');
        addLogEntry('Cleaning up temporary files...', 'info');
        updateProgress(totalSteps, totalSteps);

        $.ajax({
            url: getBaseURL() + 'settings/company/import_cleanup_ajax',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    addLogEntry('Import completed!', 'success');
                    showComplete();
                } else {
                    showError(response.message);
                }
            },
            error: function(xhr, status, error) {
                showError('Cleanup failed: ' + error);
            }
        });
    }

    function updateProgress(current, total) {
        var percent = Math.round((current / total) * 100);
        $('#import-progress-bar').css('width', percent + '%').text(percent + '%').attr('aria-valuenow', percent);
    }

    function updateStatus(message, type) {
        var icon = '';
        switch(type) {
            case 'info': icon = '<i class="fa fa-spinner fa-spin"></i> '; break;
            case 'warning': icon = '<i class="fa fa-exclamation-triangle"></i> '; break;
            case 'success': icon = '<i class="fa fa-check"></i> '; break;
        }
        $('#current-step-text').html(icon + message);
    }

    function addLogEntry(message, type) {
        var colorClass = '';
        var icon = '';
        switch(type) {
            case 'info': colorClass = 'text-primary'; icon = '<i class="fa fa-info-circle"></i> '; break;
            case 'success': colorClass = 'text-success'; icon = '<i class="fa fa-check-circle"></i> '; break;
            case 'error': colorClass = 'text-danger'; icon = '<i class="fa fa-times-circle"></i> '; break;
            case 'warning': colorClass = 'text-warning'; icon = '<i class="fa fa-exclamation-circle"></i> '; break;
        }

        var timestamp = new Date().toLocaleTimeString();
        $('#import-log-list').append('<li class="' + colorClass + '">[' + timestamp + '] ' + icon + message + '</li>');

        // Auto-scroll to bottom
        var logDiv = $('#import-log');
        logDiv.scrollTop(logDiv[0].scrollHeight);
    }

    function showComplete() {
        // Calculate elapsed time
        var endTime = new Date();
        var elapsedMs = endTime - importStartTime;
        var elapsedSec = Math.floor(elapsedMs / 1000);
        var minutes = Math.floor(elapsedSec / 60);
        var seconds = elapsedSec % 60;
        var timeStr = '';
        if (minutes > 0) {
            timeStr = minutes + ' minute' + (minutes > 1 ? 's' : '') + ' ' + seconds + ' second' + (seconds !== 1 ? 's' : '');
        } else {
            timeStr = seconds + ' second' + (seconds !== 1 ? 's' : '');
        }

        $('#import-complete-section .alert p').html('All data has been imported in <strong>' + timeStr + '</strong>.');
        $('#import-progress-section').hide();
        $('#import-complete-section').show();
    }

    function showError(message) {
        addLogEntry(message, 'error');
        $('#import-error-message').text(message);
        $('#import-progress-section').hide();
        $('#import-error-section').show();
    }
    });
})();
</script>
