<?php

class Asaas_model extends CI_Model {

    function __construct()
    {
        parent::__construct();
    }
    
    function get_booking_details($asaas_payment_id)
    {
        $this->db->select('b.*');
        $this->db->where('p.gateway_charge_id', $asaas_payment_id);
        $this->db->from('payment as p');
        $this->db->join('booking as b', "b.booking_id = p.booking_id", 'right');
        $query = $this->db->get();
        if($query->num_rows() >= 1){
            return $query->row_array();
        }
        return NULL;
    }

    function get_hoteli_pay_bank_details($company_id)
    {
        $this->db->from('hoteli_pay_bank_details');
        $this->db->where('company_id', $company_id);

        $query = $this->db->get();
        if($query->num_rows() >= 1){
            return $query->row_array();
        }
        return NULL;
    }

    function update_hoteli_pay_bank_details($data)
    {
        $data = (object) $data;
        $this->db->where('company_id', $data['company_id']);
        $this->db->update("hoteli_pay_bank_details", $data);

        if($this->db->affected_rows() > 0){
            return true;
        } else {
            return false;
        }
    }

    function save_hoteli_pay_bank_details($data)
    {
        $data = (object)$data;
        $this->db->insert("hoteli_pay_bank_details", $data);

        if ($this->db->_error_message())
        {
            show_error($this->db->_error_message());
        }
      
        $query = $this->db->query('select LAST_INSERT_ID( ) AS last_id');
        $result = $query->result_array();
        
        if(isset($result[0]))
        {  
            return $result[0]['last_id'];
        }
        else
        {  
            return null;
        }
    }
	
	  function getCustomOptions($company_id, $option_name)
    {			
	 $this->db->where('company_id', $company_id);
	$this->db->where('option_name', $option_name);
	$has_options = $this->db->get('options')->row();

	   if($has_options){  
            return $has_options->option_value;
        } else {  
            return null;
        }
	}
	
	  function insertCustomOption($company_id, $option_value)
	  {
	 $options_data = [
	 "option_name" => 'asaas_sale_comission',
	 "option_value" => $option_value,
	 "company_id" => $company_id,
	 ];	 
        $this->db->insert('options', $options_data);    
    // 
	  if($this->db->affected_rows() > 0){
            return true;
        } else {
            return false;
        }
	  }
	  
	    function updateCustomOption($company_id, $option_value, $option_name)
	  {
		   $options_data = [
	 "option_value" => $option_value,
	 ];
	  $this->db->where('company_id', $company_id);
	  $this->db->where('option_name', $option_name);
      $this->db->update('options', $options_data);
	  
	    if($this->db->affected_rows() > 0){
            return true;
        } else {
            return false;
        }
	  }
	
    function deconfigure_hotelipay_apikey($company_id){

        $this->db->where('company_id', $company_id);
        $this->db->where('selected_payment_gateway', 'asaas');
        $this->db->delete('company_payment_gateway');
    }
}
