<?php

// add_filter('post.add.customer', 'nexio_tokenize', 10, 1);
// add_filter('post.add.pci_customer', 'create_nexio_customer', 10, 1);

function nexio_tokenize($data)
{

    $filtered_data = $data;
    $customer_data = $filtered_data['customer_data'];
    unset($filtered_data['customer_data']);

    $CI = &get_instance();
    $CI->load->model('../extensions/nexio_integration/models/Payment_gateway_model');
    $CI->load->library('../extensions/nexio_integration/libraries/ProcessPayment');
    $gateway_data = $CI->Payment_gateway_model->get_payment_gateway_settings($customer_data['company_id']);
    $nexio_secret_key = json_decode($gateway_data['gateway_meta_data'])->nexio_secret_key;
    $token_response = $CI->processpayment->create_token($nexio_secret_key);

    if ($token_response['success']) {
        $customer_card_data = array(
            "cardholder_name" => $filtered_data['card']['cardholder_name'],
            "service_code" => $filtered_data['card']['service_code'],
            "card_number" => $filtered_data['card']['card_number'],
            "expiration_month" => $filtered_data['card']['expiration_month'],
            "expiration_year" => $filtered_data['card']['expiration_year'],
            "one_time_token" => $token_response['data'],
            "billToAddressOne" => $customer_data['address'] ?? "",
            "billToAddressTwo" => $customer_data['address2'] ?? '',
            "billToCity" => $customer_data['city'] ?? '',
            "billToCountry" => $customer_data['country'] ?? '',
            "billToPhone" => $customer_data['phone'] ?? '',
            "billToPostal" => $customer_data['postal_code'] ?? '',
            "billToState" => $customer_data['region'] ?? '',
            "customerRef" => $customer_data['customer_id'] ?? '',
            "email" => $customer_data['email'] ?? '',
            "firstName" => $customer_data['customer_name'] ?? '',
            "phone" => $customer_data['phone'] ?? '',
            "customFields" => $customer_data['customer_id'] ?? '',
        );
        $response = $CI->processpayment->save_card_token($customer_card_data);

        if ($response['success']) {
            $card_details = array(
                'is_primary' => 1,
                'customer_id' => $customer_data['customer_id'],
                'customer_name' => $customer_data['customer_name'],
                'card_name' => '',
                'company_id' => $customer_data['company_id'],
                'cc_expiry_month' => $customer_data['cc_expiry_month'] ?? null,
                'cc_expiry_year' => $customer_data['cc_expiry_year'] ?? null,
            );

            $card_details['cc_cvc_encrypted'] = null;
            $card_details['cc_number'] = 'XXXX XXXX XXXX ' . substr($filtered_data['card']['card_number'], -4);
            $meta['nexio_token'] = $response['card_token'];
            $meta['token'] = $response['card_token'];
            $card_details['customer_meta_data'] = json_encode($meta);

            $cust_data = $CI->Card_model->get_card_details($customer_data['customer_id'], $customer_data['company_id']);
            
            if($cust_data){
                $CI->Card_model->update_customer_card($cust_data['id'], $cust_data['customer_id'], $card_details);
            } else {
                $CI->Card_model->create_customer_card_info($card_details);
            }
        }
    }

    if (isset($response) && $response) {
        $data['tokenization_response'] = $response;
    }

    return $data;
}



/**
 * @param $api_url
 * @param $data
 * @param $headers
 * @param $method
 * @return array response
 */
if (!function_exists('call_api')) {
    function call_api($api_url, $data, $headers, $method_type = 'POST')
    {

        $url = $api_url;

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        if ($method_type == 'GET') {

        } else {
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
        }

        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($curl);

        curl_close($curl);

        return $response;
    }
}
