<?php
class Integrations extends MY_Controller
{
    public $module_name;
	function __construct()
	{

        parent::__construct();
        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Payment_gateway_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Employee_log_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Company_model');
        $this->load->model('Payment_model');
        $this->load->model('Invoice_log_model');
        $this->load->model('Booking_model');
        $this->load->model('Customer_model');
        $this->load->model('Card_model');
        $this->load->library('../extensions/'.$this->module_name.'/libraries/ProcessPayment');
        
		$view_data['menu_on'] = true;

		$this->load->vars($view_data);
	}	

	function worldline_payment_gateway()
    {       
        $data['main_content'] = '../extensions/'.$this->module_name.'/views/payment_gateway_settings';
        $data['credentials'] = $this->processpayment->getGatewayCredentials();
        // $data['gateway_list'] = $this->processpayment->getGatewaysList();
        // prx($data);
        $this->load->view('includes/bootstrapped_template', $data);
    }

    function get_worldline_payment_gateway_settings() {
        $data = $this->processpayment->getGatewayCredentials();
        echo json_encode($data);
    }

    function get_card_details(){
        $card_number = $this->input->post('card_number');

        $info = $this->getCardInfo($card_number);
        echo json_encode($info);
    }

    function getCardInfo(string $cardNumber)
    {
        $cleanNumber = preg_replace('/\D/', '', $cardNumber);
        $bin = substr($cleanNumber, 0, 6);
        
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL            => "https://data.handyapi.com/bin/{$bin}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 10,
        ]);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode !== 200) {
            return ['error' => 'BIN not found'];
        }
        
        $data = json_decode($response, true);
        
        return [
            'card_type' => $data['Type'] ?? 'unknown',      // "DEBIT" or "CREDIT"
            'brand'     => $data['Scheme'] ?? 'unknown',
            'bank'      => $data['Issuer'] ?? 'Unknown',
            'country'   => $data['Country']['Name'] ?? 'Unknown',
        ];
    }
	
    function update_worldline_payment_gateway_setting() {
       foreach($_POST as $key => $value)
        {
            if(
                $key != 'merchant_id' &&
                $key != 'api_passcode' &&
                $key != 'environment'
            )
            {
                $data[$key] = $this->input->post($key);
            }
        }

        $meta = array(
            "merchant_id" => $_POST['merchant_id'],
            "api_passcode" => $_POST['api_passcode'],
            "environment" => $_POST['environment']
        );

        $data['gateway_meta_data'] = json_encode($meta);
        
        $data['company_id'] = $this->company_id;
        $this->Payment_gateway_model->update_payment_gateway_settings($data);
        $this->_create_accounting_log("Update Payment Gateway Setting");
        
        echo json_encode($data);
    }

    function _create_accounting_log($log) {
        $log_detail =  array(
                    "user_id" => $this->user_id,
                    "selling_date" => $this->selling_date,
                    "date_time" => gmdate('Y-m-d H:i:s'),
                    "log" => $log,
                );   
        
        $this->Employee_log_model->insert_log($log_detail);     
    }

    function check_worldline_token_availability(){
        $customer_id = $this->input->post('customer_id');
        $customer_details = $this->Card_model->get_customer_cards($customer_id);

        $response = array('success' => false);

        $card_data = json_decode($customer_details[0]['customer_meta_data'], true);

        if (
            isset($card_data['source'], $card_data['token']) &&
            $card_data['source'] === 'worldline' &&
            !empty($card_data['token'])
        ) {
            $response['success'] = true;
        }

        echo json_encode($response);
    }

    function create_worldline_card_profile()
    {

        $customer_data = $this->input->post('data');
        $customer_id = "";
        $create_worldline_card_profile = "";

        // if(
        //     isset($customer_data['create_worldline_card_profile']) &&
        //     $customer_data['create_worldline_card_profile'] == 'invoice_page'
        // ){
        //     $create_worldline_card_profile = 'invoice_page';
        //     unset($customer_data['create_worldline_card_profile']);
        // }

        if(
            isset($customer_data['customer_id']) &&
            $customer_data['customer_id']
        ) {
            $customer_id = $customer_data['customer_id'];
            $customer_details = $this->Customer_model->get_customer($customer_data['customer_id']);

            $customer_data = array_merge($customer_data, $customer_details);
        }

        // echo "customer_datass = ";prx($customer_data);echo " = customer_datasss";
        $create_card_profile = $this->processpayment->createWorldlineCardProfile($customer_data);


        if(
            $create_card_profile['success'] &&
            $create_card_profile['profile_code']
        ) {

            $data['success'] = true;
            $data['token'] = $customer_data['worldline_token'];
            $data['profile_code'] = $create_card_profile['profile_code'];

            if($customer_id){
                unset($data['success']);
                $data['source'] = 'worldline';
                $update_data['customer_meta_data'] = json_encode($data);


                // if($create_square_customer_from == 'invoice_page'){
                //     $update_data['cc_number'] = "XXXX XXXX XXXX " . $customer_data['square_lastfour'];
                //     $update_data['cc_expiry_month'] = $customer_data['square_exp_month'];
                //     $update_data['cc_expiry_year'] = $customer_data['square_exp_year'];
                // }

                $this->Card_model->update_customer_primary_card($customer_id, $update_data);

            } else {
                echo json_encode($data);
            }
        }
    }

    function add_worldline_token(){
        $customer_data = $this->input->post('data');

        $customer_id = $customer_data['customer_id'];
        $create_stripe_customer_from = "";

        if(
            isset($customer_data['create_stripe_customer_from']) &&
            $customer_data['create_stripe_customer_from'] == 'invoice_page'
        ){
            $create_stripe_customer_from = 'invoice_page';
            unset($customer_data['create_stripe_customer_from']);
        }

        // if(
        //     isset($customer_data['customer_id']) &&
        //     $customer_data['customer_id']
        // ) {
        //     $customer_id = $customer_data['customer_id'];
        $customer_details = $this->Customer_model->get_customer($customer_data['customer_id']);

        //     $customer_data = array_merge($customer_data, $customer_details);
        // }

        // // echo "customer_data = ";prx($customer_data);echo " = customer_datasss";
        // $create_customer = $this->processpayment->crateSquareCustomer($customer_data);

        if(
            $customer_data['stripe_token'] &&
            $customer_data['stripe_exp_month'] &&
            $customer_data['stripe_exp_year'] &&
            $customer_data['stripe_lastfour']
        ) {

            $data['success'] = true;
            $data['token'] = $customer_data['stripe_token'];

            if($customer_id){
                unset($data['success']);
                $data['source'] = 'stripe';

                if($create_stripe_customer_from == 'invoice_page'){
                    $card_details = array(
                       'is_primary' => 1,
                       'customer_id' => $customer_id,
                       'customer_name' => $customer_details['customer_name'],
                       'card_name' => '',
                       'company_id' => $this->company_id,
                       'cc_number' => "XXXX XXXX XXXX " . $customer_data['stripe_lastfour'],
                       'cc_expiry_month' => (isset($customer_data['stripe_exp_month']) ? $customer_data['stripe_exp_month'] : NULL),
                       'cc_expiry_year' => (isset($customer_data['stripe_exp_year']) ? $customer_data['stripe_exp_year'] : NULL)
                    );

                    $card_details['customer_meta_data'] = json_encode($data);
                }

                $existing_card_data = $this->Card_model->get_active_card($customer_id, $this->company_id);

                $card_id = $existing_card_data['id'];

                if(!empty($existing_card_data)){
                    $this->Card_model->update_customer_card_info($customer_id, $card_details, $card_id);
                } else{
                    $this->Card_model->create_customer_card_info($card_details);
                }

            } else {
                echo json_encode($card_details);
            }
        }
    }

    function add_worldline_payment(){
        $data = Array(
            "user_id" => $this->session->userdata('user_id'),
            "booking_id" => $this->input->post('booking_id'),
            "selling_date" => date('Y-m-d', strtotime($this->input->post('payment_date'))),
            "amount" => $this->input->post('payment_amount'),
            "customer_id" => $this->input->post('customer_id'),
            "payment_type_id" => $this->input->post('payment_type_id'),
            "description" => $this->input->post('description'),
            "date_time" => gmdate("Y-m-d H:i:s"),
            "selected_gateway" => $this->input->post('selected_gateway'),
            "worldline_pre_auth" => $this->input->post('worldline_pre_auth')
        );

        // prx($data);

        $payment_folio_id = $this->input->post('folio_id');
        $payment_folio_id = $payment_folio_id ? $payment_folio_id : 0;
        $card_data = $this->Card_model->get_active_card($data['customer_id'], $this->company_id);
        $data['credit_card_id'] = null;
        if (isset($card_data) && $card_data) {
            $data['credit_card_id'] = $card_data['id'];
        }

        $payment_type_id               = &$data['payment_type_id'];
        $use_gateway                   = ($payment_type_id == 'gateway');

        if($use_gateway){

            $payment_type    = $this->processpayment->getPaymentGatewayPaymentType($data['selected_gateway']);
            $payment_type_id = $payment_type['payment_type_id'];

            $gateway_charge_id = $this->processpayment->createBookingCharge(
                $data['booking_id'],
                abs($data['amount']), // in cents, only positive
                $data['customer_id'],
                $data['worldline_pre_auth']
            );

            $error = $this->processpayment->getErrorMessage();
        }

        // if(isset($gateway_charge_id[0]) && isset($gateway_charge_id[0]['code'])){
        //     $error = $gateway_charge_id;
        // } else if($gateway_charge_id == 'Tokenization service is not available.'){
        //     $error = $gateway_charge_id;
        // }

        // prx($gateway_charge_id, 1);
        
        if ($use_gateway && $gateway_charge_id) {
            $data['payment_gateway_used'] = $this->processpayment->getSelectedGateway();
            $data['gateway_charge_id'] = $gateway_charge_id;

            $data['is_captured'] = 1;
            if(
                isset($data['worldline_pre_auth']) && 
                $data['worldline_pre_auth'] == 1
            ){
                $data['is_captured'] = 0;
            }
            
            $data['description'] = isset($data['description']) && $data['description'] ? $data['description'].'<br/>' : '';

            // insert payment
        
            $data['payment_status'] = 'charge';
            // if(
            //     isset($data['worldline_pre_auth']) && 
            //     $data['worldline_pre_auth'] == 1
            // ){
            //     $data['payment_status'] = 'pre_auth';
            // }

            unset($data['selected_gateway']);
            unset($data['worldline_pre_auth']);

            $this->db->insert('payment', $data);    
            $query = $this->db->query('select LAST_INSERT_ID( ) AS last_id');
            $result = $query->result_array();
            if(isset($result[0]))
            {
                $payment_id = $result[0]['last_id'];
            }

            $invoice_log_data = array();
            $invoice_log_data['date_time'] = gmdate('Y-m-d h:i:s');
            $invoice_log_data['booking_id'] = $this->input->post('booking_id');
            $invoice_log_data['user_id'] = $this->session->userdata('user_id');
            $invoice_log_data['action_id'] = CAPTURED_PAYMENT;
            $invoice_log_data['charge_or_payment_id'] = $payment_id;
            $invoice_log_data['new_amount'] = $this->input->post('payment_amount');
            if ($payment_id && $invoice_log_data['charge_or_payment_id']) {
                $this->Payment_model->insert_payment_folio(array('payment_id' => $payment_id, 'folio_id' => $payment_folio_id));
                $invoice_log_data['log'] = 'Payment Captured';
                $this->Invoice_log_model->insert_log($invoice_log_data);
            }
            else {
                $invoice_log_data['charge_or_payment_id'] = 0;
                $invoice_log_data['log'] = isset($error) && $error ? $error : '';
                $this->Invoice_log_model->insert_log($invoice_log_data);
            }

            $this->Booking_model->update_booking_balance($data['booking_id']);
        }

        // show error
        if (!empty($error)) {
            $response = array("success" => false, "message" => $error);
        } else {
            $response = array("success" => true, "payment_id" => $payment_id);
        }

        echo json_encode($response);
    }

}	
