var worldlineGateway = false;

document.addEventListener("post.open_customer_model", function (e) {
    console.log('e', e);
    console.log('e.detail', e.detail);
    console.log('e.detail.customer_id', e.detail.customer_id);

    // Hide CC fields if customer new or fields empty
    if (
        (e && e.detail && e.detail.customer_id == '') ||
        ($('#cc_number').val() == '' &&
         $('input[name="cc_expiry"]').val() == '' &&
         $('input[name="cvc"]').val() == '')
    ) {
        $('.cc_field').css('display', 'none');

        var worldline_card_button = '<div class="form-group form-group-sm worldline_card_button">'+
                                        '<label for="worldline_card_data" class="col-sm-3 control-label">Card Details</label>'+
                                        '<div class="col-sm-9">'+
                                            '<button type="button" class="btn btn-info worldline_card_btn" onclick="show_worldline_iframe()">Add Card Details</button>'+
                                        '</div>'+
                                    '</div>';

        $('.form-group.form-group-sm.customer_field_12').after(worldline_card_button);
    } else {
        $('.cc_field').css('display', 'block');
    }
});

function show_worldline_iframe() {

    /* -------------------------------------------------
     * Prevent double load
     * ------------------------------------------------- */
    if (window.worldlineInitialized) return;
    window.worldlineInitialized = true;

    /* -------------------------------------------------
     * CSS
     * ------------------------------------------------- */
    if (!document.getElementById('worldline-css')) {
        const style = document.createElement('style');
        style.id = 'worldline-css';
        style.innerHTML = `
            #payment-form {
                max-width: 420px;
            }
            #card-number,
            #card-expiry,
            #card-cvv {
                height: 44px;
                padding: 10px;
                border: 1px solid #dcdcdc;
                border-radius: 4px;
                background: #fff;
                margin-bottom: 12px;
                box-sizing: border-box;
            }
            #card-number:focus-within,
            #card-expiry:focus-within,
            #card-cvv:focus-within {
                border-color: #6772e5;
                box-shadow: 0 0 0 1px #6772e5;
            }

            .bambora-checkoutfield iframe {
                width: 100% !important;
                height: 100% !important;
                border: none;
            }

            #card-button {
                background: #6772e5;
                color: #fff;
                border: none;
                padding: 10px 16px;
                border-radius: 4px;
                cursor: pointer;
                font-size: 14px;
            }

            #card-button:hover {
                background: #5469d4;
            }

            #payment-status-container {
                margin-bottom: 10px;
                font-size: 13px;
            }
        `;
        document.head.appendChild(style);
    }

    /* -------------------------------------------------
     * HTML
     * ------------------------------------------------- */

    $('.worldline_card_btn').parent('div').remove();

    $('.worldline_card_button').append(`
        <div class="col-sm-9">
            <label>Card Number Verification</label>
            <div id="" class="" style="display: flex; gap: 10px;"><input class="form-control" type="text" name="card_number_verify" id="card_number_verify" inputmode="numeric" maxlength="19" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(.{4})/g, '$1 ').trim()" placeholder="**** **** **** ****" style="flex: 1;" /><button id="verification-button" type="button" class="btn btn-primary">Check</button></div>
            <div id="card-info" style="display: none; margin-top: 10px; padding: 12px 15px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 8px; color: #fff; font-size: 14px;">
                <div style="display: flex; flex-wrap: wrap; gap: 15px;">
                    <div style="flex: 1; min-width: 120px;"><span style="font-size: 11px; opacity: 0.8; display: block;">Card Type</span><span id="card-type-value" style="font-weight: 600; font-size: 16px;"></span></div>
                    <div style="flex: 1; min-width: 120px;"><span style="font-size: 11px; opacity: 0.8; display: block;">Brand</span><span id="card-brand-value" style="font-weight: 600; font-size: 16px;"></span></div>
                    <div style="flex: 1; min-width: 120px;"><span style="font-size: 11px; opacity: 0.8; display: block;">Bank</span><span id="card-bank-value" style="font-weight: 600; font-size: 16px;"></span></div>
                    <div style="flex: 1; min-width: 120px;"><span style="font-size: 11px; opacity: 0.8; display: block;">Country</span><span id="card-country-value" style="font-weight: 600; font-size: 16px;"></span></div>
                </div>
            </div>

            <div id="payment-form">
                <div id="payment-status-container"></div>

                <div style="display:none" id="worldline-token"></div>
                <div style="display:none" id="worldline-exp_month"></div>
                <div style="display:none" id="worldline-exp_year"></div>
                <div style="display:none" id="worldline-lastfour"></div>

                <label>Card Number</label>
                <div id="card-number"></div>

                <label>Expiry Date</label>
                <div id="card-expiry"></div>

                <label>CVV</label>
                <div id="card-cvv"></div>

                <button style="display:none;" id="card-button" type="button">Save</button>
            </div>
        </div>
    `);


    console.log('worldlineMerchantId',innGrid.featureSettings.worldlineMerchantId);
    console.log('worldlineEnvironment',innGrid.featureSettings.worldlineEnvironment);
    /* -------------------------------------------------
     * Init Bambora Custom Checkout
     * ------------------------------------------------- */
    var customCheckout = customcheckout({
        merchantId: innGrid.featureSettings.worldlineMerchantId,
        environment: innGrid.featureSettings.worldlineEnvironment
    });

    customCheckout.create('card-number').mount('#card-number');
    customCheckout.create('expiry').mount('#card-expiry');
    customCheckout.create('cvv').mount('#card-cvv');

    worldlineGateway = true;

    /* -------------------------------------------------
     * Tokenize (ONLY VALID WAY)
     * ------------------------------------------------- */
    document.getElementById('card-button').addEventListener('click', function () {

        const status = document.getElementById('payment-status-container');
        this.textContent = 'Processing...';

        customCheckout.createToken(function (result) {

            console.log('Worldline result:', result);

            if (result.error) {
                status.innerHTML = '❌ ' + result.error.message;
                document.getElementById('card-button').textContent = 'Save';
                return;
            }

            // if (!result.token.startsWith('c50-')) {
            //     status.innerHTML = '❌ Invalid card token. Please retry.';
            //     document.getElementById('card-button').textContent = 'Save';
            //     return;
            // }

            document.getElementById('worldline-token').innerHTML = result.token;
            document.getElementById('worldline-exp_month').innerHTML = result.expiryMonth;
            document.getElementById('worldline-exp_year').innerHTML = result.expiryYear;
            document.getElementById('worldline-lastfour').innerHTML = result.last4;

            // ✅ SUCCESS
            status.innerHTML = '✅ Card tokenized';
            document.getElementById('card-button').style.display = 'none';

            console.log('Token:', result.token);
            console.log('Last4:', result.last4);
            console.log('Exp:', result.expiryMonth + '/' + result.expiryYear);

            // Store these or send to backend
        });
    });
}

$(document).ready(function(){

    $('body').on('click', '#verification-button', function(){
    var cardNumber = $('#card_number_verify').val().replace(/\s/g, '');
    if(cardNumber.length < 6) { alert('Please enter a valid card number'); return; }
    
    $.ajax({
        url    : getBaseURL() + 'get_card_details',
        method : 'post',
        dataType: 'json',
        data   : {
            card_number: cardNumber
        },
        success: function (data) { 
            console.log('response', data);
            
            $('#card-type-value').text(data.card_type || '-');
            $('#card-brand-value').text(data.brand || '-');
            $('#card-bank-value').text(data.bank || '-');
            $('#card-country-value').text(data.country || '-');
            
            $('#card-info').slideDown();
        }
    });
});


});