
var settings;
innGrid.ajaxCache = innGrid.ajaxCache || {};

// innGrid._getWorldlineForm = function () {
//     return $("<div/>", {})
//         .append(innGrid._getHorizontalInput(l('worldline-payment-integration/Merchant ID'), "merchant_id", settings.payment_gateway.merchant_id))
//         .append(innGrid._getHorizontalInput(l('worldline-payment-integration/Payment API Passcode'), "api_passcode", settings.payment_gateway.api_passcode))
// };

innGrid._getWorldlineForm = function () {
    return $("<div/>", {})
        .append(
            innGrid._getHorizontalSelect(
                l('worldline-payment-integration/Environment'),
                "environment",
                {
                    production: "Production",
                    sandbox: "Sandbox"
                },
                settings.payment_gateway.environment || 'sandbox'
            )
        )
        .append(
            innGrid._getHorizontalInput(
                l('worldline-payment-integration/Merchant ID'),
                "merchant_id",
                settings.payment_gateway.merchant_id
            )
        )
        .append(
            innGrid._getHorizontalInput(
                l('worldline-payment-integration/Payment API Passcode'),
                "api_passcode",
                settings.payment_gateway.api_passcode
            )
        );
};


innGrid._getHorizontalInput = function (label, name, value) {
    if (
        name == 'merchant_id' ||
        name == 'api_passcode'
    ) {
        var sensitiveData = '<a title = "Show ' + label + '" class="show_password" href="javascript:"><i class="fa fa-eye" ></i></a>';
    }

    return $("<div/>", {
        class: "form-group form-group-sm show_field"
    }).append(
        $("<label/>", {
            for: name,
            class: "col-sm-3 control-label",
            text: label
        })
    ).append(
        sensitiveData
    ).append(
        $("<div/>", {
            class: "col-sm-8"
        }).append(
            $("<input/>", {
                class: "form-control sensitive_field",
                name: name,
                id: name,
                value: value,
                type: (name == 'merchant_id' || name == 'api_passcode') ? "password" : "text"
            })
        )
    )
};

innGrid._getHorizontalSelect = function (label, name, options, selectedValue) {
    var $select = $("<select/>", {
        class: "form-control",
        name: name,
        id: name
    });

    $.each(options, function (value, text) {
        var $option = $("<option/>", {
            value: value,
            text: text
        });

        if (value == selectedValue) {
            $option.prop("selected", true);
        }

        $select.append($option);
    });

    return $("<div/>", {
        class: "form-group form-group-sm"
    }).append(
        $("<label/>", {
            for: name,
            class: "col-sm-3 control-label",
            text: label
        })
    ).append(
        $("<div/>", {
            class: "col-sm-8"
        }).append($select)
    );
};


$('body').on('click', '.show_password', function(){
    $(this).parents('.show_field').find('.sensitive_field').attr('type','text');
    var thats = $(this);
    setTimeout( function(){
        thats.parents('.show_field').find('.sensitive_field').attr('type', 'password');
    }, 3000);
});


innGrid._updatePaymentGatewayForm = function (selected_payment_gateway, data) {
    if (selected_payment_gateway == '') {
        $("#form-div").html('');
    }
    else if (selected_payment_gateway == 'worldline') {
        $("#form-div").prepend(innGrid._getWorldlineForm());
    }
};

$(function () {

    var gatewayTypes = {
        'Worldline': 'worldline',
    };

    var gateway_data;

    // load saved payment gateway settings data
    if (!innGrid.ajaxCache.paymentGatewaySettings) {
        $.ajax({
            type: "POST",
            dataType: 'json',
            url: getBaseURL() + 'get_worldline_payment_gateway_settings',
            success: function (data) {
                // $('#defult_gateway').css('dislpay','');
                settings = data;
                gateway_data = data;
                innGrid.ajaxCache.paymentGatewaySettings = data;
                for (var key in gatewayTypes) {
                    var option = $("<option/>", {
                        value: gatewayTypes[key],
                        text: key
                    });

                    $("[name='payment_gateway']").append(option);

                    if (data.selected_payment_gateway == gatewayTypes[key]) {
                        option.prop('selected', true);
                    }
                    // if(data.gateway_id ==)
                }

                $gateway = $("select[name='payment_gateway']");
                $gateway.change(function () {
                    var selected_payment_gateway = $gateway.val();
                    innGrid._updatePaymentGatewayForm(selected_payment_gateway, data);
                });

                $gateway.trigger("change");
            }

        });
    }
    else {
        settings = data = innGrid.ajaxCache.paymentGatewaySettings;
        for (var key in gatewayTypes) {
            var option = $("<option/>", {
                value: gatewayTypes[key],
                text: key
            });

            $("[name='payment_gateway']").append(option);

            if (data.selected_payment_gateway == gatewayTypes[key]) {
                option.prop('selected', true);
            }
        }

        $gateway = $("select[name='payment_gateway']");
        $gateway.change(function () {
            var selected_payment_gateway = $gateway.val();
            innGrid._updatePaymentGatewayForm(selected_payment_gateway);
        });

        $gateway.trigger("change");
    }

    $('body').on('click', '.update', function () {
        var merchant_id = $('#merchant_id').val();
        var api_passcode = $('#api_passcode').val();
        var environment = $('#environment').val();
        var selected_payment_gateway = $("select[name='payment_gateway']").val();

        var fields = {};
        fields['selected_payment_gateway'] = selected_payment_gateway;
        fields['merchant_id'] = merchant_id;
        fields['api_passcode'] = api_passcode;
        fields['environment'] = environment;
        console.log(fields);

        var validate = true;
        if(merchant_id == '') {
            alert(l('Please enter Merchant ID', true));
            validate = false;
        }
        else if(api_passcode == '') {
            alert(l('Please enter API Passcode', true));
            validate = false;
        } else {
            validate = true;
        }

        if(validate) {
            $.ajax({
                type: "POST",
                url: getBaseURL() + 'update_worldline_payment_gateway_setting',
                dataType: "json",
                data: fields, // serializes the form's elements.
                success: function (response) {
                    console.log('response', response);
                    if (response) {
                        alert(l('Payment Gateway Settings updated successfully!', true));
                        location.reload();
                    } else {
                        var error_html = "";
                        if (jQuery.isArray(response.errors)) {
                            $.each(response.errors, function (i, v) {
                                error_html += v.description + '\n';
                            });
                            console.log(error_html);
                            alert(error_html);
                        } else {
                            alert(response.errors ? response.errors : response);
                        }
                    }
                }
            });
        }
    });
});
