worldline_token = "";
is_worldline_token_available = false;

let card = null; // Make card accessible globally

$(".use-payment-gateway-btn").css('display','block');

// gateway button
var $methods_list = $('select[name="payment_type_id"]');
var worldline_gateway_button = $('input[name="worldline_use_gateway"]');
var worldline_selected_gateway = $('input[name="worldline_use_gateway"]').data('gateway_name');

var gatewayTypes = {
    'worldline': 'Worldline'
};
worldline_selected_gateway = gatewayTypes[worldline_selected_gateway];

$methods_list.prop('disabled', false);
worldline_gateway_button.prop('checked',0);

worldline_gateway_button.on('click',function(){
    $that = $(this);
    
    var checked = $that.prop('checked');
    console.log('checked',checked);
    $methods_list.prop('disabled', checked);
    var manualPaymentCapture = $("#manual_payment_capture").val();

    if(checked)
    {
        $('.cc_details').show();
        $methods_list
            .append(
            $('<option></option>',{
                id : 'gateway_option'
            })
                .val('gateway')
                .html(worldline_selected_gateway)
        );
        $methods_list.val('gateway');

        $.ajax({
            type: "POST",
            dataType: 'json',
            url: getBaseURL() + 'check_worldline_token_availability',
            data: {
                customer_id : $("select[name='customer_id']").val()
            },
            success: function (response) {
                console.log('response',response);

                if(response.success){
                    is_worldline_token_available = true;
                } else {
                    getCardToken();
                }
            }
        });

        $("#add_payment_normal").hide();

        $(".add_payment_button").parent('.modal-footer').prepend(
                                            '<button type="button" class="btn btn-success add_worldline_payment" id="add_worldline_payment">'+
                                                '<span alt="add" title="add">'+l('worldline-payment-integration/Add Payment')+'</span>'+
                                            '</button>'
                                        );

        
        
        var available_gateway = $('.paid-by-customers').children('option:selected').data('available-gateway');
        
        // false by default. until we find proper solution to store cvc
        
    } else {
        $('.cc_details').remove();
        $('#gateway_option').remove();
        $('#cvc-field').remove();

        $('#payment-form').parents('.form-group').remove();
    }
});

$("body").on("click", ".add_worldline_payment", async function () {

    $(this).html("Processing. . .");
    $(this).prop("disabled", true);


    // $('#card-button').trigger('click');

    if(is_worldline_token_available){
        proceedWithPayment();
        return true;
    }


    
});
    
// show "Use Payment Gateway" option 
$('.paid-by-customers').on('change', function(){
    var isGatewayAvailable = $(this).find('option:selected').attr('is-gateway-available');
    if(isGatewayAvailable == 'true'){
        $('.use-payment-gateway-btn').show();
        $('input[name="use_gateway"]').prop('checked', false);
        $('#cvc-field').remove();
        //$('select[name = "payment_type_id"]').attr('disabled');
        $checked = $('input[name="use_gateway"]').prop('checked');
        if($checked){
            $('select[name = "payment_type_id"]')
                    .append('<option id="gateway_option" value="gateway">'+worldline_selected_gateway+'</option>')
        }
    }
    else
    {
        $('.use-payment-gateway-btn').hide();
        $('select[name = "payment_type_id"]').removeAttr('disabled');
        $('#gateway_option').remove();
        $('input[name="use_gateway"]').prop('checked', 0);
    }
});
if( $('.paid-by-customers option:selected').attr('is-gateway-available') == 'true'){
    $('.use-payment-gateway-btn').show();
}

console.log('worldline_selected_gateway',worldline_selected_gateway);

if(worldline_selected_gateway != undefined){
    var preAuthCheckbox =   '<div class="col-sm-4"></div>'+
                            '<div class="col-sm-2">'+
                                '<input type="checkbox" class="form-control use-gateway worldline_pre_auth" data-gateway_name="'+worldline_selected_gateway.toLowerCase()+'" name="'+worldline_selected_gateway.toLowerCase()+'_pre_auth">'+
                                '<p style="width: 60px;margin: -29px -64px;"><b>'+l('worldline-payment-integration/Pre-Auth')+'</b></p>'+
                            '</div>';

    $('#use-gateway-div').append(preAuthCheckbox);

    // var installmentHtml =   '<div class="form-group hidden installment_html">'+
    //                             '<label for="payment_amount" class="col-sm-4 control-label">'+
    //                                 l('worldline-payment-integration/Pay in Instalments')+
    //                             '</label>'+
    //                             '<div class="col-sm-2">'+
    //                                 '<input type="checkbox" name="installment_charge" class="form-control installment_charge" data-gateway_name="hoteli.pay" name="hoteli.pay_installment_charge">'+
    //                             '</div>'+
    //                         '</div>';

    // $(installmentHtml).insertAfter('.use-payment-gateway-btn');

    // worldline_gateway_button.parent('div').append('<p style="margin: -37px 41px; width:90px;"><b>'+l('worldline-payment-integration/Credit or Debit Charge')+'</b></p>');
}


function getCardToken() {

    /* -------------------------------------------------
     * CSS
     * ------------------------------------------------- */
    if (!document.getElementById('worldline-css')) {
        const style = document.createElement('style');
        style.id = 'worldline-css';
        style.innerHTML = `
            #payment-form {
                max-width: 420px;
            }
            #card-number,
            #card-expiry,
            #card-cvv {
                height: 44px;
                padding: 10px;
                border: 1px solid #dcdcdc;
                border-radius: 4px;
                background: #fff;
                margin-bottom: 12px;
                box-sizing: border-box;
            }
            #card-number:focus-within,
            #card-expiry:focus-within,
            #card-cvv:focus-within {
                border-color: #6772e5;
                box-shadow: 0 0 0 1px #6772e5;
            }

            .bambora-checkoutfield iframe {
                width: 100% !important;
                height: 100% !important;
                border: none;
            }

            #card-button {
                background: #6772e5;
                color: #fff;
                border: none;
                padding: 10px 16px;
                border-radius: 4px;
                cursor: pointer;
                font-size: 14px;
            }

            #card-button:hover {
                background: #5469d4;
            }

            #payment-status-container {
                margin-bottom: 10px;
                font-size: 13px;
            }
        `;
        document.head.appendChild(style);
    }

    var html_content = '<div class="form-group">'+
                            '<label for="payment_amount" class="col-sm-4 control-label">'+
                                'Card Details'+
                            '</label>'+
                            '<div class="col-sm-8">'+
                                '<div id="payment-form">'+
                                    '<div id="payment-status-container"></div>'+
                                    '<div style="display:none;" id="worldline-token"></div>'+
                                    '<div style="display:none;" id="worldline-exp_month"></div>'+
                                    '<div style="display:none;" id="worldline-exp_year"></div>'+
                                    '<div style="display:none;" id="worldline-lastfour"></div>'+
                                    
                                    '<label>Card Number</label>'+
                                    '<div id="card-number"></div>'+

                                    '<label>Expiry Date</label>'+
                                    '<div id="card-expiry"></div>'+

                                    '<label>CVV</label>'+
                                    '<div id="card-cvv"></div>'+
                                    '<button style="" id="card-button" type="button">Save</button>'+
                                '</div>'+
                            '</div>'+
                        '</div>';

    $(html_content).insertAfter('.use-payment-gateway-btn');

    console.log(innGrid.featureSettings.worldlineMerchantId);

    worldlineGateway = true;

    var customCheckout = customcheckout({
        merchantId: innGrid.featureSettings.worldlineMerchantId,
        environment: 'sandbox'
    });

    customCheckout.create('card-number').mount('#card-number');
    customCheckout.create('expiry').mount('#card-expiry');
    customCheckout.create('cvv').mount('#card-cvv');

    /* --------------------------------------------
     * Tokenize on click
     * -------------------------------------------- */
    document.getElementById('card-button').onclick = function () {

        const status = document.getElementById('payment-status-container');
        this.textContent = 'Processing...';

        customCheckout.createToken(function (result) {

            console.log('Worldline result:', result);

            if (result.error) {
                status.innerHTML = '❌ ' + result.error.message;
                document.getElementById('card-button').textContent = 'Save';
                return;
            }

            document.getElementById('worldline-token').innerHTML = result.token;
            document.getElementById('worldline-exp_month').innerHTML = result.expiryMonth;
            document.getElementById('worldline-exp_year').innerHTML = result.expiryYear;
            document.getElementById('worldline-lastfour').innerHTML = result.last4;

            /* --------------------------------------------
             * Disable UI
             * -------------------------------------------- */
            $('#card-number, #card-expiry, #card-cvv').css('pointer-events', 'none');
            $('#card-button').hide();

            status.innerHTML = '✅ Card saved (**** ' + result.card.last4 + ')';

            /* --------------------------------------------
             * RESOLVE → continue payment
             * -------------------------------------------- */
            resolve(result.token);
        });
    };
}



function proceedWithPayment() {
    
    
    // setTimeout(function() {
        $.ajax({
            url    : getBaseURL() + 'add_worldline_payment',
            method : 'post',
            dataType: 'json',
            data   : {
                payment_amount: $("input[name='payment_amount']").val(),
                booking_id      : $("#booking_id").val(),
                payment_date    : innGrid._getBaseFormattedDate($("input[name='payment_date']").val()),
                payment_type_id : $("select[name='payment_type_id']").val(),
                customer_id     : $("select[name='customer_id']").val(),
                payment_amount  : $("input[name='payment_amount']").val(),
                description     : $("textarea[name='description']").val(),
                folio_id        : $('#current_folio_id').val(),
                worldline_pre_auth : $('input[name="worldline_pre_auth"]').is(":checked") ? 1 : 0,
                selected_gateway : $('input[name="'+innGrid.featureSettings.selectedPaymentGateway+'_use_gateway"]').data('gateway_name'),
                // cc_details : ccData
            },
            success: function (data) { 
                console.log('expire ',data);
                if (data == "You don't have permission to access this functionality."){
                    alert(data);
                    $(that).prop("disabled", false);
                    return;
                }
                
                if(data.success){
                   window.location.reload();
                }
                // else if(data.expire)
                // {
                //     window.location.href = getBaseURL() + 'settings/integrations/payment_gateways';
                // }
                else
                {
                    var error_html = "";
                    // console.log(jQuery.isArray( data.message ));
                    if(jQuery.isArray( data.message )){
                        $.each(data.message, function(i,v){
                            error_html += v.detail+'\n';
                        });
                        console.log(error_html);
                        $('#display-errors').find('.modal-body').html(error_html.replace(/\n/g,'<br/>'));
                        $('#display-errors').modal('show');
                        // alert(error_html);
                    } else {
                        alert(data.message ? data.message : data);
                    }
                    
                    
                    $(that).prop("disabled", false);
                }
            }
        });

    // }, 500); // 2000 milliseconds = 2 seconds
}