// $('.cc_details').css('display', 'none');
var customerID;
var gatewayName = 'square';
var sandBoxMode = false;

let card = null; // Make card accessible globally

var square_card_button = '<div class="form-group" style="">'+
							'<label for="customer-name" class="col-sm-3 control-label">Card Details</label>'+
						    '<div class="col-sm-9">'+
						        '<button type="button" class="btn btn-info square_card_btn" onclick="show_iframe()">Add Card Details</button>'+
						    '</div>'+
						'</div>';


$('.add_square_details').hide();
$('.add_square_details').after(square_card_button);

setTimeout(function(){
	$('.square_card_btn').trigger('click');
}, 500);

async function show_iframe() {
    const square_iframe = `
        <div id="payment-form">
            <div id="payment-status-container"></div>
            <div style="display:none;" id="square-payment-token"></div>
            <div style="display:none;" id="square-payment-exp_month"></div>
            <div style="display:none;" id="square-payment-exp_year"></div>
            <div style="display:none;" id="square-payment-lastfour"></div>
            <div id="card-container"></div>
        </div>
    `;

    $('.square_card_btn').parent('div').append(square_iframe);
    $('.square_card_btn').remove();

    if (!gatewaySquareAppId) {
        gatewaySquareAppId = $('#gateway_square_app_id').val();
    }
    if (!gatewaySquareLocationId) {
        gatewaySquareLocationId = $('#gateway_square_location_id').val();
    }

    const payments = Square.payments(gatewaySquareAppId, gatewaySquareLocationId);
    card = await payments.card();
    await card.attach('#card-container');
}

$(".book_now").on('click', async function () {

	$('.book_now').val('Processing...');
	$('.book_now').prop('disabled', true);

    const statusContainer = document.getElementById('payment-status-container');
    const squarePaymentToken = document.getElementById('square-payment-token');

    // Tokenize card if card element is available
    if (card) {
        try {
            const result = await card.tokenize();
            if (result.status === 'OK') {
                // ✅ Successful Tokenization
                squarePaymentToken.innerText = result.token;
                document.getElementById('square-payment-exp_month').innerText = result.details.card.expMonth;
                document.getElementById('square-payment-exp_year').innerText = result.details.card.expYear;
                document.getElementById('square-payment-lastfour').innerText = result.details.card.last4;
                statusContainer.innerText = "Retrieve token successfully";

                proceedWithBooking(); // Call booking logic only after token success

            } else {
                console.error("Tokenization failed:", result);

                var error_html = "";
                // console.log(jQuery.isArray( data.message ));
                if (jQuery.isArray(result.errors)) {
                    $.each(result.errors, function(i, v) {
                        error_html += v.message + '\n';
                    });
                    console.log(error_html);
                    $('#display-errors').find('.modal-body').html(error_html.replace(/\n/g, '<br/>'));
                    $('#display-errors').modal('show');
                    // alert(error_html);
                } else {
                    alert(result.message ? result.message : result);
                    location.reload();
                }


                $('.book_now').prop('disabled', false);
                $('.book_now').val('Book Now');

                // statusContainer.innerText = "Payment Failed";
            }
        } catch (e) {
            console.error("Tokenization error:", e);
            // statusContainer.innerText = "Payment Failed";
        }
    } else {
        alert("Please add card details before booking.");
    }
});

function proceedWithBooking() {
    var current_url = $(location).attr('href');
    var parts = current_url.split("/");
    var company_id = parts[parts.length - 1];

    var cont_name = parts[parts.length - 3];

    var controller = 'online_reservation';

    if(cont_name == 'online_group_reservation'){
    	controller = 'online_group_reservation';
    }

    var customer_email = $("input[name='customer_email']").val();
    var customer_name = $("input[name='customer_name']").val();
    var phone = $("input[name='phone']").val();
    var address = $("input[name='address']").val();
    var city = $("input[name='city']").val();
    var region = $("input[name='region']").val();
    var country = $("input[name='country']").val();
    var postal_code = $("input[name='postal_code']").val();
    var special_requests = $("textarea[name='special_requests']").val();

    var square_token = $('#square-payment-token').text();
    var square_exp_month = $('#square-payment-exp_month').text();
    var square_exp_year = $('#square-payment-exp_year').text();
    var square_lastfour = $('#square-payment-lastfour').text();

    square_exp_year = square_exp_year.substr(2, 4);

    var customerCardData = {
        square_token: square_token,
        cc_number: "XXXX XXXX XXXX " + square_lastfour,
        cc_expiry_month: square_exp_month,
        cc_expiry_year: square_exp_year,
        customer_name: customer_name,
        email: customer_email,
        address: address,
        country: country,
        postal_code: postal_code
    };

    $.ajax({
        type: "POST",
        url: getBaseURL() + controller + "/book_reservation/" + company_id,
        data: {
            customer_data: customerCardData,
            customer_name: customer_name,
            customer_email: customer_email,
            phone: phone,
            address: address,
            city: city,
            region: region,
            country: country,
            postal_code: postal_code,
            special_requests: special_requests
        },
        dataType: "json",
        success: function (res) {
            console.log(res);
            if (res.error && res.error_msg) {
                console.log(res.error_msg);
            } else {
                // Redirect to success page
                $(location).attr('href', getBaseURL() + controller + "/reservation_success/" + company_id);
            }
        }
    });
}
