<?php
class Web_builder extends MY_Controller
{
    public $module_name;
	function __construct()
	{
        parent::__construct();
        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Employee_log_model');
    
	}


    function create_website()
    {
		// prx($this->input->post()); die;
		$view_data = array();
		
		$company_id = $this->session->userdata('current_company_id');
		
		$company = $this->Company_model->get_company($company_id);
		
		$view_data['company'] = $company;
		$view_data['selected_sidebar_link'] = 'Website';
		// Get POSTs 
		$company_data = array(
			'website_is_taking_online_reservation' => ($this->input->post('website_is_taking_online_reservation') == 'on')?'1':'0',
			'website_uri' => $this->input->post('website_uri'),
			'website_title' => $this->input->post('website_title'),
			'website_about' => $this->input->post('website_about'),
			'website_longitude' => $this->input->post('website_longitude'),
			'website_latitude' => $this->input->post('website_latitude'),
			'website_theme_color' => $this->input->post('website_theme_color'),
			'website_facebook_page_url' => $this->input->post('website_facebook_page_url'),
			'website_tripadvisor_widget_type' => $this->input->post('website_tripadvisor_widget_type'),
			'website_tripadvisor_location_id' => $this->input->post('website_tripadvisor_location_id'),
			'google_analytics_id' => $this->input->post('google_analytics_id'),
			'google_conversion_id' => $this->input->post('google_conversion_id')
			);

		$this->load->library('form_validation');
		$this->form_validation->set_rules('website_uri', 'Website URL', 'trim|max_length[40]|alpha_dash|callback__uri_exists['.$this->input->post('website_uri').']');		
		$this->form_validation->set_rules('website_theme_color', 'Theme Color', 'trim|max_length[6]|alpha_dash');		
		$this->form_validation->set_rules('website_tripadvisor_location_id', 'Trip Advisor Location ID', 'trim|numberic');		
		$this->form_validation->set_rules('website_facebook_page_url', 'Facebook Page URL', 'trim');		
		
		$this->form_validation->set_rules('website_about', 'About', 'trim');		
		
		if ($this->form_validation->run() == TRUE)
		{
			$this->Company_model->update_company($company_id, $company_data);
			$this->_create_website_log("Update Website Setting");
			// redirect('web_builder');
			// redirect('http://localhost/minical/public');
			redirect('web_builder', 'location', 301); 
			// header("http://localhost/minical/public/web_builder", true, 301);
			// exit;
		}
		$view_data['menu_on'] = TRUE;
        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        $view_data['main_content'] = '../extensions/'.$this->module_name.'/views/web_builder';
        $this->template->load('bootstrapped_template', null  , $view_data['main_content'], $view_data);
    }

	function _create_website_log($log) {
        $log_detail =  array(
                    "user_id" => $this->user_id,
                    "selling_date" => $this->selling_date,
                    "date_time" => gmdate('Y-m-d H:i:s'),
                    "log" => $log,
                );   
        
        $this->Employee_log_model->insert_log($log_detail);     
    }

	function _uri_exists($str = '', $uri)
	{
		if ($uri === '')
			return true;
		
		$uri = strtolower($uri);
		$current_company_id = $this->session->userdata('current_company_id');
		if (
			$this->Company_model->uri_exists($uri, $current_company_id) ||
			$uri == "inngrid"
			)
		{
			$this->form_validation->set_message('_uri_exists', "'$uri' is already taken");
        	return false;
		}	
		else
		{
			return true;
		}
	}

}
