<?php 

class Monthly_report extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();

        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Whitelabel_ext_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Company_subscription_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Company_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Admin_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Option_model');
        $this->load->library('form_validation');
        $this->load->helper('language_translation');
        $this->load->helper('timezone');
        $this->load->helper('includes/post_helper');
        $this->load->helper('includes/meta_helper');
        
        
        $view_data['menu_on']          = true;
        $this->load->vars($view_data);
    }

    function show_monthly_report()
    {
        $vendor_id = $this->vendor_id;
        $from_date = isset($_GET['from_date']) ? $_GET['from_date'] : null;
        $to_date = isset($_GET['to_date']) ? $_GET['to_date'] : null;
        $data['rows'] = $this->Admin_model->get_monthly_report($from_date, $to_date, $vendor_id);
        $data['main_content'] = '../extensions/'.$this->module_name.'/views/monthly_report';
       $this->template->load('admin_template', null , $data['main_content'], $data);
    }
    
    function property_list()
    {
        $is_filtering = $this->input->get('is_filtering');
        $is_filtering = $is_filtering != "undefined" ? $is_filtering : false;
        $data_type = $this->input->get('data_type');
        
        $country = $this->input->get('country');
        $country = $country != "undefined" ? $country : false;
        
        $report_type = $this->input->get('report_type');
        $report_type = $report_type != "undefined" ? $report_type : false;
        $filter_data = array();
        if($is_filtering)
        {
            $sdate = $this->input->get('sdate');
            $edate = $this->input->get('edate');
            $filter_data = array(
                'is_filtering' => $is_filtering,
                'sdate' => $sdate, 
                'edate' => $edate,
                'country' => $country,
                'report_type' => $report_type,
                'data_type' => $data_type
            );
        }
        else
        {
            $year = $this->input->get('year');
            $month = $this->input->get('month');
            $filter_data = array(
                'is_filtering' => $is_filtering, 
                'year' => $year, 
                'month' => $month, 
                'country' => $country, 
                'report_type' => $report_type, 
                'data_type' => $data_type
            );
        }
        
 
        if(!$this->input->get('property_list') && $_GET)
        {
            $data['rows'] = $this->Admin_model->get_company_admin_panel_info(null, $filter_data);
        }
        else
        {
            $from_date = $this->input->get('from_date');
            $to_date = $this->input->get('to_date');
            $country = $this->input->get('country');
            $state = $this->input->get('subscription_state');
            $partner = $this->input->get('partner');
            $filter_data = array(
                'from_date' => $from_date, 
                'to_date' => $to_date, 
                'country' => $country, 
                'state' => $state, 
                'partner' => $partner, 
                'data_type' => 'property_list'
            );
            $data['rows'] = $this->Admin_model->get_company_admin_panel_info(null, $filter_data);
        }
       
        $data['whitelabel_partners'] = $this->Whitelabel_partner_model->get_whitelabel_partners();
        $data['main_content'] = '../extensions/'.$this->module_name.'/views/property_list';
        $this->template->load('admin_template', null , $data['main_content'], $data);
        
    }
}