companyID = null;

innGrid.openCreateCompanyModal = function() {
    console.log("creating a new company!");
    var modalDiv = $('#company-create-modal');
    modalDiv.modal({
                    keyboard: true
                });

    modalHeader = modalDiv.find(".modal-title");
    modalHeader.html("");
            
    var modalBody = modalDiv.find(".modal-body");
    modalBody.html("Create Company<br/><br/><br/>");
    modalBody.append(
                $("<div/>", {
                    class: "form-group"
                }).append(
                    $("<label/>", {
                        for  : "state",
                        class: "col-sm-5 control-label",
                        html : "Company Name"
                    })
                )
                .append(
                    $("<div/>", {
                        class: "col-sm-5"
                    })
                    .append(
                        $("<input/>", {
                            name  : 'company_name',
                            class : 'form-control',
                            value : ""
                        })
                    )
                ).append(
                    $("<label/>", {
                        for  : "state",
                        class: "col-sm-5 control-label",
                        html : "3 Digit Currency Code"
                    })
                )
                .append(
                    $("<div/>", {
                        class: "col-sm-5"
                    })
                    .append(
                        $("<input/>", {
                            name  : 'currency_code',
                            class : 'form-control',
                            value : "USD"
                        })
                    )
                )
                .append(
                    $("<label/>", {
                        for  : "state",
                        class: "col-sm-5 control-label",
                        html : "File Selector"
                    })
                )
                .append(
                    $("<div/>", {
                        class: "col-sm-5"
                    })
              		.append($("<form/>",{
              			enctype:"multipart/form-data"

                    })
                    .append($("<input/>", {
                            name  : 'file',
                     		type  : "file",
                     		accept: ".csv"
                        })
                    )
                )
                )
                )
        
    }

innGrid.openEditCompanyModal = function(companyID) {
	var modalDiv = $('#company-info-modal');
	modalDiv.modal({
					keyboard: true
				});

    modalHeader = modalDiv.find(".modal-title");
    modalHeader.html("");
            
    var modalBody = modalDiv.find(".modal-body");
    modalBody.html("");
    $.getJSON(getBaseURL() + 'company/get_partners_in_JSON/',
    	function (partners)    
        {
            var partner_select = $("<select/>", {
                name  : 'partner_source',
                class : 'form-control'
            });

            if(partners.length === 0){
                partner_select.append(
                        $("<option/>", {
                            value: "0",
                            html: "Minical"
                        })
                );
            }
            
            for(key in partners){
                partner_select.append(
                    $("<option/>", {
                        value: partners[key]['id'],
                        html: partners[key]['username']
                    })
                );
            }
            
	// load ajax
            $.getJSON(getBaseURL() + 'company/get_company_in_JSON/' + companyID,
                function (company) 
                {
                    var subscriptionState = '';
                    if(company.partner_slug && company.partner_slug == "channel_manager" || company.is_current_user_super_admin)
                    {
                        subscriptionState = $("<option/>", {
                                                        value: "active_not_paying",
                                                        html: "active-not paying"
                                                })
                    }
                    else
                    {
                        subscriptionState = '';
                    }
                        var creation_date = company.creation_date;
                        var expiration_date = company.trial_expiry_date;
                       
                        var plus_fourteen_days = expiration_date;
                        var disableField = false;
                        var subscription_state = company.subscription_state;
                        if(subscription_state != 'trialing')
                        {
                            disableField = true;
                        }
                        
                        modalHeader.append(companyID+" "+company.name+" ");
                        
                        var is_salesperson = modalDiv.data('is_salesperson');
                        if(!is_salesperson) {
                            modalHeader.append(
                                            $("<a/>", {
                                                    class: "btn btn-light btn-sm",
                                                    href: getBaseURL()+"menu/select_hotel/"+companyID,
                                                    target: "_blank",
                                                    html: "Open"
                                            })
                                    );
                        }
                        partner_select.attr('user_id',company.user_id);
                        partner_select.val(company.partner_id);
                                modalBody.append(
                        $("<address/>", {
                            class: "html-center"
                        })
                        .append("address: "+company.city+", "+company.region+", "+company.country+"<br/>")
                        .append("phone: "+company.phone+"<br/>")
                        .append("email: "+company.email+"<br/>")
                        .append("<input type='hidden' name='company-id' value='"+companyID+"' class='company-id' /> ")
                    );

                                modalBody

                    .append(
                        $("<div/>", {
                            class: "form-group"
                        }).append(
                            $("<label/>", {
                                for  : "state",
                                class: "col-sm-3 control-label",
                                html : "Owner Email"
                            })
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-5"
                            })
                            .append(
                                $("<input/>", {
                                    name  : 'company_owner_email',
                                    class : 'form-control',
                                    value : company.owner_email
                                })
                            )
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-4"
                            })
                            .append(
                                $("<input/>", {
                                    class : 'form-control',
                                    value : company.first_name + " " +company.last_name
                                })
                            )
                        )

                    )

                    .append(
                        $("<div/>", {
                            class: "form-group"
                        }).append(
                            $("<label/>", {
                                for  : "state",
                                class: "col-sm-3 control-label",
                                html : "Number of Rooms"
                            })
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-2"
                            })
                            .append(
                                $("<input/>", {
                                    name  : 'number_of_rooms',
                                    class : 'form-control',
                                    value : company.number_of_rooms,
                                    placeholder: "Number of Rooms"
                                })
                            )
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-1"
                            })
                            .append(
                                $("<span/>", {
                                    text : "("+company.number_of_rooms_actual+")"
                                })
                            )
                        )
                        .append(
                            $("<label/>", {
                                for  : "state",
                                class: "col-sm-2 control-label",
                                html : "Country"
                            })
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-4"
                            })
                            .append(
                                $("<input/>", {
                                    name  : 'country',
                                    class : 'form-control',
                                    value : company.country,
                                    placeholder: "Country"
                                })
                            )
                        )
                    )

                    .append(
                        $("<div/>", {
                            class: "form-group"
                        }).append(
                            $("<label/>", {
                                for  : "state",
                                class: "col-sm-3 control-label",
                                html : "Important Dates"
                            })
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-2"
                            }).append(
                                $("<input/>", {
                                    name  : 'creation_date',
                                    class : 'form-control datepicker',
                                    placeholder: 'Creation Date',
                                    value : company.creation_date
                                }).datepicker({
                                    dateFormat: 'yy-mm-dd'
                                })
                            )
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-2"
                            }).append(
                                $("<input/>", {
                                    name  : 'conversion_date',
                                    class : 'form-control datepicker',
                                    placeholder: 'Conversion Date',
                                    value : company.conversion_date
                                }).datepicker({
                                    dateFormat: 'yy-mm-dd'
                                })
                            )
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-2"
                            }).append(
                                $("<input/>", {
                                    name  : 'churn_date',
                                    class : 'form-control datepicker',
                                    placeholder: 'Churn Date',
                                    value : company.churn_date
                                }).datepicker({
                                    dateFormat: 'yy-mm-dd'
                                })
                            )
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-2"
                            }).append(
                                $("<input/>", {
                                    name  : 'trial_expiry_date',
                                    class : 'form-control datepicker',
                                    placeholder: 'Trial Date',
                                    value : plus_fourteen_days,
                                    disabled: disableField
                                }).datepicker({
                                    dateFormat: 'yy-mm-dd'
                                })
                            )
                        )
                    )

                     .append(
                        $("<div/>", {
                            class: "form-group"
                        }).append(
                            $("<label/>", {
                                for  : "state",
                                class: "col-sm-3 control-label",
                                html : "Payment Schedule"
                            })
                        )
                         .append(
                            $("<div/>", {
                                class: "col-sm-3"
                            }).append(
                                $("<input/>", {
                                    name  : 'cost_amount',
                                    class : 'form-control cost_amount',
                                    placeholder: 'Cost Amount',
                                    value : company.cost_amount,
                                    style: "margin-bottom: 8px;"
                                })
                            )
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-3"
                            }).append(
                                $("<input/>", {
                                    name  : 'tax',
                                    class : 'form-control tax_percentage',
                                    placeholder: 'Tax Percentage',
                                    value : company.tax,
                                    style: "margin-bottom: 8px;"
                                })
                            )
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-3"
                            }).append(
                             $("<label/>", {
                                for  : "tax",
                                 html : "Exclusive tax percentage(%)"
                                
                            })
                            )
                        )
                        )
                        .append( 
                            $("<div/>", {
                               class: "form-group"
                            }).append(
                            $("<label/>", {
                                for  : "state",
                                class: "col-sm-3 control-label"
                            })
                        )
                        
                        .append(
                            $("<div/>", {
                                class: "col-sm-3"
                            }).append(
                                $("<input/>", {
                                    name  : 'renewal_cost',
                                    class : 'form-control',
                                    placeholder: 'Renewal Cost',
                                    value : company.renewal_cost,
                                    readonly: 'readonly'
                                    
                                })
                            )
                        )
                       .append(
                            $("<div/>", {
                                class: "col-sm-3"
                            }).append(
                                $("<select/>", {
                                    name  : 'renewal_period',
                                    class : 'form-control',    
                                }).append(
                                        $("<option/>", {
                                            value: "1 month",
                                            html: "Monthly",
                                            selected: (company.renewal_period == "1 month")
                                        })
                                    )
                                    .append(
                                        $("<option/>", {
                                            value: "1 year",
                                            html: "Yearly",
                                            selected: (company.renewal_period == "1 year")
                                        })
                                    )
                            )
                        )
                       )
                    .append(
                            $("<div/>", {
                                    class: "form-group"
                            }).append(
                                $("<label/>", {
                                    for  : "state",
                                    class: "col-sm-3 control-label",
                                    html : "Subscription Level "
                                })
                             ).append(
                                $("<div/>", {
                                    class: "col-sm-2"
                                }).append(
                                    $("<select/>", {
                                        name  : 'subscription_level',
                                        class : 'form-control',
                                    })
                                    .append(
                                        $("<option/>", {
                                            value: 3,
                                            html: "Starter",
                                            selected: (company.subscription_level == 3)
                                        })
                                    )
                                    .append(
                                        $("<option/>", {
                                            value: 0,
                                            html: "Basic",
                                            selected: (company.subscription_level == 0)
                                        })
                                    )
                                    .append(
                                        $("<option/>", {
                                            value: 1,
                                            html: "Premium",
                                            selected: (company.subscription_level == 1)
                                        })
                                    )
									.append(
                                        $("<option/>", {
                                            value: 2,
                                            html: "Elite",
                                            selected: (company.subscription_level == 2)
                                        })
                                    )
                                )
                            ).append(
                                $("<div/>", {
                                    class: "col-sm-2"
                                }).append(
                                        $("<select/>", {
                                                name  : 'subscription_state',
                                                class : 'form-control'
                                        }).append(
                                            $("<option/>", {
                                                    value: "trialing",
                                                    html: "trialing"
                                            })
                                        ).append(
                                                $("<option/>", {
                                                        value: "active",
                                                        html: "active"
                                                })
                                        ).append(
                                            $("<option/>", {
                                                    value: "promising",
                                                    html: "promising"
                                            })
                                        )
                                        .append(
                                                $("<option/>", {
                                                        value: "trial_ended",
                                                        html: "trial_ended"
                                                })
                                        )
                                        .append(
                                            $("<option/>", {
                                                value: "unpaid",
                                                html: "unpaid"
                                            })
                                        )
                                        .append(
                                            $("<option/>", {
                                                    value: "canceled",
                                                    html: "canceled"
                                            })
                                        )
                                        .append(
                                            $("<option/>", {
                                                    value: "review",
                                                    html: "Review"
                                            })
                                        )
                                        .append(
                                            $("<option/>", {
                                                    value: "on_hold",
                                                    html: "On hold"
                                            })
                                        
                                        ) .append(
                                            $("<option/>", {
                                                    value: "deleted",
                                                    html: "Deleted"
                                            })
                                        )
										.append(
                                            $("<option/>", {
                                                    value: "past_due",
                                                    html: "Past Due"
                                            })
                                        )
										.append(
                                                subscriptionState
                                        )
                                        .on('change', function(){
                                            var subscription_state = $('select[name=subscription_state]').val();
                                            console.log('subscription_state');
                                            console.log(subscription_state);
                                            if(subscription_state != 'trialing')
                                            {
                                                $('input[name=trial_expiry_date]').attr('disabled', 'true');
                                            }
                                        })
                                )
                            )
                            .append(
                                    $("<div/>", {
                                            class: "col-sm-5"
                                    }).append(
                                            $("<input/>", {
                                                name  : 'limit_feature',
                                                type  : 'checkbox',
                                                checked: (company.limit_feature == 1)
                                            })
                                        )
                                        .append(
                                        $("<label/>", {
                                            for  : "limit_feature",
                                            html : "Limit features according to subscription level",
                                            style: "margin-left: 5px;"
                                        })
                                     )
                                )                       
                            
                       
                    )
                    // .append(
                    //         $("<div/>", {
                    //                 class: "form-group"
                    //         }).append(
                    //             $("<label/>", {
                    //                 for  : "state",
                    //                 class: "col-sm-3 control-label",
                    //                 html : "UTM Source"
                    //             })
                    //          ).append(
                    //             $("<div/>", {
                    //                 class: "col-sm-6"
                    //             }).append(
                    //                 $("<input/>", {
                    //                     name  : 'utm_source',
                    //                     class : 'form-control',
                    //                     placeholder: 'UTM Source',
                    //                     value : company.utm_source
                    //                 })
                    //             )
                    //         )                       
                    // )
                    // .append(
                    //         $("<div/>", {
                    //                     class: "form-group"
                    //         }).append(
                    //         $("<label/>", {
                    //             for  : "state",
                    //             class: "col-sm-3 control-label",
                    //             html : "Payment Method"
                    //         })
                    //     )
                    //     .append(
                    //         $("<div/>", {
                    //             class: "col-sm-2"
                    //         }).append(
                    //             $("<select/>", {
                    //                 name  : 'payment_method',
                    //                 class : 'form-control'
                    //             })
                    //             .append(
                    //                 $("<option/>", {
                    //                     value: "chargify_v1",
                    //                     html: "chargify v1"
                    //                 })
                    //             )
                    //             .append(
                    //                 $("<option/>", {
                    //                     value: "chargify",
                    //                     html: "chargify v2"
                    //                 })
                    //             )
                    //             .append(
                    //                 $("<option/>", {
                    //                     value: "chargify_usd",
                    //                     html: "chargify USD"
                    //                 })
                    //             )
                    //             .append(
                    //                 $("<option/>", {
                    //                     value: "xero",
                    //                     html: "xero"
                    //                 })
                    //             )
                    //             .append(
                    //                 $("<option/>", {
                    //                     value: "waveapps",
                    //                     html: "waveapps"
                    //                 })
                    //             )
                    //             .append(
                    //                 $("<option/>", {
                    //                     value: "cheque",
                    //                     html: "cheque"
                    //                 })
                    //             )
                    //             .append(
                    //                 $("<option/>", {
                    //                     value: "transfer",
                    //                     html: "transfer"
                    //                 })
                    //             )
                    //             .append(
                    //                 $("<option/>", {
                    //                     value: "none",
                    //                     html: "none"
                    //                 })
                    //             )
                    //         )
                    //     )
                    //     .append(
                    //         $("<div/>", {
                    //             class: "col-sm-3"
                    //         }).append(
                    //             $("<div/>", {
                    //                 class: "input-group"
                    //             })
                    //             .append(
                    //                 $("<span/>", {
                    //                     class: 'input-group-btn'
                    //                 }).append(
                    //                     $("<a/>", {
                    //                         class: "btn btn-default",
                    //                         html: "ID",
                    //                         type: "button",
                    //                         target: "_blank",
                    //                         href: (
                    //                                 (company.payment_method == 'chargify_v1')?
                    //                                     "https://roomsy.chargify.com/subscriptions/"+company.subscription_id:
                    //                                     (
                    //                                         (company.payment_method == 'chargify_usd')?
                    //                                             "https://roomsy-inc-usd.chargify.com/":
                    //                                         (
                    //                                             (company.payment_method == 'chargify')?
                    //                                             "https://roomsyinc.chargify.com/subscriptions/"+company.subscription_id:
                    //                                             (
                    //                                                 (company.payment_method == 'xero')?
                    //                                                     "https://go.xero.com/Contacts/View/"+company.subscription_id:
                    //                                                     "https://accounting.waveapps.com/clients/1596011/customerstatements#/"+company.subscription_id+"/2011-06-20/2017-07-20/history"
                    //                                             )
                    //                                         )
                    //                                     )
                    //                               )
                    //                     })
                    //                 )
                    //             ).append(
                    //                     $("<input/>", {
                    //                         name  : 'subscription_id',
                    //                         class : 'form-control',
                    //                         value : company.subscription_id,
                    //                         placeholder: ""
                    //                     })
                    //                 )

                    //             )
                    //         )
                    //     )
                    // .append(
                    //     $("<div/>", {
                    //         class: "form-group"
                    //     }).append(
                    //         $("<label/>", {
                    //             for  : "invoice_link",
                    //             class: "col-sm-3 control-label",
                    //             html : "<a href='"+company.invoice_link+"' target='_blank'>Invoice Link</a>"
                    //         })
                    //     ).append(
                    //         $("<div/>", {
                    //             class: "col-sm-9"
                    //         }).append(
                    //             $("<input/>", {
                    //                 name  : 'invoice_link',
                    //                 class : 'form-control',
                    //                 placeholder: 'Link to Wave Apps invoice page, or Chargify statement page',
                    //                 value : company.invoice_link
                    //             })
                    //         )
                    //     )
                    // )
                    .append(
                        $("<div/>", {
                            class: "form-group"
                        }).append(
                            $("<label/>", {
                                for  : "state",
                                class: "col-sm-3 control-label",
                                html : "API Key"
                            })
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-6"
                            }).append(
                                $("<input/>", {
                                    name  : 'api_key',
                                    class : 'form-control',
                                    value : company.api_key
                                })

                            )
                        )
                        // .append(
                        //     $("<div/>", {
                        //         class: "col-sm-2"
                        //     }).append(
                        //         $("<input/>", {
                        //             class: "btn btn-default",
                        //             value: "Generate"
                        //         }).on("click", function() {
                        //             $("[name='api_key']").val(innGrid.generateAPIKey());
                        //         })
                        //     )
                        // )
                    )
                    .append(
                        $("<div/>", {
                            class: "form-group"
                        }).append(
                            $("<label/>", {
                                for  : "state",
                                class: "col-sm-3 control-label",
                                html : "Partner/Source"
                            })
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-9"
                            }).append(
                                 partner_select

                            )
                        )
                    ).append(
                        $("<div/>", {
                            class: "form-group"
                        }).append(
                            $("<label/>", {
                                for  : "state",
                                class: "col-sm-3 control-label",
                                html : "Comment"
                            })
                        )
                        .append(
                            $("<div/>", {
                                class: "col-sm-9"
                            }).append(
                                $("<textarea/>", {
                                    name  : 'comment',
                                    class : 'form-control',
                                    html : company.admin_comment,
                                    row: 3
                                })

                            )
                        )
                        )
                    // .append(
                    //         $("<div/>", {
                    //             class: "form-group"
                    //         }).append(
                    //                 $("<div/>", {
                    //                    class: "col-sm-3",
                    //                    style:"text-align: right;padding-right: 0;"
                    //                 })
                    //                 .append(
                    //                     $("<input/>", {
                    //                         name  : 'enable_card_tokenization',
                    //                         class : 'enable-tokenization-btn',
                    //                         type:'checkbox',
                    //                         checked: (company.enable_card_tokenization == 1)
                                            
                    //                     })
                    //                 )
                    //         ).append(
                    //                 $("<div/>", {
                    //                    class: "col-sm-9"
                    //                 }).append(
                    //                     $("<label/>", {
                    //                         for  : "enable_card_tokenization",
                    //                         class: "control-label",
                    //                         style: "padding-top: 0;",
                    //                         html : "Enable credit card tokenization"
                    //                     })
                    //             )
                    //      ) 
                         
                    // )
                //         .append(
                //         $("<div/>", {
                //             class: "form-group"
                //         }).append(
                //                 $("<div/>", {
                //                    class: "col-sm-3",
                //                    style:"text-align: right;padding-right: 0;"
                //                 })
                //                 .append(
                //                     $("<input/>", {
                //                         name  : 'is_cc_visualization_enabled',
                //                         class : 'enable-visualization-btn',
                //                         type:'checkbox',
                //                         checked: (company.is_cc_visualization_enabled == 1)
                                        
                //                     })
                //                 )
                //         ).append(
                //                 $("<div/>", {
                //                    class: "col-sm-9"
                //                 }).append(
                //                     $("<label/>", {
                //                         for  : "is_cc_visualization_enabled",
                //                         class: "control-label",
                //                         style: "padding-top: 0;",
                //                         html : "Enable credit card visualization "+"    <small>(Properties can view CC details of customers.)</small>"
                //                     })
                //             )
                //      ) 
                     
                // )
                        ;
                    
                    $("[name='subscription_state']").val(company.subscription_state);
                    $("[name='payment_method']").val(company.payment_method);
                    $("[name='renewal_period']").val(company.renewal_period);
                }
            );
        }
    );
}

innGrid.generateAPIKey = function() {

	function s4() {
		return Math.floor((1 + Math.random()) * 0x10000)
		  .toString(16)
		  .substring(1);
	}
	
	return s4() + s4() + s4() + s4() +s4() + s4() + s4() + s4();

}

$(function (){
	var baseURL = getBaseURL();
	var that = this;

    // when user clicks on create new company menu link
    $(document).on('click', "#create-company-button",  function() {
        innGrid.openCreateCompanyModal();
    });
    
   $(document).on('keyup', ".cost_amount",  function() {
       var renewcost =  $("[name='cost_amount']").val();
       renewcost =  parseFloat($("[name='cost_amount']").val());
       var tax =  $("[name='tax']").val();
       if(tax > 0) {
        var tax_rate = parseFloat((tax / 100) * renewcost);
           renewcost = parseFloat(renewcost + tax_rate);
        }
        $("[name='renewal_cost']").val(renewcost);
    });
    $(document).on('keyup', ".tax_percentage",  function() {
       var renewcost =  $("[name='cost_amount']").val();
       renewcost =  parseFloat($("[name='cost_amount']").val());
       var tax =  $("[name='tax']").val();
       if(tax > 0) {
        var tax_rate = parseFloat((tax / 100) * renewcost);
           renewcost = parseFloat(renewcost + tax_rate);
        }
        $("[name='renewal_cost']").val(renewcost);
    });

    // when user clicks on one of the rows in the company table
	$(document).on('click', ".company-tr",  function(event) {
		that.companyID = $(this).attr('id');
		that.companyPaymentMethod = $(this).data('payment-method');
		var invoiceLink = $(this).data('invoice_link');
		var subscriptionID = $(this).data('subscription_id');
		if($(event.target).hasClass('payment-method') && (that.companyPaymentMethod == 'chargify' || that.companyPaymentMethod == 'chargify_v1'  || that.companyPaymentMethod == 'xero'))
        {
			if(invoiceLink) {
				window.open(invoiceLink, "_blank");
			} else if(subscriptionID) {
				window.open("https://roomsy.chargify.com/subscriptions/"+subscriptionID, "_blank");
			}
		} else {
			innGrid.openEditCompanyModal(that.companyID);
		}
    });
	
    $("#create_company_button").on('click', function () {
    	var company_name = $("[name='company_name']").val();
    	console.log(company_name);
    	var currency_code = $("[name='currency_code']").val();
    	var formData = new FormData($('form')[0]);
    	console.log(formData);
        $.ajax({
		    type   : "POST",
		    url    : getBaseURL() + "admin/create_company?name=" + company_name + "&currency=" + currency_code,
		    data   : formData,
	        //Options to tell jQuery not to process data or worry about content-type.
	        cache: false,
	        contentType: false,
	        processData: false,
		    success: function (data) {
		        console.log("data sent!");
		        modalBody.html("Create Company<br/><br/><br/>Complete!");
    		}
    		
        });
    });

    

    $("#update_company_button").on('click', function () {
        
        var company_data = {
                api_key         : $("[name='api_key']").val(),
                number_of_rooms : $("[name='number_of_rooms']").val(),
                country         : $("[name='country']").val()
                //enable_card_tokenization: $("[name='enable_card_tokenization']").prop('checked'),
                //is_cc_visualization_enabled: $("[name='is_cc_visualization_enabled']").prop('checked')
        };
        var company_admin_data = {
            admin_comment       : $("[name='comment']").val(),
            creation_date       : $("[name='creation_date']").val(),
            conversion_date     : $("[name='conversion_date']").val(),
            churn_date          : $("[name='churn_date']").val(),
            trial_expiry_date   : $("[name='trial_expiry_date']").val(),
            utm_source          : $("[name='utm_source']").val()
        };

        var company_subscription_data = {
                subscription_state:         $("[name='subscription_state']").val(),
                subscription_id:            $("[name='subscription_id']").val(),
                payment_method:             $("[name='payment_method']").val(),
                renewal_period:             $("[name='renewal_period']").val(),
                cost_amount:                $("[name='cost_amount']").val(),
                tax:                        $("[name='tax']").val(),
                renewal_cost:               $("[name='renewal_cost']").val(),
                invoice_link:               $("[name='invoice_link']").val(),
                subscription_level:         $("[name='subscription_level']").val(),
                limit_feature:              $("[name='limit_feature']").prop('checked')
        };
        
        $.ajax({
            type   : "POST",
            url    : getBaseURL() + "admin/update_company_AJAX",
            data   : {
                company_id                  : that.companyID,
                company_data                : company_data,
                company_admin_data          : company_admin_data,
                company_subscription_data   : company_subscription_data,
                company_owner_email         : $("[name='company_owner_email']").val(),
                user_id                     : $("select[name=partner_source]").attr('user_id'),
                partner_id                  : $("select[name=partner_source]").val()
            },
            dataType: "json",
            success: function (data) {
                
                $.getJSON(getBaseURL() + 'company/get_company_in_JSON/' + that.companyID + '/1',
                    function (company) 
                    {
                        console.log(company);
                        console.log(company.company_id);
                        $(".company-tr#"+that.companyID).html("");
                        $(".company-tr#"+that.companyID)
                            .append($("<td/>", {
                                html: company.company_id
                            })).append($("<td/>", {
                                html: company.name
                            })).append($("<td/>", {
                                html: company.country
                            })).append($("<td/>", {
                                html: company.creation_date
                            }))
//                            .append($("<td/>", {
//                                html: company.conversion_date
//                            }))
                            .append($("<td/>", {
                                html: (company.idle ? company.idle : 0) +" days"
                            })) 
//                            .append($("<td/>", {
//                                html: company.nad
//                            }))
                            .append($("<td/>", {
                                html: company.payment_method+" <small>" + (company.subscription_id ? company.subscription_id : '') + "</small>"
                            })).append($("<td/>", {
                                html: company.renewal_cost
                            })).append($("<td/>", {
                                html: " <small>every "+(company.renewal_period?company.renewal_period:'')+"</small>"
                            })).append($("<td/>", {
                                html:company.mrr 
                            })).append($("<td/>", {
                                html: company.number_of_rooms
                            })).append($("<td/>", {
                                html: company.balance
                            })).append($("<td/>", {
                                html: company.subscription_state
                            })).append($("<td/>", {
                                html: company.partner_name
                            }));



                        
                    }
                ); 
            }
        })
    });    
    
    // add new property
    $("#add_new_company_button").on("click", function () {
        var that = this;

        if($("[name='property_name']").val() == '') {
            alert('Please enter Property name');
            return false;
        }
        if($("[name='number_of_rooms']").val() == '') {
            alert('Please enter Number of rooms');
            return false;
        }
        if($("[name='number_of_rooms']").val() > 1000) {
            alert('You can add maximum 1000 rooms.');
            return false;
        }

        $(that).prop("disabled", true);

		$.ajax({
			type: "POST",
			url: getBaseURL() + "auth/create_company/",
			data: {
				name: 		$("[name='property_name']").val(),
				number_of_rooms: 	$("[name='number_of_rooms']").val(),
				region: 			$("[name='region']").val(),
				subscription_type: 	$("[name='subscription_type']").val(),
                created_by:         'admin'
			},
			dataType: "json",
			success: function(data) 
			{
                $(that).prop("disabled", false);
				window.location.reload();			
			}
		});
    });
    
    // soft delete a property
    $(document).on("click", '#delete_company_button', function () {
        var that = this;
        var company_id =  $('.company-id').val();
		$.ajax({
			type: "POST",
			url: getBaseURL() + "admin/delete_company_AJAX",
			data: {
				company_id: company_id
			},
			dataType: "json",
			success: function(data) 
			{
                $(that).prop("disabled", false);
                window.location.reload();			
			}
		});
    });
});
