//Add events to new reservation, new checkin, and new out of order and sorts them
$(function () {

	$('.main-card').append('<div id="booking_list_wrap" class="col-sm-5 col-lg-4 hidden-xs today-booking">' +
		l("Loading today's panel") +
		'</div>'
	);

	// create new booking
	$(document).on("click", "#hide-button", function () {
		if ($("#hide-button").text() == l("show"))
		{
			$(".booking_table").show();
			$("#hide-button").hide();
			$.get(getBaseURL() + 'set_reminder_as_visible', function (data) {
				$("#hide-button").show();
				$("#hide-button").text(l("hide"));
			}, 'json');

		}
		else
		{
			$(".booking_table").hide();
			$("#hide-button").hide();
			$.get(getBaseURL() + 'set_reminder_as_hidden', function (data) {
				$("#hide-button").show();
				$("#hide-button").text(l("show"));
			}, 'json');

		}
	});

	$('[rel="popover"]').popover({ trigger: "hover" });

	$('#add_payment_button').click(function () {
		var booking_csv = $('select[name=select-csv-export]').val();
        if (booking_csv == 'download-reservation-csv')
		{
			window.location = getBaseURL() + "download_csv_export/0";
		} else if (booking_csv == 'download-inhouse-csv')
		{
			window.location = getBaseURL() + "download_csv_export/1";
		}
	});

	$('#export_bookings_by_rate_plan').click(function () {
		var rate_plan_id = $('select[name=select-rate-plan-export]').val();
        
		window.location = getBaseURL() + "download_csv_export_rate_plan/" + rate_plan_id;
	});

	$(document).on('click', '#hide-button', function (e) {
		var text = $(this).data('text');
		if(text == 'show')
		{
			$('#booking_list_wrap').css('height', 'auto');
			$(this).data('text', l('hide', true));
		}
		else
		{
			$('#booking_list_wrap').css('height', '41px');
			$(this).data('text', l('show', true));
		}
	});

	$("#booking_list_wrap").draggable({
		handle: "#todays-events-title"
	});

	setTimeout(function () {
		window.jQuery('#booking_list_wrap').load(window.getBaseURL() + 'booking/show_booking_list', function () {
			if (window.location.hash) {
				var hash = window.location.hash.split('#')[1];
				$(".booking#" + hash).openBookingModal({
					id: hash
				});
			}
			$("#booking_list_wrap").resizable({
				handles: 'e, se',
				maxWidth: 600,
				minWidth: 370
			});
		});
	}, 1000);

});