<?php 

class Setting extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();

        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Company_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Image_model');

        $view_data['menu_on']          = true;
        $this->load->vars($view_data);
    }

    function set_language($company_language_id) {
        load_translations($company_language_id);
    }

    function reset_language($company_language_id) {
        if(empty($this->ci->session->userdata('language_id')))
        {
            get_language_id($this->ci->session->userdata('language'));
        }
        $language_id = $this->ci->session->userdata('language_id');
        if ($company_language_id != $language_id) {
            load_translations($language_id);
        }
    }

    function index($company_id)
    {
        // Show invoice based on hash value received
        $hash = $this->security->xss_clean($this->input->get('hash'));
        $rate = $this->security->xss_clean($this->input->get('rating'));
        $rate = base64_decode($rate);

        if ($hash == "")
            $hash = $this->security->xss_clean($this->input->post('hash'));

        // if hash is valid, load booking
        if ($hash != "")
        {
            $booking_id = $this->Booking_model->get_booking_id_from_invoice_hash($hash);
            
            if (isset($booking_id)) // hash is invalid
            {
                $booking = $this->Booking_model->get_booking_detail($booking_id, true);
                $company_id = $booking['company_id'];
                $company = $this->Company_model->get_company($company_id);

                $this->set_language($company['default_language']);

                if (isset($_POST['submit_feedback']) && $booking['rating'] != "")
                {
                    $star_rating = $this->security->xss_clean($this->input->post('star-rating'));
                    $comment = $this->security->xss_clean($this->input->post('comment-box'));
                    
                    $update_review_data = array (
                        'booking_id' => $booking_id,
                        'comment' => $comment,
                        'rating' => $star_rating,
                    );
                    $this->Booking_model->update_booking_review($update_review_data);

                    // send email
                    $this->load->library('email');

                    $whitelabelinfo = $this->session->userdata('white_label_information');

                    $from_email = isset($whitelabelinfo['do_not_reply_email']) && $whitelabelinfo['do_not_reply_email'] ? $whitelabelinfo['do_not_reply_email'] : 'donotreply@roomsy.com';

                    $this->email->from($from_email);
                    $this->email->to($company['email']);
                    $this->email->subject(l("New review from a guest!", true));
                    $this->email->message(l("The guest gave your hotel")." ".$star_rating." ".l('stars')."<br/><br/>".l("Guest's comment").":<br/>".$comment);
                    $this->email->send();

                    if($star_rating >= 4.5)
                    {
                        $review_links = $this->Company_model->get_all_review_links($booking['company_id'], true);
                        foreach($review_links as $link)
                        {
                            if (abs($link['ota_id']) == abs($booking['source']) && $link['review_link'] != "") {
                                redirect($link['review_link']);
                            }
                            elseif($link['ota_id'] == 0 && $link['review_link'] != "")
                            {
                                redirect($link['review_link']);
                            }
                        }
                    }
                    redirect('/review/thank_you/'.$company_id."?srating=".$star_rating);

                    return;
                }

                // if review was not yet submitted
                if ($booking['rating'] == "")
                {
                    $company_logos = $this->Image_model->get_images($company['logo_image_group_id']);
                    $data['hash'] = $hash;
                    $data['rate'] = $rate;
                    if (isset($company_logos[0]['filename']))
                    {
                        $data['company_logo_GUID'] = $company_logos[0]['filename'];
                    }
                        
                    $data['company'] = $company;

                    $booking_review_data = array (
                                        'booking_id' => $booking_id,
                                        'customer_id' => $booking['booking_customer_id'],
                                        'rating' => $rate,
                                        'comment' => '',
                                        'created' => date("Y-m-d H:i:s")
                                    );

                    $this->Booking_model->set_booking_review($booking_review_data);
                
                    $data['main_content'] = '../extensions/'.$this->module_name.'/views/review_form';

                    $this->template->load('bootstrapped_template', null , $data['main_content'], $data);

                    return;
                } else {
                    exit(l('Already submitted a review using this link.'));
                }

                $this->reset_language($company['default_language']);
            }
        }
    
        show_404();
    }
    
    function review()
    {
        $data = $insert_data = $update_data = array();

        //Load company data
        if (!is_null($company = $this->Company_model->get_all_review_links($this->company_id))) {
           $data['review_links'] = $company;          
        }
        // Validation
       if (isset($_POST['submit'])) {
        
            $link_data = $this->input->post('links');
            $ota_data = $this->input->post('otas');

            if(!is_null($this->Company_model->get_all_review_links($this->company_id)))
            {
                foreach($link_data as $key => $link)
                {
                    $update_data = array('review_link' => $link);
                    $this->Company_model->update_review_links($this->company_id, $ota_data[$key], $update_data);
                }
            }
            else
            {
                foreach($link_data as $key => $link)
                {
                    $insert_data = array('company_id' => $this->company_id, 'ota_id' => $ota_data[$key], 'review_link' => $link);
                    $this->Company_model->create_review_links($insert_data);
                }
                
            }
            
            redirect('review_management'); // redirect to settings unavailable screen
        }

        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        $data['company_ID'] = $this->company_id;

        $data['selected_sidebar_link'] = 'Review Pages';

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/review_management';

        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);

    }

    public function thank_you($company_id) {

        $star_rating = $this->input->get('srating');
        // $company_id = $this->input->get('cid');

        $company = $this->Company_model->get_company($company_id);
        
        $data['company'] = $company;
        $data['star_rating'] = $star_rating;

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/thank_you';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

}