<div id="printable-container">
    <div class="page-header">
        <h3><?php echo l('reservation_report'); ?></h3>
    </div>
     
    <div class="panel panel-default hidden-print">
        <div class="panel-body h4">
                
            <?php $start_date = ($this->uri->segment(4) != '') ? $this->uri->segment(4) : ""; ?>    
            <?php $end_date = ($this->uri->segment(5) != '') ? $this->uri->segment(5) : ""; ?>    
            <?php $book_type = ($this->uri->segment(6) != '') ? $this->uri->segment(6) : ""; ?>    
            <?php $book_source = ($this->uri->segment(7) != '') ? $this->uri->segment(7) : ""; ?>    
            <?php $param = $start_date."/".$end_date."/".$book_type."/".$book_source;  ?>    
                
            <div class="form-inline" style="padding-top:5px;">
                <?php 
                if(
                        isset($partner['partner_slug']) && 
                        $partner['partner_slug'] == "channel_manager" &&
                        in_array($this->user_id, $partner['admins'])
                ) {
                    //$param .= "///";
                ?>
                    <div class="btn-group">
                        <button href="#" class="btn btn-success  create-new-booking">
                            <?php echo l('create_new_booking'); ?>
                        </button>
                    </div>
                <?php } ?>
                <?php echo l('from')." ".l('date'); ?> :
                <input size="10" type="text" name="from_date" value="<?php echo $from_date; ?>" class="form-control">

                <?php echo l('to')." ".l('date'); ?>:
                <input size="10" type="text" name="to_date" value="<?php echo $to_date; ?>" class="form-control">

                <?php
                $this->load->helper('customer_name');

                $states = Array(
                    "-1" => "All",
                    '0' => "Confirmed",
                    '1' => "In-House",
                    '2' => "Checked-out",
                    '3' => "Out of Order",
                    '4' => "Cancelled",
                    "5" => "No Show",
                    '6' => "Deleted",
                    '7' => "Unconfirmed",
                    '10' => "Departure",
                    '11' => "Arrivals"
                );
                ?>
                <?php echo l('booking_type'); ?>:
                <select	name="state" class="form-control">
                    <?php foreach ($states as $index => $state): ?>
                        <option
                            value="<?php echo $index; ?>"
                            <?php if ($selected_state == $index) { echo ' selected="selected"'; }?>
                        >
                            <?php echo $state; ?>
                        </option>

                    <?php endforeach; ?>
                </select>
                
                <?php echo l('booking_source'); ?>:
                <select	name="booking_source" class="form-control">
                    <option value="-1" <?php echo ($selected_source == -1) ? 'selected="selected"' : ""; ?>> All </option>
                    <?php foreach ($booking_sources as $booking_source): ?>
                        <option
                            value="<?php echo $booking_source['id']; ?>"
                            <?php if ($booking_source['id'] == $selected_source) { echo ' selected="selected"'; }?>
                        >
                            <?php echo $booking_source['name']; ?>
                        </option>

                    <?php endforeach; ?>
                </select>
                <?php //prx($bookings); ?>
                <button id="printReportButton" class="btn btn-primary pull-right hidden-print" style="margin-left:5px;"><?php echo l('print_report'); ?></button>
                <a href="<?php if($param != '///'){ echo base_url()."reports/reservation/download_reservation_cm_csv_export/".$param; } else { echo base_url()."reports/reservation/download_reservation_cm_csv_export"; } ?>" class="btn btn-primary pull-right ">
                    <?php echo l('download_csv_export'); ?>
                </a>
            </div><!-- /.form-inline -->
        </div>
    </div>

    <div>
<!--        <div class="h3 col-lg-3"><?=$hotel_name;?></div>-->
        <div class="h3 col-lg-9" style="font-size: 20px;">
            <span class="visible-print">
                <b><?php echo l('reporting_period'); ?></b> : <?=date('M d, Y', strtotime($from_date));?> – <?=date('M d, Y', strtotime($to_date));?><br>
            </span>
            <span class="visible-print"><b><?php echo l('report_date'); ?></b> : <?=date('M d, Y', strtotime(date('Y-m-d')));?></span>
        </div>
    </div>
    
    <table class="table table-hover table-condensed">
        <thead>
        <tr>
            <th style="min-width:100px;" class="text-left" ><a href="<?php echo base_url()."reports/reservation/set_order_by/created_date/1"; ?>"><?php echo l('creation_date'); ?></a></th>
            <th style="min-width:100px;" class="text-left" ><a href="<?php echo base_url()."reports/reservation/set_order_by/check_in_date/1"; ?>"><?php echo l('check_in_date'); ?></a></th>
            <th class="text-left"><?php echo l('no_of_nights'); ?></th>
            <th class="text-center"><a href="<?php echo base_url()."reports/reservation/set_order_by/booking_id/1"; ?>"><?php echo l('booking')." ".l('id'); ?></a></th>
            <th style="min-width: 130px;" class="text-center"><?php echo l('Number of Adults'); ?></th>
            <th style="min-width: 130px;" class="text-center"><?php echo l('Number of Children'); ?></th>
            <th style="min-width: 130px;" class="text-center"><?php echo l('booking_source'); ?></th>
            <th style="min-width: 130px;" class="text-center"><?php echo l('retail'); ?></th>
            <th style="" class="text-center"><?php echo l('channel_supplied_rate'); ?></th>
            <th style="" class="text-center"><?php echo l('commission_rate'); ?></th>
            <th style="" class="text-center"><?php echo l('supplied_rate'); ?></th>
<!--            <th style="min-width: 130px;" class="text-left"><?php echo l('ota_confirmtion'); ?></th>-->
            <th style="min-width: 100px;"  class="text-left"><?php echo l('guest_name'); ?></th>
            <th class="text-left"><?php echo l('phone_number'); ?></th>
<!--            <th style="min-width: 100px;"  class="text-left"><a href="<?php echo base_url()."reports/reservation/set_order_by/first_name/1"; ?>"><?php echo l('booked_by'); ?></a></th>-->
<!--            <th class="text-left">Rate</th>-->
            <th class="text-left"><?php echo l('room_type'); ?></th>
            <th style="min-width: 100px;" class="text-left"><?php echo l('rate_plan'); ?></th>
            <th class="text-left"><a href="<?php echo base_url()."reports/reservation/set_order_by/state/1"; ?>"><?php echo l('status'); ?></a></th>
            <th class="text-left"><?php echo l('booking_notes'); ?></th>
        </tr>
        </thead>
        <tbody>
        <?php
        $common_booking_sources = json_decode(COMMON_BOOKING_SOURCES, true); 
        $booking_source_settings = $this->Booking_source_model->get_common_booking_sources_settings($this->company_id);
        foreach ($bookings as $booking): 
            // specific requirement from Cirque du Soleil Résidence hotel - overlaping days from both periods is No of Days.             
            if($this->company_id == "8490010654"){
                $no_of_days = MAX(MIN(strtotime($to_date), strtotime($booking['check_out_date'])) - MAX(strtotime($from_date), strtotime($booking['check_in_date'])) + 1, 0);
                $no_days = floor($no_of_days / (60 * 60 * 24));
            }
            else
            {
                $date1 = date_create($booking['check_in_date']);
                $date2 = date_create($booking['check_out_date']);
                $no_of_days = date_diff($date1, $date2);
                $no_days = $no_of_days->format("%a");
            }
            
            $commission_rate_percentage = $booking['commission_rate'] ? $booking['commission_rate'] 
                    : (isset($booking_source_settings[$booking['source']]) ? $booking_source_settings[$booking['source']]['commission_rate'] : 0);
            $retail = floatval($booking['balance']) - floatval($booking['payment_total']);
            $commission_rate = floatval($retail) * floatval($commission_rate_percentage) * 0.01;
            $channel_supplied_rate = $retail - $commission_rate;
            $supplied_rate = $booking['supplied_rate'];
            
            if($show_decimal)
            {
                $retail = number_format($retail, 2, ".", ",");
                $channel_supplied_rate = number_format($channel_supplied_rate, 2, ".", ",");
                $commission_rate = number_format($commission_rate, 2, ".", ",");
                $supplied_rate = number_format($supplied_rate, 2, ".", ",");
            }
            else
            {
                $retail = number_format($retail);
                $channel_supplied_rate = number_format($channel_supplied_rate);
                $commission_rate = number_format($commission_rate);
                $supplied_rate = number_format($supplied_rate);
            }
            
            //if ($booking['state'] == OUT_OF_ORDER)
            //    continue;
            ?>
            <tr class='booking' data-booking-id='<?php echo $booking['booking_id']; ?>'>
                <td>
                    <?php                    
                        echo date('Y-m-d', strtotime($booking['created_date']));
                    ?>
                </td>
                <td>
                    <?php
                    //if($state_value == 10){
                      //  echo $booking['check_out_date'];
                    //}
                    //else{
                        echo $booking['check_in_date'];
                    //}
                    ?>
                </td>
                <td class="text-center">
                    <?php
                        echo $no_days;
                    ?>
                </td>
                <td class="text-center">
                    <?php
                        echo $booking['booking_id'];
                    ?>
                </td>
                <td class="text-center">
                    <?php
                        echo $booking['adult_count'];
                    ?>
                </td>
                <td class="text-center">
                    <?php
                        echo $booking['children_count'];
                    ?>
                </td>
                <td class="text-center">
                    <?php 
		    	echo is_numeric($booking['booking_source']) ? (isset($common_booking_sources[$booking['booking_source']]) ? $common_booking_sources[$booking['booking_source']] : "") : $booking['booking_source']; 
		    ?>
                </td>
                <td class="text-center">
                    <?php 
                        echo $retail;
                    ?>
                </td>
                <td class="text-center">
                    <?php 
                        echo $channel_supplied_rate;
                    ?>
                </td>
                <td class="text-center">
                    <?php 
                        echo $commission_rate;
                    ?>
                </td>
                <td class="text-center">
                    <?php 
                        echo $supplied_rate;
                    ?>
                </td>
                <td>
                    <?php
                    echo $booking['customer_name'];
                    ?>
                </td>
                <td>
                    <?php
                    echo $booking['phone'];
                    ?>
                </td>
                <td>
                    <?php
                    echo $booking['r_name'];
                    ?>
                </td>
                <td>
                    <?php
                    echo $booking['rate_plan_name'];
                    ?>
                </td>
                <td>
                    <?php
                    if($booking['is_deleted'] == 1) {
                        echo "Deleted";
                    }
                    elseif($booking['state'] == 0) {
                        echo "Reservation";
                    }
                    else{
                        echo $states[$booking['state']];
                    }
                    ?>
                </td>
                <td>
                    <?php
                    echo $booking['booking_notes'];
                    ?>
                </td>
            </tr>
            <?php
        endforeach;
        ?>
        </tbody>

    </table>

</div>
<?php
$flag = 1;
$permissions = $this->session->userdata('permissions');
if (in_array('bookings_view_only', $permissions) && !(in_array('access_to_bookings', $permissions))) {
    $flag = 0;
}
?>
<input type="hidden" name="flag" value="<?php echo $flag; ?>" >
<input type="hidden" name="current-page" id="current-page" value="show_reservation_report_cm" >
