<style type="text/css">
    @media print {
  body {
    zoom: 80%; /* Shrinks everything a little to fit */
  }

  table {
    width: 100% !important;
    border-collapse: collapse;
    table-layout: fixed; /* force equal column widths */
  }

  th, td {
    font-size: 11px;  /* smaller text for fitting */
    padding: 4px;
    word-wrap: break-word; /* wrap long text */
    white-space: normal !important; /* allow wrapping */
  }

  /* Ensure header/footer buttons do not print */
  .no-print, button, .print-button {
    display: none !important;
  }

  /* Optional: always print in landscape */
  /*@page {
    size: A4 landscape;
    margin: 10mm;
  }*/
}

</style>
<div id="printable-container">
    <div class="app-page-title">
        <div class="page-title-wrapper">
            <div class="page-title-heading">
                <div class="page-title-icon">
                    <i class="pe-7s-notebook text-success"></i>
                </div>
                <?php echo l('Reservation Report', true); ?>
            </div>
        </div>
    </div>
    
    <div class="main-card card">
        <div class="card-body">
            <div class="panel panel-default hidden-print">
                <div class="panel-body h4">
                    <div class="form-inline">
                        <?php echo l('From', true); ?>
                        <?php
                        $this->load->helper('customer_name');

                        if($this->company_id == 4660){
                            $states = Array(
                            "-1" => "All",
                            '0' => "Confirmed",
                            '1' => "In-House",
                            '2' => "Checked-out",
                            '3' => "Out of Order",
                            "5" => "No Show",
                            '7' => "Unconfirmed",
                            '10' => "Departure",
                            '11' => "Arrivals"
                        );

                        }else{
                            $states = Array(
                            "-1" => "All",
                            '0' => "Confirmed",
                            '1' => "In-House",
                            '2' => "Checked-out",
                            '3' => "Out of Order",
                            '4' => "Cancelled",
                            "5" => "No Show",
                            '6' => "Deleted",
                            '7' => "Unconfirmed",
                            '10' => "Departure",
                            '11' => "Arrivals"
                        );
                        }
                        ?>
                        <select name="state" class="form-control">
                            <?php foreach ($states as $index => $state): ?>
                                <option
                                value="<?php echo $index; ?>"
                                <?php if ($selected_state == $index) { echo ' selected="selected"'; }?>
                                >
                                <?php echo $state; ?>
                            </option>

                        <?php endforeach; ?>
                    </select>
                    <?php echo l('Bookings between', true); ?>
                    <input type="text" name="from_date" value="<?php echo $from_date; ?>" class="form-control from_date" style="width: 100px;">
                    <?php echo l('and', true); ?>
                    <input type="text" name="to_date" value="<?php echo $to_date; ?>" class="form-control input-margin-fix to_date" style="width: 100px;">

                    <?php
                    $reservation_settings = $company_details['reservation_settings'];
                    if($reservation_settings == "") {
                        $reservation_settings = "created_date,booking_id,status,room,check_in_date,check_out_date,customer_names,email,phone,customer_notes,customer_type,no_of_days";
                    }
                    $settings = explode(',', $reservation_settings);
                    ?>

                    <button id="generate_reserv_report" class="btn btn-success hidden-print"><?php echo l('generate_report'); ?></button>

                    <div class="button-group pull-right" style="margin: 2px;">
                        <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                            <span class="glyphicon glyphicon-cog"></span>
                            <span class="caret"></span>
                        </button>
                        <ul class="dropdown-menu column_filter" style="top: 170px;">
                            <li name="created_date">
                                <a href="#" class="small" data-value="option1" value="created_date"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('created_date', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('created_date', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Creation Date', true); ?>
                                </a>
                            </li>
                            <li name="booking_id">
                                <a href="#" class="small" data-value="option1" value="booking_id"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('booking_id', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Booking', true).' '.l('Id', true); ?>
                                </a>
                            </li>
                            <li name="balance">
                                <a href="#" class="small" data-value="option1" value="balance"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('balance', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('balance', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Balance', true); ?>
                                </a>
                            </li>
                            <li name="no_of_days">
                                <a href="#" class="small" data-value="option1" value="no_of_days"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('no_of_days', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('no_of_days', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Length Of Stay', true); ?>
                                </a>
                            </li>
                            <li name="adult_count">
                                <a href="#" class="small" data-value="option1" value="adult_count"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('adult_count', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Number of Adults', true); ?>
                                </a>
                            </li>
                            <li name="children_count">
                                <a href="#" class="small" data-value="option1" value="children_count"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('children_count', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Number of Children', true); ?>
                                </a>
                            </li>
                            <li name="status">
                                <a href="#" class="small" data-value="option2" value="status"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('status', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Status', true); ?>
                                </a>
                            </li>
                            <li name="room">
                                <a href="#" class="small" data-value="option3" value="room"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('room', $settings)) { ?> checked class="selected_column" <?php } ?> />&nbsp;<?php echo l('Room', true); ?>
                                </a>
                            </li>
                            <li name="check_in_date">
                                <a href="#" class="small" data-value="option4" value="check_in_date"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('check_in_date', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Check-In Date', true); ?>
                                </a>
                            </li>
                            <li name="check_out_date">
                                <a href="#" class="small" data-value="option5" value="check_out_date"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('check_out_date', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Check-Out Date', true); ?>
                                </a>
                            </li>
                            <li name="booking_source">
                                <a href="#" class="small" data-value="option4" value="booking_source"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('booking_source', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Booking Source', true); ?>
                                </a>
                            </li>
                            <li name="customer_name">
                                <a href="#" class="small" data-value="option6" value="customer_name"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('customer_name', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('customer_name', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Guest Name', true); ?>
                                </a>
                            </li>
                            <li name="email">
                                <a href="#" class="small" data-value="option7" value="email"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('email', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('email', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Guest Email', true); ?>
                                </a>
                            </li>
                            <li name="phone">
                                <a href="#" class="small" data-value="option8" value="phone"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('phone', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('phone', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Guest Phone', true); ?>
                                </a>
                            </li>
                            <li name="address">
                                <a href="#" class="small" data-value="option8" value="address"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('address', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('address', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Guest Address', true); ?>
                                </a>
                            </li>
                            <li name="state">
                                <a href="#" class="small" data-value="option8" value="state"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('state', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('state', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Guest State', true); ?>
                                </a>
                            </li>
                            <li name="city">
                                <a href="#" class="small" data-value="option8" value="city"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('city', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('city', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Guest city', true); ?>
                                </a>
                            </li>
                            <li name="postal_code">
                                <a href="#" class="small" data-value="option8" value="postal_code"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('postal_code', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('postal_code', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Guest Postal Code', true); ?>
                                </a>
                            </li>
                            <li name="country">
                                <a href="#" class="small" data-value="option8" value="country"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('country', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('country', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Guest Country', true); ?>
                                </a>
                            </li>
                            <li name="ota_confirmtion">
                                <a href="#" class="small" data-value="option1" value="ota_confirmtion"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('ota_confirmtion', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('ota_confirmtion', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('OTA Confirmtion', true); ?>
                                </a>
                            </li>
                            <li name="booked_by">
                                <a href="#" class="small" data-value="option1" value="booked_by"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('booked_by', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('booked_by', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Booked By', true); ?>
                                </a>
                            </li>
                            <li name="rate">
                                <a href="#" class="small" data-value="option1" value="rate"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('rate', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('rate', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Rate', true); ?>
                                </a>
                            </li>
                            <li name="rate_plan">
                                <a href="#" class="small" data-value="option1" value="rate_plan"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('rate_plan', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('rate_plan', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Rate Plan', true); ?>
                                </a>
                            </li>
                            <li name="booking_notes_desc">
                                <a href="#" class="small" data-value="option1" value="booking_notes"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('booking_notes_desc', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('booking_notes_desc', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Booking Notes', true); ?>
                                </a>
                            </li>
                            <li name="customer_type">
                                <a href="#" class="small" data-value="option1" value="customer_type"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('customer_type', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('customer_type', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Customer Type', true); ?>
                                </a>
                            </li>
                            <?php if($this->company_id == 2733) { ?>
                            <li name="charge_sub_total">
                                <a href="#" class="small" data-value="option1" value="charge_sub_total"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('charge_sub_total', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('charge_sub_total', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Charge Sub Total', true); ?>
                                </a>
                            </li>
                            <li name="charge_tax_total">
                                <a href="#" class="small" data-value="option1" value="charge_tax_total"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('charge_tax_total', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('charge_tax_total', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Charge Tax Total', true); ?>
                                </a>
                            </li>
                            <li name="charge_final_total">
                                <a href="#" class="small" data-value="option1" value="charge_final_total"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('charge_final_total', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('charge_final_total', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Charge Grand Total', true); ?>
                                </a>
                            </li>
                            <li name="payment_method">
                                <a href="#" class="small" data-value="option1" value="payment_method"  tabIndex="-1">
                                    <input type="checkbox" class="columns_checkbox<?php if(in_array('payment_method', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('payment_method', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Payment Method', true); ?>
                                </a>
                            </li>
                            <?php } ?>
                                <li name="total_reservation_amount">
                                    <a href="#" class="small" data-value="option1" value="total_reservation_amount"  tabIndex="-1">
                                        <input type="checkbox" class="columns_checkbox<?php if(in_array('total_reservation_amount', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('total_reservation_amount', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Total Reservation amount', true); ?>
                                    </a>
                                </li>
                                <li name="paid_amount">
                                    <a href="#" class="small" data-value="option1" value="paid_amount"  tabIndex="-1">
                                        <input type="checkbox" class="columns_checkbox<?php if(in_array('paid_amount', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('paid_amount', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Paid amount', true); ?>
                                    </a>
                                </li>
                            <?php krsort($common_customer_fields);
                            if(count($common_customer_fields) !=0){
                                foreach($common_customer_fields as $fields){
                                    if(isset($fields['show_on_in_house_report']) && $fields['show_on_in_house_report'] == 1){

                                        $field = preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']);
                                        if($fields['show_on_in_house_report']==1 && $fields['name'] != 'Name' && $fields['name'] != 'Customer Type' && $fields['name'] != 'Notes'){ ?>
                                            <li name="<?php echo $field; ?>">
                                                <a href="#" class="small" data-value="option1" value="<?php echo $field; ?>"  tabIndex="-1">
                                                    <input type="checkbox" class="columns_checkbox<?php if(in_array($field, $settings)) { ?> selected_column <?php } ?>" <?php if(in_array($field, $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo $fields['name']; ?>
                                                </a>
                                            </li> 
                                        <?php }
                                    }
                                }
                            }

                            if(isset($customer_fields) && count($customer_fields) !=0){
                                foreach($customer_fields as $fields){
                                    $field = preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']);
                                    if($fields['show_on_in_house_report']==1){ ?>
                                        <li name="<?php echo $field; ?>">
                                            <a href="#" class="small" data-value="option1" value="<?php echo $field; ?>"  tabIndex="-1">
                                                <input type="checkbox" class="columns_checkbox<?php if(in_array($field, $settings)) { ?> selected_column <?php } ?>" <?php if(in_array($field, $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo $fields['name']; ?>
                                            </a>
                                        </li> 
                                    <?php }
                                }
                            }

                            if(isset($booking_fields) && count($booking_fields) !=0){
                                foreach($booking_fields as $fields){ 
                                    $field = preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']);?>
                                    <li name="<?php echo $field; ?>">
                                        <a href="#" class="small" data-value="option1" value="<?php echo $field; ?>"  tabIndex="-1">
                                            <input type="checkbox" class="columns_checkbox<?php if(in_array($field, $settings)) { ?> selected_column <?php } ?>" <?php if(in_array($field, $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo $fields['name']; ?>
                                        </a>
                                    </li>
                                <?php }
                            } ?>
                        </ul>
                    </div>

                    <button id="printReportButton" class="btn btn-primary pull-right hidden-print"><span class="glyphicon glyphicon-print" title="Print Report"></span></button>
                    &nbsp;&nbsp;
                    <?php $start_date = ($this->uri->segment(4) != '') ? $this->uri->segment(4) : ""; ?>    
                    <?php $end_date = ($this->uri->segment(5) != '') ? $this->uri->segment(5) : ""; ?>    
                    <?php $book_type = ($this->uri->segment(6) != '') ? $this->uri->segment(6) : ""; ?>    
                    <?php $book_source = ($this->uri->segment(7) != '') ? $this->uri->segment(7) : ""; ?>    
                    <?php $param = $start_date."/".$end_date."/".$book_type."/".$book_source;  ?>   
                    <a href="<?php if($param != '///'){ echo base_url()."reports/reservation/download_csv_export/".$param; } else { echo base_url()."reports/reservation/download_csv_export/"; } ?>" class="btn btn-primary pull-right " style="margin-right: 10px;">
                        <span title="Export to CSV" class="glyphicon glyphicon-download-alt"></span>
                    </a>&nbsp;&nbsp;
                </div><!-- /.form-inline -->
            </div>
        </div>

        <div class="wep">
         <!-- <div class="h3 col-lg-3"><?=$hotel_name;?></div> -->
         <div class="h3" style="font-size: 20px;">
            <span class="visible-print">
                <b><?php echo l('reporting_period'); ?></b> : <?=date('M d, Y', strtotime($from_date));?> – <?=date('M d, Y', strtotime($to_date));?><br>
            </span>
            <span class="visible-print"><b><?php echo l('report_date'); ?></b> : <?=date('M d, Y', strtotime(date('Y-m-d')));?></span>
        </div>
    </div>
    
    <div class="col-lg-12 table-responsive">
        <table id="reservation_table" class="table table-hover table-condensed reservation_table ">
            <thead>
                <tr>
                    <th style="min-width:90px;" class="text-left created_date" >
                        <a href="<?php if($param != '///'){  echo base_url()."reports/reservation/set_order_by/created_date/".$param; } ?>"><?php echo l('creation_date'); ?>
                    </a>
                </th>
                <th name="check_in_date" style="min-width:90px;" class="text-left check_in_date" >
                    <a href="<?php if($param != '///'){  echo base_url()."reports/reservation/set_order_by/check_in_date/".$param; } ?>"><?php echo l('check_in_date'); ?></a>
                </th>
                <th name="check_out_date" style="min-width:90px;" class="text-left check_out_date" ><a href="<?php if($param != '///'){  echo base_url()."reports/reservation/set_order_by/check_out_date/".$param; } ?>"><?php echo l('check_out_date'); ?></a></th>
                <th class="text-center no_of_days length_of_stay">
                    <a class="length_of_stay_asc" href="#">
                        <?php echo l('length_of_stay'); ?>
                    </a>
                    <a class="length_of_stay_desc" href="#">
                        <?php echo l('length_of_stay'); ?>
                    </a>
                </th>
                <th name="booking_id" class="text-center booking_id"><a href="<?php if($param != '///'){  echo base_url()."reports/reservation/set_order_by/booking_id/".$param; } ?>"><?php echo l('booking')." ".l('id'); ?></a></th>
                <th class="text-center balance"><a href="<?php if($param != '///'){  echo base_url()."reports/reservation/set_order_by/balance/".$param; } ?>"><?php echo l('Balance'); ?></a></th>
                

                <th style="min-width: 100px;"  class="text-left customer_name"><?php echo l('guest_name'); ?></th>
                <th style="min-width: 100px;"  class="text-left email"><?php echo l('guest_email'); ?></th>
                <th style="min-width: 100px;"  class="text-left phone"><?php echo l('guest_phone'); ?></th>
                <th style="min-width: 100px;"  class="text-left address"><?php echo l('Guest Address', true); ?></th>
                <th style="min-width: 100px;"  class="text-left state"><?php echo l('Guest State', true); ?></th>
                <th style="min-width: 100px;"  class="text-left city"><?php echo l('Guest City', true); ?></th>
                <th style="min-width: 100px;"  class="text-left postal_code"><?php echo l('Guest Postal Code', true); ?></th>
                <th style="min-width: 100px;"  class="text-left country"><?php echo l('Guest Country', true); ?></th>
                <th name="room" style="min-width: 100px;"  class="text-left room"><?php echo l('Room'); ?></th>
                
                <th name="adult_count" style="min-width: 80px;" class="text-center adult_count"><?php echo l('Number of Adults'); ?></th>
                <th name="children_count" style="min-width: 80px;" class="text-center children_count"><?php echo l('Number of Children'); ?></th>
                <th name="booking_source" style="min-width: 130px;" class="text-center booking_source"><?php echo l('booking_source'); ?></th>
                <th style="min-width: 130px;" class="text-left ota_confirmtion"><?php echo l('ota_confirmtion'); ?></th>
                <th style="min-width: 100px;"  class="text-left booked_by"><a href="<?php if($param != '///'){  echo base_url()."reports/reservation/set_order_by/first_name/".$param; } ?>"><?php echo l('booked_by'); ?></a></th>
                <th class="text-left rate"><?php echo l('Rate', true); ?></th>
                <th style="min-width: 100px;" class="text-left rate_plan"><?php echo l('rate_plan'); ?></th>
                <th name="status" class="text-left status"><a href="<?php if($param != '///'){  echo base_url()."reports/reservation/set_order_by/state/".$param; } ?>"><?php echo l('status'); ?></a></th>
                <th class="text-left booking_notes_desc"><?php echo l('booking_notes'); ?></th>
                <th style="min-width: 100px;" class="text-left customer_type"><?php echo l('customer_type'); ?></th>
                <?php if($this->company_id == 2733) { ?>
                <th style="min-width: 100px;" class="text-left charge_sub_total"><?php echo l('charge_sub_total'); ?></th>
                <th style="min-width: 100px;" class="text-left charge_tax_total"><?php echo l('charge_tax_total'); ?></th>
                <th style="min-width: 100px;" class="text-left charge_final_total"><?php echo l('grand_total'); ?></th>
                <th style="min-width: 100px;" class="text-left payment_method"><?php echo l('payment_method'); ?></th>
                <?php } ?>
                <th style="min-width: 100px;" class="text-left total_reservation_amount"><?php echo l('total_reservation_amount'); ?></th>
                <th style="min-width: 100px;" class="text-left paid_amount"><?php echo l('paid_amount'); ?></th>
                <?php krsort($common_customer_fields);
                if(count($common_customer_fields) !=0){
                    foreach($common_customer_fields as $fields){
                        if(isset($fields['show_on_in_house_report']) && $fields['show_on_in_house_report'] == 1){
                            echo ($fields['name'] != 'Name' && $fields['name'] != 'Customer Type' && $fields['name'] != 'Notes') ? "<th class=\"text-left
                            ".preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name'])."\">".$fields['name']."</th>" : '';
                        }
                    }
                }
                if(isset($customer_fields) && count($customer_fields) !=0){
                    foreach($customer_fields as $fields){
                        if($fields['show_on_in_house_report']==1){
                            echo "<th class=\"text-left ".preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name'])."\">".$fields['name']."</th>";
                        }
                    }
                }
                
                if(isset($booking_fields) && count($booking_fields) !=0){
                    foreach($booking_fields as $fields){
                        // if($fields['show_on_in_house_report']==1){
                        
                        echo "<th class=\"text-left ".preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name'])."\">".$fields['name']."</th>";
                        // }
                    }
                }
                
                ?>
            </tr>
        </thead>
        <tbody>
            <?php
            $this->ci->load->library('rate');
        // // // ==============asc order=======================

        // if (!function_exists('sortByNoOfDaysAsc')) {
        //  function sortByNoOfDaysAsc($a, $b) {
        //      // Compare 'no_of_days' values
        //      return $a['no_of_days'] - $b['no_of_days'];
        //  }
        // }
        // // Sort the results array by 'no_of_days'
        // usort($bookings, 'sortByNoOfDaysAsc');
        // // // ===============desc order======================
        // if (!function_exists('sortByNoOfDaysDesc')) {
        //  function sortByNoOfDaysDesc($a, $b) {
        //      if ($a['no_of_days'] == $b['no_of_days']) {
        //          return 0;
        //      }

        //      return ($a['no_of_days'] > $b['no_of_days']) ? -1 : 1;
        //  }
        // }

        // usort($bookings, 'sortByNoOfDaysDesc');
        // // ====================================

            foreach ($bookings as $booking):

                if($this->company_id == 2733) {

                $pay_by_card = $pay_by_cash = false;
                
                if($booking['payments']){
                    foreach($booking['payments'] as $book_pay){
                        if(
                            isset($book_pay['gateway_charge_id']) &&
                            $book_pay['gateway_charge_id']
                        ) {
                            $pay_by_card = true;
                        } else {
                            $pay_by_cash = true;
                        }
                    }
                }

                if($pay_by_card && $pay_by_cash){
                    $pay = "Cash/Card";
                }
                else if($pay_by_card && !$pay_by_cash){
                    $pay = "Card";
                }
                else if(!$pay_by_card && $pay_by_cash){
                    $pay = "Cash";
                } else {
                    $pay = null;
                }
                }

                $amount = $booking['rate'];
                
                ?>
                <tr class='booking' data-booking-id='<?php echo $booking['booking_id']; ?>'>
                    <td class="created_date">
                        <?php                    
                        echo date('Y-m-d', strtotime($booking['created_date']));
                        ?>
                    </td>
                    <td class="check_in_date">
                        <?php
                        echo ($this->enable_hourly_booking == 1 ? date('Y-m-d h:i A', strtotime($booking['check_in_date'])) : ($booking['check_in_date'] ? date('Y-m-d', strtotime($booking['check_in_date'])) : ''));
                        ?>
                    </td>
                    <td class="check_out_date">
                        <?php
                        echo ($this->enable_hourly_booking == 1 ? date('Y-m-d h:i A', strtotime($booking['check_out_date'])) : ($booking['check_out_date'] ? date('Y-m-d', strtotime($booking['check_out_date'])) : ''));
                        ?>
                    </td>
                    <td class="text-center no_of_days length_of_stay">
                        <?php
                        echo $booking['no_of_days'];
                        ?>
                    </td>
                    <td class="booking_id text-center">
                        <?php
                        echo $booking['booking_id'];
                        ?>
                    </td>
                    <td class="text-center balance">
                        <?php
                        echo $booking['balance'];
                        ?>
                    </td>
                    
                    <td class="customer_name">
                        <?php
                        //echo $booking['customer_name'];
                        ?>
                        <?php
                            echo get_customer_names($booking['customer_name'], $booking['staying_customers'], $booking['guest_count']);
                        ?>
                    </td>
                    <td class="email">
                        <?php
                        echo $booking['email'];
                        ?>
                    </td>
                    <td class="phone">
                        <?php
                        echo $booking['phone'];
                        ?>
                    </td>
                    <td class="address">
                        <?php
                        echo $booking['address'];
                        ?>
                    </td>
                    <td class="state">
                        <?php
                        echo $booking['region'];
                        ?>
                    </td>
                    <td class="city">
                        <?php
                        echo $booking['city'];
                        ?>
                    </td>
                    <td class="postal_code">
                        <?php
                        echo $booking['postal_code'];
                        ?>
                    </td>
                    <td class="country">
                        <?php
                        echo $booking['country'];
                        ?>
                    </td>
                    <td class="room">
                        <?php
                        echo $booking['room_name'];
                        ?>
                    </td>
                    <td class="adult_count text-center">
                        <?php
                        echo $booking['adult_count'];
                        ?>
                    </td>
                    <td class="children_count text-center">
                        <?php
                        echo $booking['children_count'];
                        ?>
                    </td>
                    <td class="booking_source text-center">
                        <?php
                        echo is_numeric($booking['booking_source']) ? (isset($common_booking_sources[$booking['booking_source']]) ? l($common_booking_sources[$booking['booking_source']],true) : "") : l($booking['booking_source'],true);
                        ?>
                    </td>
                    <td class="ota_confirmtion text-center">
                        <?php
                        if($booking['is_ota_booking']!=0){
                            echo "Confirmed";
                        }
                        ?>
                    </td>
                    <td class="booked_by">
                        <?php
                        echo $booking['first_name']." ".$booking['last_name'];
                        ?>
                    </td>
                    <td class="rate">
                        <?php
                        if ($booking['rate']!=0) {
                            echo number_format($booking['rate'], 2, ".", ",");
                        }
                        ?>
                    </td>
                    <td class="rate_plan">
                        <?php
                        echo $booking['rate_plan_name'];
                        ?>
                    </td>
                    <td class="status">
                        <?php
                        if($booking['booking_deleted'] == 1) {
                            echo "Deleted";
                        }
                        elseif($booking['state'] == 0) {
                            echo "Reservation";
                        }
                        else{
                            echo $states[$booking['state']];
                        }
                        ?>
                    </td>
                    <td class="booking_notes_desc">
                        <?php
                        echo $booking['booking_notes'];
                        ?>
                    </td>
                    <td class="customer_type">
                        <?php
                        echo  $booking['customer_type_name'];
                        ?>
                    </td>

                    <?php if($this->company_id == 2733) { ?>
                    <td class="charge_sub_total">
                        <?php
                        echo  $booking['charge_sub_total'];
                        ?>
                    </td>
                    <td class="charge_tax_total">
                        <?php
                        echo  $booking['charge_tax_total'];
                        ?>
                    </td>
                    <td class="charge_final_total">
                        <?php
                        echo  $booking['charge_final_total'];
                        ?>
                    </td>
                    <td class="payment_method">
                        <?php
                        echo  $pay;//$booking['payment_method'];
                        ?>
                    </td>
                    <?php } ?>
                        <td class="total_reservation_amount">
                            <?php $total_reservation_amount = $booking['balance'] + $booking['payment_total'];
                            echo number_format($total_reservation_amount, 2, ".", ",");
                            ?>
                        </td>
                        <td class="paid_amount">
                            <?php
                            echo  number_format($booking['payment_total'], 2, ".", ",");
                            ?>
                        </td>

                    <?php
                    if(count($common_customer_fields) !=0) {
                        foreach ($common_customer_fields as $id => $field) {
                            if(isset($field['show_on_in_house_report']) && $field['show_on_in_house_report'] == 1 && ($field['name'] != 'Notes' || $field['name'] != 'Name' || $field['name'] != 'Customer Type')){
                                echo ($field['name'] != 'Name' && $field['name'] != 'Customer Type' && $field['name'] != 'Notes') ? ("<td class='".preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $field['name'])."'>" . (isset($booking['customer_common_fields'][$id]) ? $booking['customer_common_fields'][$id] : "") . "</td>") : '';
                            }
                        }
                    }

                    if(isset($customer_fields) && count($customer_fields) !=0) {
                        foreach ($customer_fields as $field) {
                            if ($field['show_on_in_house_report'] == 1) {
                                echo "<td class='".preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $field['name'])."'>" . (isset($booking['customer_fields'][$field['id']]) ? $booking['customer_fields'][$field['id']] : "") . "</td>";
                            }
                        }
                    }

                    if(isset($booking_fields) && count($booking_fields) !=0) {
                        foreach ($booking_fields as $field) {
                            echo "<td class='".preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $field['name'])."'>" . (isset($booking['booking_custom_fields'][$field['id']]) ? $booking['booking_custom_fields'][$field['id']] : "") . "</td>";
                        }
                    }
                    ?>
                </tr>
                <?php
            endforeach;
            ?>
        </tbody>

    </table>
    
</div>
</div>
</div>
</div>
<?php $flag = 1;
$permissions = $this->session->userdata('permissions');
if ($permissions && in_array('bookings_view_only', $permissions) && !(in_array('access_to_bookings', $permissions))) {
    $flag = 0;
}
?>
<input type="hidden" name="flag" value="<?php echo $flag; ?>" >
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<script>
    $(document).ready(function () {
        $(".length_of_stay_desc").hide();
        
        var sortOrder = 'asc';

        function sortTable() {
            var rows = $('.reservation_table tbody tr').get();

            rows.sort(function (a, b) {
                var keyA = parseInt($(a).find('.length_of_stay').text());
                var keyB = parseInt($(b).find('.length_of_stay').text());

                if (sortOrder === 'asc') {
                    return keyA - keyB;
                } else {
                    return keyB - keyA;
                }
            });

            $.each(rows, function (index, row) {
                $('.reservation_table tbody').append(row);
            });
        }

        $('.reservation_table').on('click', '.length_of_stay_asc', function (e) {
            $(this).hide();
            $(".length_of_stay_desc").show();

            e.preventDefault();
            sortOrder = 'asc';
            sortTable();
        });


        $('.reservation_table').on('click', '.length_of_stay_desc', function (e) {
            $(this).hide();
            $(".length_of_stay_asc").show();

            e.preventDefault();
            sortOrder = 'desc';
            sortTable();
        });
    });
</script>
