<?php

class Whitelabel_partner_model extends CI_Model
{

    public function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }

    public function get_partner_detail($partner_id = null)
    {
        $partner = null;
        if ($partner_id) {
            $this->db->select('wp.*, wpxa.*, wpt.slug as partner_slug');
            $this->db->where('wp.id', $partner_id);
            $this->db->where('wp.status', '1');
            $this->db->from('whitelabel_partner AS wp');
            $this->db->join('whitelabel_partner_x_admin AS wpxa', "wp.id = wpxa.partner_id", "left");
            $this->db->join('whitelabel_partner_type AS wpt', "wp.type_id = wpt.id", "left");
            $this->db->group_by('wp.id');
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                $partner = $query->result_array()[0];
            }
        }

        if (!$partner && $this->user_id) { // if current user is a admin of any whitelabel partner
            $this->db->select('wp.*, wpxa.*, wpt.slug as partner_slug');
            $this->db->where('wpxa.admin_id', $this->user_id);
            $this->db->where('wp.status', '1');
            $this->db->from('whitelabel_partner AS wp');
            $this->db->join('whitelabel_partner_x_admin AS wpxa', "wp.id = wpxa.partner_id", "left");
            $this->db->join('whitelabel_partner_type AS wpt', "wp.type_id = wpt.id", "left");
            $this->db->group_by('wp.id');
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                $partner = $query->result_array()[0];
            }
        }

        if ($partner) {
            $partner['admins'] = $this->get_whitelabel_admin_ids(null, $partner_id);
        }

        return $partner;
    }

    // function to get whitelabel admin_id
    public function get_whitelabel_admin_ids($user_id = null, $partner_id = null)
    {
        $this->db->select('wpxa.admin_id');
        $this->db->from('whitelabel_partner as wp');
        $this->db->join('whitelabel_partner_x_admin AS wpxa', "wp.id = wpxa.partner_id", "left");

        if ($user_id !== null) {
            $this->db->join('users as u', 'u.partner_id = wp.id', 'left');
            $this->db->where('u.id', $user_id);
        }
        if ($partner_id !== null) {
            $this->db->where('wp.id', $partner_id);
        }

        $query = $this->db->get();
        $admins = array();
        if ($query->num_rows() > 0) {
            foreach ($query->result_array() as $admin) {
                $admins[] = $admin['admin_id'];
            }
        }
        return $admins;
    }

}
