<?php

class Room_model extends CI_Model
{

    public function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }

    public function get_all_room_types($company_id)
    {
        $this->db->where('rt.company_id', $company_id);
        $this->db->where('r.room_type_id = rt.id');
        $query = $this->db->get('room as r, room_type as rt');

        if ($query->num_rows() > 0) {
            $result = $query->result_array(0);
            return $result;
        } else {
            return null;
        }
    }

    function get_rate_plan($rate_plan_id)
    {
        $this->db->select("rp.*, r.*");
        $this->db->from("rate_plan as rp");
        $this->db->join("rate as r","rp.base_rate_id = r.rate_id", "left");
        $this->db->where("rp.is_deleted != '1'");
        $this->db->where("rp.rate_plan_id", $rate_plan_id);
        
        $query = $this->db->get();
        //echo $this->db->last_query();
        if ($this->db->_error_message()) // error checking
            show_error($this->db->_error_message());
        if ($query->num_rows >= 1) 
        {
            $q = $query->result_array();
            return $q[0];
        }
        return NULL;
    }
}
