<?php

class Booking_source_model extends CI_Model {

	function __construct()
    {        
        parent::__construct(); // Call the Model constructor
    }
	
	function get_booking_source($company_id, $show_deleted = false, $show_hidden = false)
	{
		$this->db->where('company_id', $company_id);
		if (!$show_deleted)        
			$this->db->where('is_deleted', 0);
        
        if (!$show_hidden)
            $this->db->where('is_hidden', 0);
        
		$this->db->order_by("sort_order, name", "asc");
		
		$query = $this->db->get('booking_source');
		
		if ($query->num_rows >= 1) 
			return $query->result_array();
		return NULL;
	}
	
    function get_common_booking_sources_settings($company_id){
        $this->db->where('company_id', $company_id);		
        $this->db->order_by('sort_order', 'ASC');		
		$query = $this->db->get('common_booking_source_setting');
		$response = array();
		if ($query->num_rows >= 1) {
			$result = $query->result_array();
            foreach($result as $setting)
            {
                $response[$setting['booking_source_id']] = $setting;
            }
        }
        return $response;
    }
}