<?php

class Booking_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library("Forecast_charges");
    }

    /*Return bookings for reservation report*/
    public function get_bookings_for_report($filters, $company_id = 0, $group_by1 = null, $include_customer_all_details = false)
    {
        if ($company_id == 0) {
            $company_id = $this->session->userdata('current_company_id');
        }

        $sql = $this->_build_get_bookings_sql_query_based_on_filters_report($filters, $company_id, $group_by1, $include_customer_all_details);

        $q = $this->db->query($sql);
        //echo $this->db->last_query();

        if ($this->db->_error_message()) {
            show_error($this->db->_error_message());
        }

        $result = $q->result_array();

        return $result;
    }

    public function get_group_bookings($filters, $company_id = 0, $group_by1 = null)
    {
        if ($company_id == 0) {
            $company_id = $this->session->userdata('current_company_id');
        }

        $sql = $this->_build_get_group_bookings_sql_query_based_on_filters($filters, $company_id, $group_by1);

        $q = $this->db->query($sql);

        if ($this->db->_error_message()) {
            show_error($this->db->_error_message());
        }

        $result = $q->result_array();
        return $result;
    }

    public function get_group_ids($from_date, $to_date)
    {
        $this->db->select('brh.*, bxblg.*');
        $this->db->from('booking_block as brh');
        $this->db->join('booking_x_booking_linked_group as bxblg', 'brh.booking_id = bxblg.booking_id');
        $this->db->where('DATE(brh.check_in_date) >=', $from_date);
        $this->db->where('DATE(brh.check_out_date) <=', $to_date);
        $this->db->group_by('bxblg.booking_group_id');

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_bookings($filters, $company_id = 0, $group_by1 = null, $include_room_no_assigned = false, $include_customer_all_details = false)
    {
        if ($company_id == 0) {
            $company_id = $this->session->userdata('current_company_id');
        }

        $sql = $this->_build_get_bookings_sql_query_based_on_filters($filters, $company_id, $group_by1, $include_room_no_assigned, $include_customer_all_details);
//                echo $sql;
        $q = $this->db->query($sql);

        //echo $this->db->last_query();

        if ($this->db->_error_message()) {
            show_error($this->db->_error_message());
        }

        $result = $q->result_array();

        return $result;
    }

    /*
     * Generate and return query for booking based on filters
     * */
    public function _build_get_bookings_sql_query_based_on_filters_report($filters, $company_id, $group_by1, $include_customer_all_details = false)
    {

        $where_conditions = $this->_get_inhouse_where_conditions($filters, $company_id);

        // set order by
        $order_by = "";
        if (isset($filters['order_by'])) {
            // if both $star and $end are set, then return occupancies within range
            if ($filters['order_by'] != "") {
                $order_by = "ORDER BY " . $filters['order_by'];
            } else {
                $order_by = "ORDER BY bl.date_time";
            }
        }

        // set order
        $order = "";
        if (isset($filters['order'])) {
            if ($filters['order'] != "") {
                if ($filters['order'] == 'DESC') {
                    $order = "DESC";
                }
                if ($filters['order'] == 'ASC') {
                    $order = "ASC";
                }
            } else {
                $order = "DESC";
            }
        }

        $booking_log_join = '';
        if (isset($filters['state'])) {
            if ($filters['state'] == '1') // checkin
            {
                $booking_log_join = "LEFT JOIN booking_log bl_checkin ON bl_checkin.booking_id = b.booking_id AND bl_checkin.log_type = '5' AND bl_checkin.log = '1'";
            } else if ($filters['state'] == '2') // checkout
            {
                $booking_log_join = "LEFT JOIN booking_log bl_checkout ON bl_checkout.booking_id = b.booking_id AND bl_checkout.log_type = '5' AND bl_checkout.log = '2'";
            } else if ($filters['state'] == '3') // out of order
            {
                $booking_log_join = "LEFT JOIN booking_log bl_out_of_order ON bl_out_of_order.booking_id = b.booking_id AND bl_out_of_order.log_type = '5' AND bl_out_of_order.log = '3'";
            } else if ($filters['state'] == '4') // cancelled
            {
                $booking_log_join = "LEFT JOIN booking_log bl_cancelled ON bl_cancelled.booking_id = b.booking_id AND
                (
                    (
                        bl_cancelled.log_type = '5' OR bl_cancelled.log = '4'
                    ) OR
                    (
                        bl_cancelled.log_type = '0' AND bl_cancelled.log = 'OTA Booking cancelled'
                    )
                ) ";
            } else if ($filters['state'] == '5') // no show
            {
                $booking_log_join = "LEFT JOIN booking_log bl_noshow ON bl_noshow.booking_id = b.booking_id AND bl_noshow.log_type = '5' AND bl_noshow.log = '5'";
            } else if ($filters['state'] == '7') // unconfirmed
            {
                $booking_log_join = "LEFT JOIN booking_log bl_unconfirmed ON bl_unconfirmed.booking_id = b.booking_id AND bl_unconfirmed.log_type = '5' AND bl_unconfirmed.log = '7'";
            } else if ($filters['state'] == '6') // Deleted
            {
                $booking_log_join = "LEFT JOIN booking_log bl_deleted ON bl_deleted.booking_id = b.booking_id AND bl_deleted.log_type = '1' AND bl_deleted.log = 'Booking deleted'";
            } else if ($filters['state'] == '10') // Depatures
            {
                $booking_log_join = "LEFT JOIN booking_log bl_departure ON bl_departure.booking_id = b.booking_id AND bl_departure.log_type = '5' AND (bl_departure.log = '2')";
            } else if ($filters['state'] == '11') // Arrivals
            {
                $booking_log_join = "LEFT JOIN booking_log bl_arrivals ON bl_arrivals.booking_id = b.booking_id AND ((bl_arrivals.log_type = '5' AND bl_arrivals.log = '1'))";
            }
        }

        $select_customer_type = $join_customer_type = "";
        if (isset($filters['include_customer_type']) && $filters['include_customer_type']) {

            $select_customer_type = "ct.name as customer_type_name,
                                    b.adult_count,
                                    b.children_count,
                                    cxcf.value,
                                    GROUP_CONCAT(DISTINCT cxcf2.value, ' ') as custom_field_value,
                                    GROUP_CONCAT(DISTINCT c.customer_id, ' ') as staying_customer_id,";

            $join_customer_type = "LEFT JOIN customer_type as ct ON ct.id = c.customer_type_id
                    LEFT JOIN customer_x_customer_field as cxcf ON cxcf.customer_id = b.booking_customer_id AND b.booking_customer_id != '0'
                    LEFT JOIN customer_field as cf ON cxcf.customer_field_id = cf.id
                    LEFT JOIN customer_x_customer_field as cxcf2 ON cxcf2.customer_field_id = cf.id AND c.customer_id = c.customer_id AND cxcf2.customer_id = c.customer_id
                    ";
        }

        $select_booking_fields = $join_booking_fields = "";
        if (isset($filters['include_booking_fields']) && $filters['include_booking_fields']) {

            $select_booking_fields = "bxbf.value,
                                    GROUP_CONCAT(IF(bxbf2.value != '', bxbf2.value, ''), ' ') as booking_custom_field_value,
                                    GROUP_CONCAT(DISTINCT bxbf2.booking_field_id, ' ') as booking_field_id,";

            $join_booking_fields = "LEFT JOIN booking_x_booking_field as bxbf ON bxbf.booking_id = b.booking_id AND b.booking_id != '0'
                    LEFT JOIN booking_field as bf ON bxbf.booking_field_id = bf.id
                    LEFT JOIN booking_x_booking_field as bxbf2 ON bxbf2.booking_field_id = bf.id AND bxbf2.booking_id = b.booking_id";
        }

        $select_customer_details = "";
        if ($include_customer_all_details) {
            $select_customer_details = "c.phone2,
                                        c.fax,
                                        c.address,
                                        c.address2,
                                        c.city,
                                        c.region,
                                        c.country,
                                        c.postal_code,
                                        c.customer_notes,";
        }

        $sql = "SELECT
                    b.*,
                    bs.commission_rate,
                    c.customer_name,
                    c.phone,
                    r.*,
                    brh.check_in_date,
                    brh.check_out_date,
                    rp.rate_plan_name,
                    cm.name as company_name,
                    up.first_name, up.last_name,
                    bl.date_time as created_date,
                    blg.name AS group_name,
                    count(DISTINCT sg.customer_id) as guest_count,
                    GROUP_CONCAT(DISTINCT sg.customer_name, ' ') as staying_customers,
                    (   SELECT c2.customer_name
                            FROM customer as c2, booking_staying_customer_list as bscl2
                            WHERE
                                    c2.customer_id = bscl2.customer_id AND
                                    bscl2.booking_id = b.booking_id
                            LIMIT 0,1
                    ) as guest_name,
                    $select_booking_fields
                    $select_customer_type
                    $select_customer_details
                    IF(b.source > 20, (SELECT bs.name FROM booking_source as bs WHERE bs.id = b.source LIMIT 1), b.source) as booking_source,
                    IFNULL(
                    (
                        SELECT SUM(p.amount) as payment_total
                        FROM payment as p, payment_type as pt
                        WHERE
                            p.is_deleted = '0' AND
                            pt.is_deleted = '0' AND
                            p.payment_type_id = pt.payment_type_id AND
                            p.booking_id = b.booking_id
                        GROUP BY p.booking_id
                    ), 0) as payment_total
                FROM
                    `booking` b
                LEFT JOIN customer c
                    ON c.customer_id = b.booking_customer_id
                LEFT JOIN booking_log bl
                    ON bl.booking_id = b.booking_id AND (bl.log = 'Booking created' OR bl.log = 'OTA Booking created' OR bl.log = 'OTA Booking modified' OR bl.log = 'Online reservation submitted')
                $booking_log_join
                LEFT JOIN user_profiles up
                    ON up.user_id = bl.user_id
                LEFT JOIN booking_block as brh
                    ON brh.booking_id = b.booking_id
                LEFT JOIN room as r
                    ON brh.room_id = r.room_id
                LEFT JOIN rate_plan as rp
                    ON rp.rate_plan_id = b.rate_plan_id
                LEFT JOIN company as cm
                    ON cm.company_id = b.company_id
                LEFT JOIN booking_source bs
                    ON bs.id = b.source
                LEFT JOIN booking_staying_customer_list as bscl ON bscl.booking_id = b.booking_id
                LEFT JOIN customer as sg ON bscl.customer_id = sg.customer_id
                LEFT JOIN booking_x_group AS bxs ON bxs.booking_id = brh.booking_id
                LEFT JOIN booking_x_booking_linked_group AS bxblg ON bxblg.booking_id = brh.booking_id
                LEFT JOIN booking_linked_group AS blg ON blg.id = bxblg.booking_group_id
                $join_customer_type
                $join_booking_fields
                $where_conditions
                GROUP BY b.booking_id
                $order_by $order";

        return $sql;
    }

    /*
     * Generate and return where conditions for inhouse
     * */
    public function _get_inhouse_where_conditions($filters, $company_id)
    {
        //Generate booking type portion of the SQL statement
        $state_sql = "";
        if (isset($filters['state'])) {
            if ($filters['state'] == 'active') // Show all reservation, inhouse, and checkout guests. Called from calendar
            {
                $state_sql = "AND (b.state <= 4 OR b.state = '" . UNCONFIRMED_RESERVATION . "')";
            } elseif ($filters['state'] == 'all' || $filters['state'] == '' || $filters['state'] == 6) {
                $state_sql = "";
            } elseif ($filters['state'] == 10 || $filters['state'] == 11) // arrival, departure
            {
                $state_sql = "";
            } else {
                $state_sql = "AND b.state = '" . $filters['state'] . "'";
            }
        }

        //Generate time portion of the SQL statement
        $time_sql = "";

        $date_overlap_sql = "";

        if (isset($filters['is_channel_manager']) && $filters['is_channel_manager'] == 1) {
            if ($filters['state'] == 'active' || $filters['state'] == '0') {
                $time_sql .= "AND (DATE(bl.date_time) <= '" . $filters['end_date'] . "' AND DATE(bl.date_time) >= '" . $filters['start_date'] . "')";
            }
            if (isset($filters['booking_source']) && $filters['booking_source'] != 'active') {
                $time_sql .= "AND b.source = " . $filters['booking_source'];
            }
        } else {
            if ($filters['state'] == 'active' || $filters['state'] == '0') {
                $time_sql .= "AND (DATE(check_in_date) <= '" . $filters['end_date'] . "' AND DATE(check_out_date) >= '" . $filters['start_date'] . "')";
                //$time_sql = " AND DATE(bl.date_time) >= '".$filters['start_date']."' AND DATE(bl.date_time) <= '".$filters['end_date']."'";
            }
        }

        if ($filters['state'] == '1') // check-in
        {
            //$time_sql .= " AND DATE(bl_checkin.date_time) >= '".$filters['start_date']."' AND DATE(bl_checkin.date_time) <= '".$filters['end_date']."'";
        } else if ($filters['state'] == '2') // check-out
        {
            $time_sql .= " AND DATE(bl.date_time) <= '" . $filters['end_date'] . "' AND DATE(check_in_date) <= '" . $filters['end_date'] . "'  AND DATE(bl_checkout.date_time) >= '" . $filters['start_date'] . "' AND DATE(bl_checkout.date_time) <= '" . $filters['end_date'] . "'";
        } else if ($filters['state'] == '3') // out of order
        {
            $time_sql .= " AND DATE(bl.date_time) <= '" . $filters['end_date'] . "' AND DATE(check_in_date) <= '" . $filters['end_date'] . "' AND DATE(check_out_date) >= '" . $filters['start_date'] . "' ";
        } else if ($filters['state'] == '4') // cancelled
        {
            $time_sql .= " AND DATE(bl.date_time) <= '" . $filters['end_date'] . "' AND DATE(bl_cancelled.date_time) >= '" . $filters['start_date'] . "' AND DATE(bl_cancelled.date_time) <= '" . $filters['end_date'] . "'";
        } else if ($filters['state'] == '5') // no show
        {
            $time_sql .= " AND DATE(bl.date_time) <= '" . $filters['end_date'] . "' AND DATE(bl_noshow.date_time) >= '" . $filters['start_date'] . "' AND DATE(bl_noshow.date_time) <= '" . $filters['end_date'] . "'";
        } else if ($filters['state'] == '7') // unconfirmed
        {
            $time_sql .= " AND DATE(bl.date_time) <= '" . $filters['end_date'] . "' AND DATE(bl_unconfirmed.date_time) >= '" . $filters['start_date'] . "' AND DATE(bl_unconfirmed.date_time) <= '" . $filters['end_date'] . "'";
        } else if ($filters['state'] == '6') // deleted
        {
            $time_sql .= " AND DATE(bl.date_time) <= '" . $filters['end_date'] . "' AND DATE(bl_deleted.date_time) >= '" . $filters['start_date'] . "' AND DATE(bl_deleted.date_time) <= '" . $filters['end_date'] . "'";
        } else if ($filters['state'] == '10') // departure
        {
            //$time_sql .= " AND DATE(bl.date_time) <= '".$filters['end_date']."' AND ((DATE(bl_departure.date_time) >= '".$filters['start_date']."' AND DATE(bl_departure.date_time) <= '".$filters['end_date']."') OR (check_out_date <= '".$filters['end_date']."' AND check_out_date >= '".$filters['start_date']."') )";
            $time_sql .= " AND DATE(bl.date_time) <= '" . $filters['end_date'] . "' AND DATE(check_out_date) <= '" . $filters['end_date'] . "' AND DATE(check_out_date) >= '" . $filters['start_date'] . "'";
        } else if ($filters['state'] == '11') // Arrivals
        {
            //$time_sql .= " AND DATE(bl.date_time) <= '".$filters['end_date']."' AND ((DATE(bl_arrivals.date_time) >= '".$filters['start_date']."' AND DATE(bl_arrivals.date_time) <= '".$filters['end_date']."'))";
            $time_sql .= " AND DATE(bl.date_time) <= '" . $filters['end_date'] . "' AND DATE(check_in_date) <= '" . $filters['end_date'] . "' AND DATE(check_in_date) >= '" . $filters['start_date'] . "'";
        }

        // set search query
        if ($filters['state'] == 6) {
            $is_deleted = '0';
        } else {
            $is_deleted = '1';
        }
        $where_conditions = " WHERE
            b.company_id = '$company_id' AND
            b.is_deleted != $is_deleted
            $time_sql
            $state_sql
            $date_overlap_sql
        ";
        return $where_conditions;
    }
}
