<?php

class Muster_list_booking_model extends CI_Model {

    function __construct()
    {
        parent::__construct();
    }
    
    function get_bookings_for_report($filters, $company_id = 0, $group_by1 = NULL)
    {
        if ($company_id == 0)
        {
            $company_id = $this->session->userdata('current_company_id');
        }
        
        // set order by
        $order_by = "";
        if (isset($filters['order_by'])) {
            // if both $star and $end are set, then return occupancies within range
            if ($filters['order_by'] != "") {
                $order_by = "ORDER BY ".$filters['order_by'];
            }
            else
            {
                $order_by = "ORDER BY bl.date_time";
            }
        }

        // set order
        $order = "";
        if (isset($filters['order'])) {
            if ($filters['order'] != "") {
                if ($filters['order'] == 'DESC') {
                    $order = "DESC";
                }
                if ($filters['order'] == 'ASC') {
                    $order = "ASC";
                }
            }
            else
            {
                $order = "DESC";
            }
        }
        
        $sql = "SELECT 
                    b.booking_id,
                    b.state,
                    c.customer_name,
                    r.room_id,
                    r.room_name,
                    rt.name as room_type_name,
                    brh.check_in_date, 
                    brh.check_out_date, 
                    cm.name as company_name                    
                FROM 
                    `booking` b             
                LEFT JOIN customer c 
                    ON c.customer_id = b.booking_customer_id                
                LEFT JOIN booking_block as brh 
                    ON brh.booking_id = b.booking_id
                LEFT JOIN room as r
                    ON brh.room_id = r.room_id
                LEFT JOIN room_type as rt
                    ON rt.id = r.room_type_id
                LEFT JOIN booking_log bl 
                    ON bl.booking_id = b.booking_id
                LEFT JOIN company as cm 
                    ON cm.company_id = b.company_id
                LEFT JOIN booking_staying_customer_list as bscl ON bscl.booking_id = b.booking_id
                LEFT JOIN customer as sg ON bscl.customer_id = sg.customer_id
                WHERE
                b.company_id = '$company_id' AND
                b.is_deleted != 1
                AND '".$filters['date']."' >= Date(brh.check_in_date) AND '".$filters['date']."' <= Date(brh.check_out_date)
                GROUP BY b.booking_id
                $order_by $order";
        
        $q = $this->db->query($sql);
        
        if ($this->db->_error_message())
        {
            show_error($this->db->_error_message());
        }

        $result = $q->result_array();
        
        return $result;
    }
}
