<?php 

class Setting extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();
        
        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Invoice_booking_model');
        $this->load->model('Payment_model');
        $this->load->model('Invoice_log_model');
        $view_data['menu_on'] = true;
        $this->load->vars($view_data);
        
    }

    function check_booking_existency()
    {
        $booking_id = $this->input->post('booking_id');           
        $company_id = $this->company_id;           

        $booking_data = $this->Invoice_booking_model->get_booking($booking_id, $company_id);
        
        if(empty($booking_data)){
            echo json_encode(array('success' => false, 'error' => 'The booking does not exist.'));
        } else {
            echo json_encode(array('success' => true, 'amount' => $booking_data['balance']));
        }
    }

    function add_invoice_transfer_payment(){
        $data = Array(
            "user_id" => $this->session->userdata('user_id'),
            "booking_id" => $this->input->post('booking_id'),
            "selling_date" => date('Y-m-d', strtotime($this->input->post('payment_date'))),
            "amount" => $this->input->post('payment_amount'),
            "customer_id" => $this->input->post('customer_id'),
            "payment_type_id" => $this->input->post('payment_type_id'),
            "description" => $this->input->post('description'),
            "date_time" => gmdate("Y-m-d H:i:s"),
            "selected_gateway" => $this->input->post('selected_gateway')
        );

        // prx($data);

        $payment_folio_id = $this->input->post('folio_id');
        $payment_folio_id = $payment_folio_id ? $payment_folio_id : 0;
        // $card_data = $this->Card_model->get_active_card($data['customer_id'], $this->company_id);
        // $data['credit_card_id'] = null;
        // if (isset($card_data) && $card_data) {
        //     $data['credit_card_id'] = $card_data['id'];
        // }

        $payment_type_id               = &$data['payment_type_id'];
        $use_gateway                   = ($payment_type_id == 'gateway');

        $response = $this->Payment_model->insert_payment($data);

        // prx($response);

        $payment_data = array();
        $payment_id = '';

        if(
            $response && 
            isset($response['success']) &&
            isset($response['payment_id']) &&
            $response['payment_id']
        ) {
            $payment_id = $response['payment_id'];
            $payment_data = $this->Payment_model->get_payment($payment_id);
            // prx($payment_data);
        }

        if($payment_data){
            $update_data = array('logs' => $this->input->post('paid_by_booking_id'));
            $this->Payment_model->update_payment($payment_id, $update_data);
        }

        $invoice_log_data = array();
        $invoice_log_data['date_time'] = gmdate('Y-m-d h:i:s');
        $invoice_log_data['booking_id'] = $this->input->post('booking_id');
        $invoice_log_data['user_id'] = $this->session->userdata('user_id');
        $invoice_log_data['action_id'] = CAPTURED_PAYMENT;
        $invoice_log_data['charge_or_payment_id'] = $payment_id;
        $invoice_log_data['new_amount'] = $this->input->post('payment_amount');
        if ($payment_id && $invoice_log_data['charge_or_payment_id']) {
            $this->Payment_model->insert_payment_folio(array('payment_id' => $payment_id, 'folio_id' => $payment_folio_id));
            $invoice_log_data['log'] = 'Payment Captured';
            $this->Invoice_log_model->insert_log($invoice_log_data);
        }
        else {
            $invoice_log_data['charge_or_payment_id'] = 0;
            $invoice_log_data['log'] = isset($error) && $error ? $error : '';
            $this->Invoice_log_model->insert_log($invoice_log_data);
        }

        $this->Booking_model->update_booking_balance($data['booking_id']);

        // show error
        if (!empty($error)) {
            $response = array("success" => false, "message" => $error);
        } else {
            $response = array("success" => true, "payment_id" => $payment_id);
        }

        echo json_encode($response);
    }

    function get_invoice_payments($booking_id){
        $payment_data = $this->Invoice_booking_model->get_booking_by_logs($booking_id);

        echo json_encode(array('invoice_pay_data' => $payment_data));
    }
}