<?php 

class Housekeeper_report extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();
    
        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Room_model');
        $this->load->model('User_model');               

        $global_data['menu_on'] = true;

        $this->load->vars($global_data);
    }
    
    /**
     * Shows housekeeping report
     */
    function show_housekeeper_report($flag = null, $show_guests = 1, $start_date = null, $end_date = null)
    {
        $data['flag'] = $flag;   
        $data['show_guests'] = $show_guests;   
        //get user's shift information
        $data['current_selling_date'] = $this->selling_date;
        $display_all_rooms = ($flag == 1);
        
        $data['rooms'] = $this->Room_model->get_housekeeping_report($this->company_id, $this->selling_date, $display_all_rooms, $start_date, $end_date, $this->selling_date);
        if($display_all_rooms == 0){
            $i = 0;
        $rooms = array();
        foreach($data['rooms'] as $value){
            if($value->occupied != "<b>Empty</b>"){
                $rooms[] = $data['rooms'][$i];
            }$i++;
        }
        $data['rooms'] = $rooms;    
        }
        if (isset($data['rooms'][0])) {
            $rows = array_keys(get_object_vars($data['rooms'][0]));
        
            foreach ($rows as $row) {
                try {
                    new DateTime($row);
                    $data['date_headers'][] = $row;

                } catch (Exception $e) {
                    continue;
                }
            }
        }
        
        $data['start_date'] = $start_date;
        $data['end_date'] = $end_date;
        $data['housekeeper_list'] = $this->User_model->get_company_mambers($this->company_id,'is_housekeeping');
        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        $data['selected_submenu'] = 'Room';
        $data['selected_sidebar_link'] = 'Housekeeping';
        $data['main_content'] = '../extensions/'.$this->module_name.'/views/housekeeping_mg';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);

    }

    function show_room_report_hmg()
    {
        //get user's shift information

        $data['current_selling_date'] = $this->selling_date;
        $data['rows']                 = $this->Room_model->get_room_report($this->company_id);

        $data['selected_submenu'] = 'Room';
        $data['selected_sidebar_link'] = 'Room Notes';
        
        $data['main_content'] = '../extensions/'.$this->module_name.'/views/room_notes_mg';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);

    }
    
    function download_housekeeper_csv_export($flag = null, $show_guests = 1, $start_date = null, $end_date = null)
    {        
        $this->load->helper('download');
        $bookings = array();
        $booking_row  = array();
        $data['flag'] = $flag;  
        $data['show_guests'] = $show_guests;   
        //get user's shift information
        $data['current_selling_date'] = $this->selling_date;
        $display_all_rooms = ($flag == 1);
        $data['rooms'] = $this->Room_model->get_housekeeping_report($this->company_id, $this->selling_date, $display_all_rooms, $start_date, $end_date, $this->selling_date);
        $housekeeper_list = $this->User_model->get_company_mambers($this->company_id,'is_housekeeping');
        if($display_all_rooms == 0){
            $i = 0;
        $rooms = array();
        foreach($data['rooms'] as $value){
            if($value->occupied != "<b>Empty</b>"){
                $rooms[] = $data['rooms'][$i];
            }$i++;
        }
        //prx($rooms,1);
        $data['rooms'] = $rooms;    
        }
        if (isset($data['rooms'][0])) {
            $rows = array_keys(get_object_vars($data['rooms'][0]));

            foreach ($rows as $row) {
                try {
                    new DateTime($row);
                    $data['date_headers'][] = $row;

                } catch (Exception $e) {
                    continue;
                }
            }
        }
        
         $day = "";
        // foreach ($data['rooms'] as $room) {
        //     $groups[$room->group_id][] = $room;
        // }
             $room_name =  ($this->session->userdata('property_type') == 0)? 'room' : 'bed';
            if (isset($data['date_headers'])) {
                foreach ($data['date_headers'] as $header) {

                    if ($data['current_selling_date'] == $header) {
                        $day = ($data['current_selling_date'] == $header) ? "today" : "not-today";
                        
                        $day .= ' ('.$header.')';                              
                    }                             
                }
           }
        $csv_keys = array($room_name, 'status', 'occupied', 'Housekeeper Name', $day, 'check_in_date', 'check_out_date', 'housekeeping_notes' );
        
        $bookings[] = $csv_keys;
        $group_name = "";
        foreach ($data['rooms'] as $room){
            $booking_row  = array();
            $booking_row[] = $room->room_name;
            $booking_row[] = $room->status;
            if($show_guests == '0')
            {                                    
                $ocucu = ($room->occupied == '<b>Empty</b>') ? 'Empty' : 'Occupied';
            }
            else
            {
                $ocucu = $room->occupied;
            }   
            $booking_row[] = strip_tags($ocucu);

            foreach ($housekeeper_list as $housekeeper){ 

                if ($room->group_id == $housekeeper['id']){ 
                       
                $group_name = $housekeeper['first_name']." ".$housekeeper['last_name'];
                    
                }
            }

            $booking_row[] = $group_name;

            if (isset($data['date_headers'])) {
                foreach ($data['date_headers'] as $header) {

                    if ($data['current_selling_date'] == $header) {
                        if($room->$header == 'Stay'){
                              $day1 =   l('Stay', true);
                            } elseif($room->$header == 'Change Sheets'){
                               $day1 =  l('Change Sheets', true);
                            } elseif($room->$header == 'Checkout'){
                                $day1 = l('Checkout', true);
                            } else {
                               $day1 =  $room->$header;
                            } 
                        $booking_row[] = $day1 ;

                    } 
                }
            }
            $booking_row[]  =   ($room->booking_state == CHECKOUT || $room->booking_state == INHOUSE) ? $room->check_in_date : '';
            $booking_row[]  =   ($room->booking_state == CHECKOUT || $room->booking_state == INHOUSE) ? $room->check_out_date : '';
            $booking_row[]  =   ($room->booking_state == CHECKOUT || $room->booking_state == INHOUSE) ? $room->housekeeping_notes : '';

            $bookings[] = $booking_row;
        }
        
        force_download_csv($bookings, "house_keeping.csv");
    }
    
    function download_room_report_csv_export_hmg()
    {        
        $this->load->helper('download');
        $bookings = array();
        $booking_row = array();
        $data['rows'] = $this->Room_model->get_room_report($this->company_id);
      
        $csv_keys = array('Rooms', 'Room Notes');
        $bookings[] = $csv_keys;
      
        foreach ($data['rows'] as $column_key => $value)
        {   
            
            $booking_row = $value;
            $bookings[] = $booking_row;
        }
       force_download_csv($bookings, "room_note.csv");
    }

}