<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.4.1/dist/css/bootstrap.min.css">

<style>
    .registration-container {
        max-width: 800px;
        margin: 30px auto;
        padding: 20px;
        background: #fff;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    .header {
        text-align: center;
        margin-bottom: 30px;
    }
    .header h2 {
        font-weight: 600;
        margin-bottom: 5px;
    }
    .header small {
        color: #666;
    }
    .info-box {
        padding: 15px;
        background: #f9f9f9;
        border-radius: 6px;
        margin-bottom: 20px;
    }
    .signature-area {
        margin-top: 20px;
    }
    #signature-pad {
        width: 100%;
        height: 150px;
        border: 2px dashed #ccc;
        border-radius: 6px;
        background: #fff;
        cursor: crosshair;
    }
    .btn-action {
        margin-top: 10px;
    }
</style>

<div class="registration-container">
    <div class="header">
        <h2><?= $booking['company_name'] ?> Registration Card</h2>
        <h4>Confirmation Number: <?= $booking['booking_id'] ?></h4>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <div class="info-box">
                <strong>Customer Information</strong><br>
                <!-- <?= $booking['booking_customer_name'] ?><br> -->
                <!-- <?= $booking['booking_customer_email'] ?><br> -->

                <?= htmlspecialchars($booking['booking_customer_name']); ?><br>
                <?= htmlspecialchars($booking['booking_customer_phone']); ?><br>
                <?= htmlspecialchars($booking['booking_customer_address']); ?><br>
                <?= htmlspecialchars($booking['booking_customer_email']); ?><br>

                
            </div>
        </div>

        <div class="col-sm-6">
            <div class="info-box">
                <strong>Booking Information</strong><br>
                Room: <?= $booking['room_name'] ?><br>
                Room Type: <?= $booking['room_type_name'] ?><br>
                Check-in: <?= $booking['check_in_date'] ?><br>
                Check-out: <?= $booking['check_out_date'] ?><br>
                Adults: <?= $booking['adult_count'] ?><br>
                Children: <?= $booking['children_count'] ?><br>
            </div>
        </div>
    </div>

    <div>
    	<?php echo $check_in_policies; ?>
    </div>

    <div class="signature-area">
        <label><strong>Signature:</strong></label>
        <canvas id="signature-pad"></canvas>

        <label><strong>Date:</strong></label>
        <input type="date" name="signature_date" id="signature-date" style='max-width: 250px; margin-top: 15px;'>

        <div class="btn-action">
            <button id="clear" class="btn btn-warning btn-sm">Clear</button>
            <button id="submit-signature" class="btn btn-success btn-sm">Submit</button>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
<script>
const canvas = document.getElementById('signature-pad');
const signaturePad = new SignaturePad(canvas);

// Optional: also resize on window change
window.addEventListener('resize', () => {
    resizeCanvas();
    signaturePad.clear(); // or restore if you want
});


function resizeCanvas() {
    const ratio = window.devicePixelRatio || 1;
    const rect = canvas.getBoundingClientRect();

    canvas.width = rect.width * ratio;
    canvas.height = rect.height * ratio;
    canvas.style.width = rect.width + 'px';
    canvas.style.height = rect.height + 'px';

    const ctx = canvas.getContext("2d");
    ctx.setTransform(1, 0, 0, 1, 0, 0); // reset transform
    ctx.scale(ratio, ratio);
}

// 👇 Add this to fix offset drawing
requestAnimationFrame(() => {
    resizeCanvas();
    signaturePad.clear();
});

window.addEventListener('resize', () => {
    resizeCanvas();
    signaturePad.clear();
});

document.getElementById('signature-date').value = new Date().toISOString().split('T')[0];


document.getElementById('clear').addEventListener('click', () => signaturePad.clear());


document.getElementById('submit-signature').addEventListener('click', () => {
    if (signaturePad.isEmpty()) {
        alert("Please sign before submitting.");
        return;
    }

    const signatureData = signaturePad.toDataURL("image/png");

    const formData = new URLSearchParams();
    formData.append("booking_id", "<?= $booking['booking_id'] ?>");
    formData.append("company_id", "<?= $booking['company_id'] ?>");
    formData.append("signature_data", signatureData);

    fetch("<?= base_url() . 'public/save_guest_signature' ?>", {
        method: "POST",
        headers: {
             "Content-Type": "application/json"
        },
        body: JSON.stringify({
	        booking_id: "<?= $booking['booking_id'] ?>",
	        company_id: "<?= $booking['company_id'] ?>",
	        signature_data: signatureData,
            signature_date: document.getElementById('signature-date').value,
            signed_via: "email"
	    })
    })
    .then(res => res.json())
    .then(res => {
        if (res.status === 'success') {
            alert('Signature submitted!');
    		window.location.href = "<?= base_url() . 'public/thank_you?booking_id=' ?>" + <?= $booking['booking_id'] ?>;

        } else {
            alert(res.message);
        }
    });
});

</script>