<?php
class Report extends MY_Controller
{
    public $module_name;
    public function __construct()
    {

        parent::__construct();
        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Gross_net_report_model');

        $this->load->library('session');
        $view_data['menu_on'] = true;
        $this->load->vars($view_data);
    }

    /*
     * Get all reservation reports to view
     * */
    public function show_gross_net_report($date = null)
    {   
        
        //get user's shift information
        $date = (isset($date)) ? $date : $this->selling_date;
        
        $data['date'] = $date;
        $data['hotel_name'] = $this->company_name;

        $filters = array(
            'date' => $date,
            'order_by' => $this->session->userdata('reservation_order_by'),
            'order' => $this->session->userdata('reservation_order'),
        );

        $filters['include_customer_type'] = true;
        $filters['include_booking_fields'] = true;

        $company_id = $this->session->userdata('current_company_id');
        $data['company_details'] = $this->Company_model->get_company($company_id);

        $data['bookings'] = $this->Gross_net_report_model->get_bookings_for_report($filters, 0, null);



        foreach ($data['bookings'] as $key => $booking) {
            
            // start for get the sub total, tax total and grand total charges

            $booking_id = $booking['booking_id'];
            if(
                $booking['rate'] != 0 || 
                $booking['balance'] != 0 || 
                $booking['balance_without_forecast'] != 0
            ) {

                $charges  = $this->Charge_model->get_charges($booking_id);

                if(strtotime($this->selling_date) <= strtotime(date("Y-m-d", strtotime($booking['check_out_date'])))) {

                    // and invoice currently viewing transactions for 'booking customer'
                    if(!$data['company_details']['hide_forecast_charges'])
                    {
                        $charges = array_merge($charges, $this->forecast_charges->_get_forecast_charges($booking_id, false));
                        $charges = array_merge($charges, $this->forecast_charges->_get_forecast_extra_charges($booking_id, false));
                        if(isset($data['folios'][0])) {
                            $data['folios'][0]['charge_count'] = count($charges);
                        }
                    }
                }

                // assign taxes to charges
                $taxes_cache = array();
                foreach ($charges as $index => $charge) {
                    if (isset($taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']])) {
                        $charges[$index]['taxes'] = $taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']];
                    } else {
                        $charges[$index]['taxes'] = $this->Charge_type_model->get_taxes($charge['charge_type_id'], $charge['amount']);
                        $taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']] = $charges[$index]['taxes'];
                    }
                }
                $taxes_cache = array(); // release memory

            }
            
            // $data['charges']  = $charges;
            $payments = $this->Gross_net_report_model->get_payments($booking_id);
            if($payments){
                $total_amount = 0;
                foreach($payments as $index => $payment){
                    $payments[$index]['remaining_amount'] = '';
                    if($payment['payment_status'] == 'charge' ||$payment['payment_status'] == NULL ){
                        $total_amount = $payment['amount'];
                        $charge_id = $payment['gateway_charge_id'];
                        $partial_payments = isset($charge_id) ? $this->Gross_net_report_model->get_partial_refunds_by_charge_id($charge_id) : null;

                        $total_partial_amount = 0;
                        if(!empty($partial_payments)){
                            foreach($partial_payments as $partial_payment){
                                $total_partial_amount += $partial_payment['amount'];
                            }
                            $payments[$index]['remaining_amount'] = $total_amount + $total_partial_amount;
                        }
                    }
                }
            }

            $data['bookings'][$key]['payments'] = $payments;

            $charge_sub_total = $charge_tax_total = $charge_final_total = 0;

            if (isset($charges)):
                foreach($charges as $charge):
                    $rate = (float)$charge['amount'];
                    // $charge_sub_total += (float)$charge['amount'];

                    $combined_tax = 0;

                    if (isset($charge['taxes'])) {
                        foreach ($charge['taxes'] as $tax) {
                            if ($tax['is_percentage'] == 1)
                            {
                                if($tax['is_tax_inclusive'] == 1)
                                {
                                    $tax_amount = (float)$charge['amount'] - ($rate / (1 + ((float)$tax['tax_rate'] * 0.01)));
                                    $combined_tax = $combined_tax;
                                }
                                else
                                {
                                    $tax_amount = (float)$tax['tax_rate'] * $rate * 0.01;
                                    $combined_tax = $combined_tax + $tax_amount;
                                }
                            }
                            else
                            {
                                $tax_amount = (float)$tax['tax_rate'];
                                $combined_tax = $combined_tax + $tax_amount;
                            }

                            $charge_tax_total += number_format($tax_amount, 2, ".", ",");
                        }
                    }

                    $rate         = (float) str_replace(',', '', $rate);
                    $combined_tax = (float) str_replace(',', '', $combined_tax);

                    $charge_final_total += $rate + $combined_tax;

                endforeach;
            endif;

            $data['bookings'][$key]['charge_sub_total'] = number_format($charge_final_total - $charge_tax_total, 2, ".", ",");
            $data['bookings'][$key]['charge_tax_total'] = number_format($charge_tax_total, 2, ".", ",");
            $data['bookings'][$key]['charge_final_total'] = number_format($charge_final_total, 2, ".", ",");

            // end for get the sub total, tax total and grand total charges
        }

        $data['js_files'] = array(
            base_url() . 'js/moment.min.js',
        );
        
        $data['main_content'] = '../extensions/' . $this->module_name . '/views/gross_net_report';

        $this->template->load('bootstrapped_template', null, $data['main_content'], $data);

    }

    public function download_gross_net_csv_export($date = null)
    {
        $date = (isset($date)) ? $date : $this->selling_date;
        
        $data['date'] = $date;

        $this->load->helper('download');

       $filters = array(
            'date' => $date,
            'order_by' => $this->session->userdata('reservation_order_by'),
            'order' => $this->session->userdata('reservation_order'),
        );

        $filters['include_customer_type'] = true;
        $filters['include_booking_fields'] = true;

        $company_id = $this->session->userdata('current_company_id');
        $data['company_details'] = $this->Company_model->get_company($company_id);

        $data['bookings'] = $this->Gross_net_report_model->get_bookings_for_report($filters, 0, null);
        
        // PREPARE KEY FOR THE CSV

        $reservation_settings = "booking_id,customer_name,charge_sub_total,charge_tax_total,charge_final_total";
        
        $settings = explode(',', $reservation_settings);
        $csv_keys = [];

        $csv_lookup_keys = array(
            "booking_id" => "Reservation Id",
            "customer_name" => "Guest Name",
            "charge_sub_total" => "Charge Sub Total",
            "charge_tax_total" => "Charge Tax Total",
            "charge_final_total" => "Grand Total"
        );

        foreach($csv_lookup_keys as $key => $value) {
           if(in_array($key,$settings)){
               $csv_keys[] = $value;
           }
        }

        $bookings = array($csv_keys);

        foreach ($data['bookings'] as $key => $booking) {



            // start for get the sub total, tax total and grand total charges

            $booking_id = $booking['booking_id'];
            if(
                $booking['rate'] != 0 || 
                $booking['balance'] != 0 || 
                $booking['balance_without_forecast'] != 0
            ) {

                $charges  = $this->Charge_model->get_charges($booking_id);

                if(strtotime($this->selling_date) <= strtotime(date("Y-m-d", strtotime($booking['check_out_date'])))) {

                    // and invoice currently viewing transactions for 'booking customer'
                    if(!$data['company_details']['hide_forecast_charges'])
                    {
                        $charges = array_merge($charges, $this->forecast_charges->_get_forecast_charges($booking_id, false));
                        $charges = array_merge($charges, $this->forecast_charges->_get_forecast_extra_charges($booking_id, false));
                        if(isset($data['folios'][0])) {
                            $data['folios'][0]['charge_count'] = count($charges);
                        }
                    }
                }

                // assign taxes to charges
                $taxes_cache = array();
                foreach ($charges as $index => $charge) {
                    if (isset($taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']])) {
                        $charges[$index]['taxes'] = $taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']];
                    } else {
                        $charges[$index]['taxes'] = $this->Charge_type_model->get_taxes($charge['charge_type_id'], $charge['amount']);
                        $taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']] = $charges[$index]['taxes'];
                    }
                }
                $taxes_cache = array(); // release memory

            }
            
            // $data['charges']  = $charges;
            $payments = $this->Gross_net_report_model->get_payments($booking_id);
            if($payments){
                $total_amount = 0;
                foreach($payments as $index => $payment){
                    $payments[$index]['remaining_amount'] = '';
                    if($payment['payment_status'] == 'charge' ||$payment['payment_status'] == NULL ){
                        $total_amount = $payment['amount'];
                        $charge_id = $payment['gateway_charge_id'];
                        $partial_payments = isset($charge_id) ? $this->Gross_net_report_model->get_partial_refunds_by_charge_id($charge_id) : null;

                        $total_partial_amount = 0;
                        if(!empty($partial_payments)){
                            foreach($partial_payments as $partial_payment){
                                $total_partial_amount += $partial_payment['amount'];
                            }
                            $payments[$index]['remaining_amount'] = $total_amount + $total_partial_amount;
                        }
                    }
                }
            }

            $data['bookings'][$key]['payments'] = $payments;

            $charge_sub_total = $charge_tax_total = $charge_final_total = $charge_s_total = $charge_t_total = $charge_f_total = 0;

            if (isset($charges)):
                foreach($charges as $charge):
                    $rate = (float)$charge['amount'];
                    // $charge_sub_total += (float)$charge['amount'];

                    $combined_tax = 0;

                    if (isset($charge['taxes'])) {
                        foreach ($charge['taxes'] as $tax) {
                            if ($tax['is_percentage'] == 1)
                            {
                                if($tax['is_tax_inclusive'] == 1)
                                {
                                    $tax_amount = (float)$charge['amount'] - ($rate / (1 + ((float)$tax['tax_rate'] * 0.01)));
                                    $combined_tax = $combined_tax;
                                }
                                else
                                {
                                    $tax_amount = (float)$tax['tax_rate'] * $rate * 0.01;
                                    $combined_tax = $combined_tax + $tax_amount;
                                }
                            }
                            else
                            {
                                $tax_amount = (float)$tax['tax_rate'];
                                $combined_tax = $combined_tax + $tax_amount;
                            }

                            $charge_tax_total += number_format($tax_amount, 2, ".", ",");
                        }
                    }

                    $rate         = (float) str_replace(',', '', $rate);
                    $combined_tax = (float) str_replace(',', '', $combined_tax);

                    $charge_final_total += $rate + $combined_tax;

                endforeach;
            endif;

            $charge_s_total += $charge_final_total - $charge_tax_total;
            $charge_t_total += $charge_tax_total;
            $charge_f_total += $charge_final_total;

            // end for get the sub total, tax total and grand total charges




            $booking_row = [];
            
            if (in_array('booking_id', $settings)) {
                $booking_row[] = $booking['booking_id'];
            }
            if (in_array('customer_name', $settings)) {
                $booking_row[] = $booking['customer_name'];
            }
            if (in_array('charge_sub_total', $settings)) {
                $booking_row[] = $charge_s_total;
            }
            if (in_array('charge_tax_total', $settings)) {
                $booking_row[] = $charge_t_total;
            }
            if (in_array('charge_final_total', $settings)) {
                $booking_row[] = $charge_f_total;
            }

            $bookings[] = $booking_row;
        }

        force_download_csv($bookings, "gross_net_report.csv");
    }

}
