<?php 

class Report extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();
    
        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Report_model');
      

        $global_data['menu_on'] = true;
        $global_data['selected_menu'] = 'reports';      
        $global_data['submenu'] = 'reports/reports_submenu.php';
        $global_data['submenu_parent_url'] = base_url()."reports/";
        $global_data['sidebar_menu_url'] = base_url()."reports/market_segment/";
        $global_data['menu_items'] = $this->Menu_model->get_menus(array('parent_id' => 4, 'wp_id' => 1));
        $global_data['selected_submenu'] = 'Market Segment';
        $global_data['sidebar_links'] = $this->Menu_model->get_menus(array('parent_id' => 10, 'wp_id' => 1));

        $this->load->vars($global_data);
        
    }

   
    function show_geographical_report($start_date = '', $end_date = '')
    {
        if ($start_date == '') {
            $parts      = explode('-', $this->selling_date);
            $year       = $parts[0];
            $month      = $parts[1];
            $start_date = "$year-$month-01";
        }

        if ($end_date == '') {
            $end_date = date('Y-m-d', strtotime($start_date."+1 month"));
        }

        $data['start_date'] = $start_date;
        $data['end_date']   = $end_date;

        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        $data['selected_sidebar_link'] = 'Geographical';

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/geographical';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

    function get_geographical_data_AJAX() 
    {
        $start_date = $this->input->post('dateStart');
        $end_date   = $this->input->post('dateEnd');
        
        $data = $this->Report_model->get_geographical_data(
                                                            $this->company_id, 
                                                            $start_date, 
                                                            $end_date
                                                        );

        echo json_encode($data); 
    }

    function download_market_geographical_csv_export($start_date = NULL, $end_date = NULL, $group_by = null)
    {        
        $this->load->helper('download');
        $data = $this->Report_model->get_geographical_data(
                                                            $this->company_id, 
                                                            $start_date, 
                                                            $end_date
                                                        );
        
        $csv_keys = array('Customer Type', 'Room Nights');
        $bookings[] = $csv_keys;
        $totalValue = 0;
        foreach ($data as $column_key => $value)
        {
            if ($value['label'] != 'Unknown')
            {
                $totalValue += $value['value'];
            }
        }
        $sources = json_decode(COMMON_BOOKING_SOURCES); 
        foreach ($data as $column_key => $value)
        {   
            
            $value['label'] = (is_numeric($value['label'])) ? $sources->$value['label'] : $value['label'];
            $value['total'] = ($value['label'] != 'Unknown') ? number_format($value['value']/$totalValue * 100, 2, ".", ","). " %":'';
            $booking_row = $value;
            $bookings[] = $booking_row;
        }
        
       force_download_csv($bookings, "market_geographical.csv");
    }

}