<?php 

class Report extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();

        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Charge_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Room_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Room_type_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Payment_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Booking_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Currency_model');
    
        $global_data['menu_on'] = true;
        $global_data['selected_menu'] = 'reports';      
        $global_data['submenu'] = 'reports/reports_submenu.php';
        $global_data['submenu_parent_url'] = base_url()."reports/";
        $global_data['sidebar_menu_url'] = base_url()."reports/ledger/";
        //$global_data['menu_items'] = $this->Menu_model->get_menus(array('parent_id' => 4, 'wp_id' => 1));
        //$global_data['sidebar_links'] = $this->Menu_model->get_menus(array('parent_id' => 9, 'wp_id' => 1));

        $this->load->vars($global_data);
        
    }

    function show_sales_summary_report($start_date = NULL, $end_date = NULL, $report_type = 'room', $room_type = '')
    {
        $start_date = $start_date ? $start_date : date('Y-m-d', strtotime("-1 month +1 day"));
        $end_date = $end_date ? $end_date : date('Y-m-d');
        $startdate = new DateTime($start_date);
        $enddate = new DateTime($end_date);
        $date_difference = $startdate->diff($enddate)->format('%d') + 1; // inclusive end date

        
        $data['start_date']  = $start_date;
        $data['end_date']    = $end_date;
        $data['report_type'] = $report_type;
        $data['rm_type']     = $room_type;

        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        if($report_type!='room' && $room_type!=''){
            $sort_by = 'room_name';
            $where = "AND rt.id = $room_type";
        }
        else{
            $sort_by = 'room_name';
            $where = '';
        }
        $rooms = $this->Room_model->get_rooms($this->company_id,$sort_by,$where);
        //$rooms = $this->Room_model->get_rooms($this->company_id);
        $type = $report_type == "room" ? 'room_wise' : 'roomtype_wise';
        $booking_count   = $this->Booking_model->get_booking_count($start_date, $end_date, $type);        
        $charge_total    = $this->Charge_model->get_total_charges($start_date, $end_date, $this->selling_date, false, false, $type, true);
        
        $payment_total    = $this->Payment_model->get_total_payments($start_date, $end_date, $this->selling_date, $type);
        $charge_total_with_taxes = $this->Charge_model->get_total_charges($start_date, $end_date, $this->selling_date, false, true, $type, true);
        $room_charge_total = $this->Charge_model->get_total_charges($start_date, $end_date, $this->selling_date, true, false, $type, true);
        $number_of_rooms = count($rooms);
        $accumulated_occupancy_rate = 0;  
        $daily_data = array();
        // prx($payment_total);
        foreach ($rooms as $room)       
        {
            $id = ($report_type == "room") ? $room['room_id'] : $room['room_type_id'];
            $bc = isset($booking_count['booking_count'][$id]) ? $booking_count['booking_count'][$id] : 0;
            $cb = isset($booking_count['cancelled_booking_per'][$id]) ? $booking_count['cancelled_booking_per'][$id] : 0;
            $tn = isset($booking_count['total_nights'][$id]) ? $booking_count['total_nights'][$id] : 0;
            $ct = isset($charge_total[$id]) ? $charge_total[$id] : 0;
            $ct_with_tax = isset($charge_total_with_taxes[$id]) ? $charge_total_with_taxes[$id] : 0;
            $rct = isset($room_charge_total[$id]) ? $room_charge_total[$id] : 0;
            // $or = $bc / $number_of_rooms;
            $or = $tn / $date_difference * 100;
            $rp = $rct / $number_of_rooms;
            $adr = ($tn > 0)?($rct / $tn):0;
            $as = intval($tn / ($bc > 0 ? $bc : 1));
            $pt = isset($payment_total[$id]) ? $payment_total[$id] : 0;

            $daily_data[$id] = Array(
                "booking_count"     => $bc,
                "cancelled_booking_per" => $cb,
                "occupancy_rate"    => $or,
                "revPAR"            => $rp,
                "ADR"               => $adr,
                "room_charge_total" => $rct,
                "charge_total"      => $ct,
                "charge_total_with_tax" => $ct_with_tax,
                "room_name"         => ($report_type == "room") ? $room['room_name'] : $room['room_type_name'].'('.$room['acronym'].')',
                "room_type_name"    => ($report_type == "room") ? $room['room_type_name'] : $room['room_type_description'],
                "total_nights"      => $tn,
                "avg_stay"          => $as,
                "payment_total"     => $pt
            );
            $accumulated_occupancy_rate += $or;
        }
        $data['room_types'] = $this->Room_type_model->get_room_types($this->company_id);
        $data['daily_data'] = $daily_data;
        $data['number_of_rooms'] = $number_of_rooms;
        $data['selected_submenu'] = 'Ledger';
        $data['selected_sidebar_link'] = 'Sales';
        $data['hotel_name'] = $this->company_name;        

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/sales_summary_report';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

    function download_sales_csv_export($start_date = NULL, $end_date = NULL, $report_type = 'room', $room_type = '')
    {        
        $this->load->helper('download');
        $start_date = $start_date ? $start_date : date('Y-m-d', strtotime("-1 month +1 day"));
        $end_date = $end_date ? $end_date : date('Y-m-d');

        $startdate = new DateTime($start_date);
        $enddate = new DateTime($end_date);
        $date_difference = $startdate->diff($enddate)->format('%d') + 1; // inclusive end date
        
        $data['start_date']  = $start_date;
        $data['end_date']    = $end_date;
        $data['report_type'] = $report_type;
        $data['rm_type']     = $room_type;

        if($report_type!='room' && $room_type!=''){
            $sort_by = 'room_name';
            $where = "AND rt.id = $room_type";
        }
        else{
            $sort_by = 'room_name';
            $where = '';
        }
        $rooms = $this->Room_model->get_rooms($this->company_id,$sort_by,$where);
        //$rooms = $this->Room_model->get_rooms($this->company_id);
        $type = $report_type == "room" ? 'room_wise' : 'roomtype_wise';
        $booking_count   = $this->Booking_model->get_booking_count($start_date, $end_date, $type);        
        $charge_total    = $this->Charge_model->get_total_charges($start_date, $end_date, $this->selling_date, false, false, $type);
        $payment_total    = $this->Payment_model->get_total_payments($start_date, $end_date, $this->selling_date, $type);
        $charge_total_with_taxes = $this->Charge_model->get_total_charges($start_date, $end_date, $this->selling_date, false, true, $type);
        $room_charge_total = $this->Charge_model->get_total_charges($start_date, $end_date, $this->selling_date, true, false, $type);
        $number_of_rooms = count($rooms);
        $accumulated_occupancy_rate = 0;  
        $daily_data = array();
        foreach ($rooms as $room)       
        {
            $id = ($report_type == "room") ? $room['room_id'] : $room['room_type_id'];
            $bc = isset($booking_count['booking_count'][$id]) ? $booking_count['booking_count'][$id] : 0;
            $cb = isset($booking_count['cancelled_booking_per'][$id]) ? $booking_count['cancelled_booking_per'][$id] : 0;
            $tn = isset($booking_count['total_nights'][$id]) ? $booking_count['total_nights'][$id] : 0;
            $ct = isset($charge_total[$id]) ? $charge_total[$id] : 0;
            $ct_with_tax = isset($charge_total_with_taxes[$id]) ? $charge_total_with_taxes[$id] : 0;
            $rct = isset($room_charge_total[$id]) ? $room_charge_total[$id] : 0;
            $or = $tn / $date_difference * 100;
            $rp = $rct / $number_of_rooms;
            $adr = ($tn > 0)?($rct / $tn):0;
            $as = intval($tn / ($bc > 0 ? $bc : 1));
            $pt = isset($payment_total[$id]) ? $payment_total[$id] : 0;

            $daily_data[$id] = Array(
                "booking_count"     => $bc,
                "cancelled_booking_per" => $cb,
                "occupancy_rate"    => $or,
                "revPAR"            => $rp,
                "ADR"               => $adr,
                "room_charge_total" => $rct,
                "charge_total"      => $ct,
                "charge_total_with_tax" => $ct_with_tax,
                "room_name"         => ($report_type == "room") ? $room['room_name'] : $room['room_type_name'].'('.$room['acronym'].')',
                "room_type_name"    => ($report_type == "room") ? $room['room_type_name'] : $room['room_type_description'],
                "total_nights"      => $tn,
                "avg_stay"          => $as,
                "payment_total"     => $pt
            );
            $accumulated_occupancy_rate += $or;
        }
        $data['room_types'] = $this->Room_type_model->get_room_types($this->company_id);
        $data['daily_data'] = $daily_data;
        
        $csv_keys1 = array(
                            'Room','',
                            'Bookings','','',
                            'Net Revenue','','','',
                            'Statistics','','',''
                           );
        $csv_keys2 = array(
                            'Name',
                            'Description',
                            'Res',
                            '%',
                            'Nights',
                            'Room',
                            'Other',
                            'Tax',
                            'Total(with taxes)',
                            'Payment',
                            'Balance',
                            'Cancel %',
                            'Avg Stay',
                            'ADR',
                            'Rev PAR'
                           );
        
        $bookings[] = $csv_keys1;
        $bookings[] = $csv_keys2;
        $total = array();
        $total['booking_count'] = $total['total_nights'] = $total['avg_stay'] = $total['occupancy_rate'] = $total['room_charge_total'] = $total['other_charge_total'] =  $total['tax_total'] = $total['charge_total_with_tax'] = $total['cancelled_booking_per'] = $total['ADR'] = $total['revPAR'] = $total['payment_total'] = $total['balance'] = 0;
        
        foreach($data['daily_data'] as $key => $data)
        {
            $booking_row = array();
            $booking_row[] = $data['room_name'];
            $booking_row[] = $data['room_type_name'];
            $booking_row[] = $data['booking_count'];
            $booking_row[] = number_format($data['occupancy_rate'], 2, ".", ",")."%";
            $booking_row[] = $data['total_nights'];
            $booking_row[] = number_format($data['room_charge_total'], 2, ".", ",");
            $booking_row[] = number_format($data['charge_total'] - $data['room_charge_total'], 2, ".", ",");
            $booking_row[] = number_format($data['charge_total_with_tax'] - $data['charge_total'], 2, ".", ",");
            $booking_row[] = number_format($data['charge_total_with_tax'], 2, ".", ",");
            $booking_row[] = number_format($data['payment_total'], 2, ".", ",");
            $booking_row[] = number_format($data['charge_total_with_tax'] - $data['payment_total'], 2, ".", ",");
            $booking_row[] = number_format($data['cancelled_booking_per'], 2, ".", ",")."%";
            $booking_row[] = $data['avg_stay'];
            $booking_row[] = number_format($data['ADR'], 2, ".", ",");
            $booking_row[] = number_format($data['revPAR'], 2, ".", ",");
            
            $total['booking_count'] += $data['booking_count'];
            $total['occupancy_rate'] += $data['occupancy_rate'];
            $total['total_nights'] += $data['total_nights'];
            $total['room_charge_total'] += $data['room_charge_total'];
            $total['other_charge_total'] += $data['charge_total'] - $data['room_charge_total'];
            $total['tax_total'] += $data['charge_total_with_tax'] - $data['charge_total'];
            $total['charge_total_with_tax'] += $data['charge_total_with_tax'];
            $total['payment_total'] += $data['payment_total'];
            $total['balance'] += ($data['charge_total_with_tax'] - $data['payment_total']);
            $total['cancelled_booking_per'] += $data['cancelled_booking_per'];
            $total['avg_stay'] += $data['avg_stay'];
            $total['ADR'] += $data['ADR'];
            $total['revPAR'] += $data['revPAR'];
            
            $bookings[] = $booking_row;
        }
        force_download_csv($bookings, "sales_repost.csv");
    }

    function advanced_deposits($start_date = NULL, $end_date = NULL, $depositType = '')
    {
        $start_date = $start_date ? $start_date : date('Y-m-d', strtotime("-1 month +1 day"));
        $end_date = $end_date ? $end_date : date('Y-m-d');
        
        $data['start_date']  = $start_date;
        $data['end_date']    = $end_date;
        $data['deposit_type'] = $depositType;
        
        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);
        
        $data['default_currency'] = $this->Currency_model->get_default_currency($this->company_id);
       
        $data['bookings'] = $this->Room_type_model->get_bookings($this->company_id, $start_date, $end_date, $depositType);        
        $data['selected_submenu'] = 'Ledger';
        $data['selected_sidebar_link'] = 'Advance Deposits';
        $data['hotel_name'] = $this->company_name;        
       
        $data['main_content'] = '../extensions/'.$this->module_name.'/views/advanced_deposits';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

    function download_advanced_deposit_csv_export($start_date = null, $end_date = null, $depositType = null)
    {        
        $this->load->helper('download');
        $start_date = $start_date ? $start_date : date('Y-m-d', strtotime("-1 month +1 day"));
        $end_date = $end_date ? $end_date : date('Y-m-d');
        
        $data['start_date']  = $start_date;
        $data['end_date']    = $end_date;
        $data['deposit_type'] = $depositType;
        
        $data['bookings'] = $this->Room_type_model->get_bookings($this->company_id, $start_date, $end_date, $depositType);        
        
        $csv_keys = array(
            "Reservation",
            "Customer",
            "Telphone",
            "Arrival",
            "Deposit",
            "Deposit Made",
            "Employee"
        );
        
        $bookings = array($csv_keys);
        foreach($data['bookings'] as $key => $booking){
            $amount = ($booking['amount']) ? $booking['amount'] : "0.00";
                    $deposit_date = ($booking['amount']) ? date('M d, Y', strtotime($booking['deposit_date'])) : '';            
            $booking_row = array();
            $booking_row[] = $booking['booking_id'] ? $booking['booking_id'] : "";
            $booking_row[] = $booking['customer_name'] ? $booking['customer_name'] : "";
            $booking_row[] = $booking['phone'] == 10 ? $booking['phone'] : "";;
            $booking_row[] = $booking['check_in_date'] ? date('M d, Y', strtotime($booking['check_in_date'])) : "";
            $booking_row[] = "$".$amount;
            $booking_row[] = $deposit_date;
            $booking_row[] = $booking['first_name']." ".$booking['last_name'];
           
            
            $bookings[] = $booking_row;
        }
        force_download_csv($bookings, "advance_deposit_report.csv");
    }

    function daily_account_summary($date_filter = ''){
        $selling_date = $this->selling_date;
        
        $data['accounting_charges_data'] = $data['accounting_payments_data'] = $data['accounting_taxes_data'] = array();
        
        if(!$date_filter) {
            $date_filter = "$selling_date--$selling_date";
        }
        $dates = explode('--', $date_filter);
        if(count($dates) > 1) {
            $start_date = $dates[0];
            $end_date = $dates[1];
            $month_start_date = date("Y-m-01", strtotime($dates[1]));
            $year_start_date = date("Y-01-01", strtotime($dates[1]));
            $data['accounting_charges_data']['date'] = $this->Charge_model->get_accounting_charges($start_date, $end_date, true);

            $data['accounting_charges_data']['month'] = $this->Charge_model->get_accounting_charges($month_start_date, $end_date, true);

            $data['accounting_charges_data']['year'] = $this->Charge_model->get_accounting_charges($year_start_date, $end_date, true);

            $data['accounting_payments_data']['date'] = $this->Payment_model->get_accounting_payments($start_date, $end_date);

            $data['accounting_payments_data']['month'] = $this->Payment_model->get_accounting_payments($month_start_date, $end_date);

            $data['accounting_payments_data']['year'] = $this->Payment_model->get_accounting_payments($year_start_date, $end_date);

            $data['accounting_taxes_data']['date'] = $this->Tax_model->get_accounting_taxes($start_date, $end_date, true);

            $data['accounting_taxes_data']['month'] = $this->Tax_model->get_accounting_taxes($month_start_date, $end_date, true);

            $data['accounting_taxes_data']['year'] = $this->Tax_model->get_accounting_taxes($year_start_date, $end_date, true);
            
            $data['start_date'] = $start_date;
            $data['end_date'] = $end_date;
            $data['selling_date'] = $selling_date;
        }

        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        $data['selected_submenu'] = 'Ledger'; //for css
        $data['selected_sidebar_link'] = 'Daily Account Summary';

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/daily_account_summary';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

    function download_daily_account_summary_csv_export($date_filter = null)
    {  
       header('Content-Type: text/csv; charset=utf-8');  
        $current_date_total_charges = 0;
        $current_month_total_charges = 0;
        $current_year_total_charges = 0;  
        $current_date_total = 0;
        $current_month_total = 0;
        $current_year_total = 0;    
        $this->load->helper('download');
        $this->load->Model('Room_model');
        $this->load->Model('Room_type_model');
        $dates = explode('--', $date_filter);
        $selling_date = $this->selling_date;
        if(count($dates) > 1) {
            $start_date = $dates[0];
            $end_date = $dates[1];
        }
        else
        {
            $start_date = $selling_date;
            $end_date = $selling_date;
        }
        $tdate= (end($this->uri->segments) != 'download_daily_account_summary_csv_export') ? ($start_date ." to ". $end_date) : date("Y-m-d", strtotime($end_date));
        $pdate=date("Y-m-01", strtotime($end_date));
        $ydate=date("Y-01-01", strtotime($end_date));           
       
        $csv_keys = array(
            "Name",
            "Today ".$tdate,
            "Period ".$pdate,
            "Year ".$ydate
        );
                    
        $data['accounting_charges_data'] = $data['accounting_payments_data'] = $data['accounting_taxes_data'] = array();        
        if(!$date_filter) {
            $date_filter = "$selling_date--$selling_date";
        }
        $dates = explode('--', $date_filter);
        if(count($dates) > 1) {
            $start_date = $dates[0];
            $end_date = $dates[1];
            $month_start_date = date("Y-m-01", strtotime($dates[1]));
            $year_start_date = date("Y-01-01", strtotime($dates[1]));
            $data['accounting_charges_data']['date'] = $this->Charge_model->get_accounting_charges($start_date, $end_date);

            $data['accounting_charges_data']['month'] = $this->Charge_model->get_accounting_charges($month_start_date, $end_date);

            $data['accounting_charges_data']['year'] = $this->Charge_model->get_accounting_charges($year_start_date, $end_date);

            $data['accounting_payments_data']['date'] = $this->Payment_model->get_accounting_payments($start_date, $end_date);

            $data['accounting_payments_data']['month'] = $this->Payment_model->get_accounting_payments($month_start_date, $end_date);

            $data['accounting_payments_data']['year'] = $this->Payment_model->get_accounting_payments($year_start_date, $end_date);

            $data['accounting_taxes_data']['date'] = $this->Tax_model->get_accounting_taxes($start_date, $end_date);

            $data['accounting_taxes_data']['month'] = $this->Tax_model->get_accounting_taxes($month_start_date, $end_date);

            $data['accounting_taxes_data']['year'] = $this->Tax_model->get_accounting_taxes($year_start_date, $end_date);         
            
            $data['selling_date'] = $selling_date;
        }      

        $booking_row = array();
        $bookings = array($csv_keys);        
      foreach($data['accounting_charges_data']['date'] as $name => $amount){
                if($name === "Selling Date") continue;
        $booking_row = array();                             
        $booking_row[] = $name; 
        $booking_row[] =number_format($data['accounting_charges_data']['date'][$name], 2, ".", ","); 
        $current_date_total_charges += $data['accounting_charges_data']['date'][$name];       
        $booking_row[] = number_format($data['accounting_charges_data']['month'][$name], 2, ".", ","); 
        $current_month_total_charges += $data['accounting_charges_data']['month'][$name];       
        $booking_row[] =  number_format($data['accounting_charges_data']['year'][$name], 2, ".", ","); 
        $current_year_total_charges += $data['accounting_charges_data']['year'][$name];
        $bookings[] = $booking_row;
               }  

        foreach($data['accounting_taxes_data']['date'] as $name => $amount){
                if($name === "Selling Date") continue;
        $booking_row = array();                             
        $booking_row[] = $name; 
        $booking_row[] =number_format($data['accounting_taxes_data']['date'][$name], 2, ".", ",");
        $current_date_total_charges += $data['accounting_taxes_data']['date'][$name];        
        $booking_row[] = number_format($data['accounting_taxes_data']['month'][$name], 2, ".", ",");
        $current_month_total_charges += $data['accounting_taxes_data']['month'][$name];        
        $booking_row[] =  number_format($data['accounting_taxes_data']['year'][$name], 2, ".", ","); 
        $current_year_total_charges += $data['accounting_taxes_data']['year'][$name];
              
        $bookings[] = $booking_row;  
        }         
        $booking_row = array();
        $booking_row[] = '';
        $booking_row[] = number_format($current_date_total_charges, 2, ".", ","); 
        $booking_row[] = number_format($current_month_total_charges, 2, ".", ","); 
        $booking_row[] = number_format($current_year_total_charges, 2, ".", ",");
        $bookings[] = $booking_row;
        
        $booking_row = array();
        $booking_row[] = '';
        $booking_row[] = '';
        $booking_row[] = '';
        $booking_row[] = '';
        $bookings[] = $booking_row;
        foreach($data['accounting_payments_data']['date'] as $name => $amount){
                if($name === "Selling Date") continue;
        $booking_row = array();                             
        $booking_row[] = $name; 
        $booking_row[] =number_format($data['accounting_payments_data']['date'][$name], 2, ".", ",");  
        $current_date_total += $data['accounting_payments_data']['date'][$name];      
        $booking_row[] = number_format($data['accounting_payments_data']['month'][$name], 2, ".", ","); 
        $current_month_total += $data['accounting_payments_data']['month'][$name];       
        $booking_row[] =  number_format($data['accounting_payments_data']['year'][$name], 2, ".", ",");
        $current_year_total += $data['accounting_payments_data']['year'][$name];        
        $bookings[] = $booking_row;    
        }    
        $booking_row = array();
        $booking_row[] = '';
        $booking_row[] = number_format($current_date_total, 2, ".", ","); 
        $booking_row[] = number_format($current_month_total, 2, ".", ","); 
        $booking_row[] = number_format($current_year_total, 2, ".", ",");
        $bookings[] = $booking_row;           
              
        force_download_csv($bookings, "daily_account_summary.csv");
    }

    function show_folio_audit_trail_report($date = NULL)
    {
        $date_range = array();
        $data['dateRange'] = $data['date'] = '';
        if ($date == '')
        {
            $date = $this->selling_date;
            $data['date'] = $date;
        }
        else
        {
            $date_check = explode('--', $date);
            if(count($date_check) > 1)
            {
                $date_range = array('from_date'=>$date_check[0], 'to_date'=>$date_check[1]);
                $data['dateRange'] = $date_range;
            }
            else
            {
                $data['date'] = $date;
            }
        }
        
        if($date_range){
            $data['payment_detail']     = $this->Payment_model->get_payments_by_date($this->company_id, '', $date_range);
            $data['charge_detail']     = $this->Charge_model->get_charges_by_date($this->company_id, '', $date_range);
            $data['start_date'] = $date_check[0];
            $data['end_date'] = $date_check[1];
            
        }else{
            $data['payment_detail']     = $this->Payment_model->get_payments_by_date($this->company_id, $date);
            $data['charge_detail']     = $this->Charge_model->get_charges_by_date($this->company_id, $date);
            $data['selling_date'] = $this->selling_date;
        }
        
        $folio_audit_detail = array();
        
        if(isset($data['payment_detail']) && $data['payment_detail']){
            array_push($folio_audit_detail, $data['payment_detail']);
        }
        if(isset($data['charge_detail']) && $data['charge_detail']){
            array_push($folio_audit_detail, $data['charge_detail']);
        }
        $data['folio_audit_detail'] = $folio_audit_detail;

        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);
        
        $data['selected_submenu'] = 'Ledger'; //for css
        $data['selected_sidebar_link'] = 'Folio Audit Trail';
        
        $data['main_content'] = '../extensions/'.$this->module_name.'/views/folio_audit_trail_report';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

    function download_folio_audit_csv_export($date = NULL)
    {        
        $this->load->helper('download');
        
        $date_range = array();
        $data['dateRange'] = $dateRange = $data['date'] = '';
        if ($date == '')
        {
            $date = $this->selling_date;
            $data['date'] = $date;
        }
        else
        {
            $date_check = explode('--', $date);
            if(count($date_check) > 1)
            {
                $date_range = array('from_date'=>$date_check[0], 'to_date'=>$date_check[1]);
                $data['dateRange'] = $dateRange = $date_range;
            }
            else
            {
                $data['date'] = $date;
            }
        }
        
        if($date_range){
            $data['payment_detail']     = $this->Payment_model->get_payments_by_date($this->company_id, '', $date_range);
            $data['charge_detail']     = $this->Charge_model->get_charges_by_date($this->company_id, '', $date_range);
            $data['start_date'] = $date_check[0];
            $data['end_date'] = $date_check[1];
            
        }else{
            $data['payment_detail']     = $this->Payment_model->get_payments_by_date($this->company_id, $date);
            $data['charge_detail']     = $this->Charge_model->get_charges_by_date($this->company_id, $date);
            $data['selling_date'] = $this->selling_date;
        }
        
        $folio_audit_detail = array();
        
        if(isset($data['payment_detail']) && $data['payment_detail']){
            array_push($folio_audit_detail, $data['payment_detail']);
        }
        if(isset($data['charge_detail']) && $data['charge_detail']){
            array_push($folio_audit_detail, $data['charge_detail']);
        }
        
        $csv_keys = array(
                            'Type',
                            'Room',
                            'Folio ID',
                            'Charges',
                            'Payments'
                           );
        
        $bookings[] = $csv_keys;
        $total = array();
        $total['booking_count'] = $total['total_nights'] = 0;
        $payment_array = $charge_array = array();
        if(isset($folio_audit_detail))
        {            
            $payment_count = $charge_count = 0;
            foreach($folio_audit_detail as $key1 => $data1) {
                foreach($data1 as $key => $data) {
                    $booking_row = array();
                    $payment_count++;
                    if(isset($data['charge_type'])){
                        $charge_count++;
                    }

                    $booking_row[] = isset($data['payment_type']) && $data['payment_type'] ? $data['payment_type'] : $data['charge_type'];
                    $booking_row[] = $data['room_name'];
                    $booking_row[] = isset($data['folio_id']) && $data['folio_id'] ? $data['folio_id'] : 0;
                    $booking_row[] = isset($data['charge_amount']) && $data['charge_amount'] ? $data['charge_amount'] : 0;
                    $booking_row[] = isset($data['payment_amount']) && $data['payment_amount'] ? $data['payment_amount'] : 0;
                    $bookings[] = $booking_row;
                    $booking_row = array();

                    if(isset($data['payment_type']) && $data['payment_type']){
                        $payment_count_array = $this->Payment_model->get_payments_by_date($this->company_id, $date, $dateRange, $data['payment_type_id']);
                        if($payment_count == $payment_count_array['payment_count']){ 
                            $payment_count = 0;
                            $charge_count = 0;
                            $booking_row[] = '';
                            $booking_row[] = '';
                            $booking_row[] = '';
                            $booking_row[] = '';
                            $booking_row[] = $payment_count_array['payment_total'];
                        }
                    } else if(isset($data['charge_type']) && $data['charge_type']){ 
                        $charge_count_array = $this->Charge_model->get_charges_by_date($this->company_id, $date, $dateRange, $data['charge_type_id']);
                        if($charge_count == $charge_count_array['charge_count']){ 
                            $charge_count = 0;
                            $booking_row[] = '';
                            $booking_row[] = '';
                            $booking_row[] = '';
                            $booking_row[] = $charge_count_array['charge_total'];
                            $booking_row[] = '';
                        }
                    }
                    $bookings[] = $booking_row;
                }
            }                 
        }
        
        $bookings = array_values(array_filter($bookings));
        force_download_csv($bookings, "folio_audit_repost.csv");
    }

}