
<div id="printable-container">
    <div class="app-page-title">
        <div class="page-title-wrapper">
            <div class="page-title-heading">
                <div class="page-title-icon">
                    <i class="pe-7s-notebook text-success"></i>
                </div>
                <?php echo l('Registration Card Report', true); ?>
            </div>
        </div>
    </div>
    
    <div class="main-card card">
        <div class="card-body">
            <div class="panel panel-default hidden-print">
                <div class="panel-body h4">
                    <div class="form-inline">
                        <?php 
                        $states = Array(
                            "-1" => "All",
                            '0' => "Reservation",
                            '1' => "In-House",
                            '2' => "Checked-out",
                            '3' => "Out of Order",
                            '4' => "Cancelled",
                            "5" => "No Show",
                            '6' => "Deleted",
                            '7' => "Unconfirmed",
                            '10' => "Departure",
                            '11' => "Arrivals"
                        ); ?>

                    <?php echo l('Selling Date', true); ?>
                    <input type="text" name="date" value="<?php echo $date; ?>" class="form-control date" style="width: 100px;">

                    <?php $url_date = ($this->uri->segment(3) != '') ? $this->uri->segment(3) : $date; ?>    
                    <?php $param = $url_date;  ?>
                        
                    <div class="btn-group btn-group-toggle m-066 pull-right">
                        <a href="javascript:" class="btn btn-primary download_reg_cards" data-date="<?= $param; ?>">
                            <?php echo l('Download Reg Card', true); ?>
                        </a>
                    </div>
                    
                </div><!-- /.form-inline -->
            </div>
        </div>

        <div class="wep">
         <!-- <div class="h3 col-lg-3"><?=$hotel_name;?></div> -->

        <?php $guest_count = 0; 
            foreach ($bookings as $booking) {
                if($booking['customer_name']) {
                    $guest_count++;
                }
            }
        ?>

        <div style="float: left; margin: 0 18px;">
            <b><?php echo "Total Guests = ".$guest_count; ?></b>
        </div>

         <div class="h3" style="font-size: 20px;">
            <span class="visible-print">
                <b><?php echo l('reporting_period'); ?></b> : <?=date('M d, Y', strtotime($date));?><br>
            </span>
            <span class="visible-print"><b><?php echo l('report_date'); ?></b> : <?=date('M d, Y', strtotime(date('Y-m-d')));?></span>
        </div>
    </div>
    
    <div class="col-lg-12 table-responsive">
        <table id="reservation_table" class="table table-hover table-condensed reservation_table ">
            <thead>
                <tr>
                    
                <th name="check_in_date" style="min-width:90px;" class="text-left check_in_date" ><?php echo l('check_in_date'); ?></th>
                <th name="check_out_date" style="min-width:90px;" class="text-left check_out_date" ><?php echo l('check_out_date'); ?></th>
                <th name="booking_id" class="booking_id"><?php echo l('booking')." ".l('id'); ?></th>
                <!-- <th name="room" style="min-width: 100px;"  class="text-left room"><?php echo l('Room'); ?></th>
                <th name="room_type" style="min-width: 100px;"  class="text-left room_type"><?php echo l('Room Type'); ?></th> -->
                <th style="min-width: 100px;"  class="text-left customer_name"><?php echo l('guest_name'); ?></th>
                <th name="status" class="text-left status"><?php echo l('status'); ?></th>
                
            </tr>
        </thead>
        <tbody>
            <?php

            foreach ($bookings as $booking): ?>
                <tr class='booking' data-booking-id='<?php echo $booking['booking_id']; ?>'>
                    
                    <td class="check_in_date">
                        <?php
                        echo ($this->enable_hourly_booking == 1 ? date('Y-m-d h:i A', strtotime($booking['check_in_date'])) : ($booking['check_in_date'] ? date('Y-m-d', strtotime($booking['check_in_date'])) : ''));
                        ?>
                    </td>
                    <td class="check_out_date">
                        <?php
                        echo ($this->enable_hourly_booking == 1 ? date('Y-m-d h:i A', strtotime($booking['check_out_date'])) : ($booking['check_out_date'] ? date('Y-m-d', strtotime($booking['check_out_date'])) : ''));
                        ?>
                    </td>
                    
                    <td class="booking_id">
                        <?php
                        echo $booking['booking_id'];
                        ?>
                    </td>
                    
                    <!-- <td class="room">
                        <?php
                        echo $booking['room_name'];
                        ?>
                    </td>
                    <td class="room_type">
                        <?php
                        echo $booking['room_type_name'];
                        ?>
                    </td> -->
                    
                    <td class="customer_name">
                        <?php
                        echo $booking['customer_name'];
                        ?>
                    </td>
                    
                    <td class="status">
                        <?php
                            echo $states[$booking['state']];
                        ?>
                    </td>
                    
                </tr>
                <?php
            endforeach;
            ?>
        </tbody>

    </table>
    
</div>
</div>
</div>
</div>
<?php $flag = 1;
$permissions = $this->session->userdata('permissions');
if ($permissions && in_array('bookings_view_only', $permissions) && !(in_array('access_to_bookings', $permissions))) {
    $flag = 0;
}
?>
<input type="hidden" name="flag" value="<?php echo $flag; ?>" >


