<?php
class Reg_card_model extends CI_Model {

    // public function get_bookings_by_checkin_date($selling_date, $date)
    public function get_bookings_by_checkin_date($date)
    {

        // $where = "(bb.check_in_date = '$selling_date' OR bb.check_in_date = '$date')";
        $where = "(bb.check_in_date = '$date')";

        $this->db->select('
            b.booking_id,
            b.state,
            b.adult_count,
            b.children_count,
            b.use_rate_plan,
            b.rate_plan_id,
            b.balance,
            b.charge_type_id,
            b.rate,
            bb.check_in_date,
            bb.check_out_date,
            bb.room_id,
            bb.room_type_id,
            c.customer_name as customer_name,
            c.phone as customer_phone,
            c.email as customer_email,
            c.address as customer_address,
            cp.name as company_name,
            r.room_name,
            rt.name as room_type_name
        ');
        $this->db->from('booking b');
        $this->db->join('booking_block bb', 'bb.booking_id = b.booking_id', 'left');
        $this->db->join('customer c', 'c.customer_id = b.booking_customer_id', 'left');
        $this->db->join('company cp', 'cp.company_id = b.company_id', 'left');
        $this->db->join('room r', 'r.room_id = bb.room_id', 'left');
        $this->db->join('room_type rt', 'rt.id = bb.room_type_id', 'left');
        $this->db->where('b.company_id', $this->company_id);
        $this->db->where('b.is_deleted', 0);
        $this->db->where($where);

        $query = $this->db->get();
        return $query->result_array();
    }

    function get_rate_plan($rate_plan_id)
    {
        $this->db->select("rp.*, r.*");
        $this->db->from("rate_plan as rp");
        $this->db->join("rate as r","rp.base_rate_id = r.rate_id", "left");
        $this->db->where("rp.is_deleted != '1'");
        $this->db->where("rp.rate_plan_id", $rate_plan_id);
        
        $query = $this->db->get();
        //echo $this->db->last_query();
        if ($this->db->_error_message()) // error checking
            show_error($this->db->_error_message());
        if ($query->num_rows >= 1) 
        {
            $q = $query->result_array();
            return $q[0];
        }
        return NULL;
    }
}
