<?php

class Charges_model extends CI_Model {

	function __construct()
    {
        // Call the Model constructor
        parent::__construct();
      
    }	
    
	function get_accounting_charges($start_date, $end_date, $include_cancelled_bookings = false){
		
		$where_condition = " b.state < '3' AND";
		if($include_cancelled_bookings)
		{
			$where_condition = " b.state <= '5' AND";
		}
		
		$company_id = $this->session->userdata('current_company_id');
		$sql = "
				SELECT DISTINCT ct.id, ct.name
				FROM charge_type as ct
				WHERE (ct.company_id = '$company_id' OR ct.company_id = 0) AND ct.is_deleted = '0'";
		$q = $this->db->query($sql);		
		$charge_type_array = $q->result_array();		
		$str_array = $unique_charges = Array();		
		foreach($charge_type_array as $row){
            if(in_array($row['name'], $unique_charges)){
                continue;
            }
            $unique_charges[] = $row['name'];
			$str_array[] = "SUM(IF(charge_type_id='".$row['id']."', amount,' ')) AS ".$this->db->escape($row['name']);
			$str_array_sum[] = "SUM(IF(report_table.charge_type_id='".$row['id']."', amount,' ')) AS ".$this->db->escape($row['name']);
		}
		$charge_types_str = implode(", ", $str_array);
		$charge_types_str_sum = implode(", ", $str_array_sum);
		$sql = "	
			SELECT date as 'Selling Date', 
			$charge_types_str_sum
			FROM date_interval as di
			LEFT JOIN (		
				SELECT charges.selling_date,charge_type_id,
                amount, $charge_types_str
				FROM (
					SELECT c.selling_date, c.charge_type_id as charge_type_id, SUM(c.amount) as amount
					FROM charge as c, booking as b
					WHERE 
						c.booking_id = b.booking_id AND
						$where_condition
						b.is_deleted = '0' AND
						c.is_deleted = '0' AND
						b.company_id = '$company_id' ";
						if($start_date && $end_date){
							$sql .=" AND c.selling_date >= '$start_date' AND c.selling_date <= '$end_date'";
						}
		            $sql .= " GROUP BY c.selling_date, charge_type_id
                ) as charges
                GROUP BY charges.selling_date, charges.charge_type_id
            )report_table ON report_table.selling_date = di.date
            WHERE";
			if($start_date && $end_date){
				$sql .= " di.date >= '$start_date' AND di.date <= '$end_date'";
			}			
			
        $q = $this->db->query($sql);
		if ($this->db->_error_message()) // error checking
			show_error($this->db->_error_message());
        $result = "";
		if ($q)
			$result = $q->result_array()[0];	
		return $result;
	}
	
}
