<?php 

class Report extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();
    
        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Booking_source_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Report_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Room_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Company_model');

        $global_data['menu_on'] = true;
        $global_data['selected_menu'] = 'reports';      
        $global_data['submenu'] = 'reports/reports_submenu.php';
        $global_data['submenu_parent_url'] = base_url()."reports/";
        $global_data['sidebar_menu_url'] = base_url()."reports/market_segment/";
        $global_data['menu_items'] = $this->Menu_model->get_menus(array('parent_id' => 4, 'wp_id' => 1));
        $global_data['selected_submenu'] = 'Market Segment';
        $global_data['sidebar_links'] = $this->Menu_model->get_menus(array('parent_id' => 10, 'wp_id' => 1));

        $this->load->vars($global_data);
        
    }

    function show_booking_source_report($start_date = '', $end_date = '')
    {
        if ($start_date == '') {
            $parts      = explode('-', $this->selling_date);
            $year       = $parts[0];
            $month      = $parts[1];
            $start_date = "$year-$month-01";
        }

        if ($end_date == '') {
            $end_date = date('Y-m-d', strtotime($start_date."+1 month"));
        }

        $data['start_date'] = $start_date;
        $data['end_date']   = $end_date;

        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        $data['selected_sidebar_link'] = 'Booking Source';

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/booking_source';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

    function get_booking_source_data_AJAX() 
    {
        $start_date = $this->input->post('dateStart');
        $end_date   = $this->input->post('dateEnd');
        
        $data = $this->prepare_booking_source_data($start_date, $end_date);

        echo json_encode($data);
    }

    function prepare_booking_source_data($start_date, $end_date)
    {
        $company_data = $this->Company_model->get_company($this->company_id);
        $number_of_rooms = $this->Room_model->get_number_of_rooms($this->company_id);
        $include_cancelled_noshow_bookings = (isset($company_data['include_cancelled_noshow_bookings']) && $company_data['include_cancelled_noshow_bookings']) ? true : false;
        $booking_count = $this->Report_model->get_booking_source_data(
            $this->company_id,
            $start_date,
            $end_date
        );
        $all_charges = $this->Report_model->get_charges_by_source($start_date, $end_date, $this->selling_date, false, false, null, $include_cancelled_noshow_bookings);
        $room_charges = $this->Report_model->get_charges_by_source($start_date, $end_date, $this->selling_date, true, false, null, $include_cancelled_noshow_bookings);
        // All booking source
        $source_data = array();
        $common_booking_sources = json_decode(COMMON_BOOKING_SOURCES, true);
        $coomon_sources_setting = $this->Booking_source_model->get_common_booking_sources_settings($this->company_id);
        foreach($common_booking_sources as $id => $name)
        {
            if(!(isset($coomon_sources_setting[$id]) && $coomon_sources_setting[$id]['is_hidden'] == 1)) {
                $source_data[$id] = array(
                    'name' => $name,
                    'commission_rate' => isset($coomon_sources_setting[$id]['commission_rate']) && $coomon_sources_setting[$id]['commission_rate'] ? $coomon_sources_setting[$id]['commission_rate'] : 0
                );
            }
        }

        $booking_sources = $this->Booking_source_model->get_booking_source($this->company_id);
        if (!empty($booking_sources)) {
            foreach ($booking_sources as $booking_source) {
                $source_data[$booking_source['id']] = array(
                    'name' => $booking_source['name'],
                    'commission_rate' => $booking_source['commission_rate']
                );
            }
        }

        $booking_source_result = array();

        $total_bookings = $total_room_charge = $total_charge = 0;

        foreach ($booking_count as $key => $data) {

            $room_charge_total = isset($room_charges[$data['source']]) ? $room_charges[$data['source']] : 0;
            $all_charge_total = isset($all_charges[$data['source']]) ? $all_charges[$data['source']] : 0;
            $commission_rate =
                isset($source_data[$data['source']]['commission_rate']) ? (float)($source_data[$data['source']]['commission_rate'])/100 : 0;
            $booking_source_result[$data['source']] = Array(
                "booking_source" => isset($source_data[$data['source']]['name']) ? $source_data[$data['source']]['name'] : "Others",
                "booking_count"  => $data['booking_count'],
                "revPAR" => $room_charge_total / $number_of_rooms,
                "ADR" => ($data['booking_count'] > 0) ? ($room_charge_total / $data['booking_count']) : 0,
                "room_charge_total"   => $room_charge_total,
                "charge_total"   => $all_charge_total,
                "commission"  => ($commission_rate > 0 ) ? $room_charge_total * $commission_rate : 0
            );
            $total_bookings += $data['booking_count'];
            $total_room_charge += $room_charge_total;
            $total_charge += $all_charge_total;
        }

        return $booking_source_result;
    }

    function download_booking_source_csv_export($start_date = NULL, $end_date = NULL, $group_by = null)
    {        
        $this->load->helper('download');
        $arrayData = $this->prepare_booking_source_data($start_date, $end_date);

        $csv_keys = array(
            'Source',
            'Room Nights',
            'RevPAR',
            'ADR',
            'Room Revenue',
            'Total Revenue',
            'Commission'
        );
        $bookings[] = $csv_keys;

        foreach($arrayData as $key => $data)
        {
            $booking_row = array();

            $booking_count = ($data['booking_count']) ? $data['booking_count'] : 0;
            $room_charge_total = ($data['room_charge_total']) ? $data['room_charge_total'] : 0;
            if($booking_count && $room_charge_total)
            {
                $ADR = number_format($data['room_charge_total']/$data['booking_count'], 2, ".", ",");;
            }
            elseif(!$booking_count && !$room_charge_total)
            {
                $ADR = 0.00;
            }
            elseif(!$room_charge_total && $booking_count)
            {
                $ADR = 0.00;
            }
            elseif($room_charge_total && !$booking_count)
            {
                $ADR = 'Infinity';
            }

            $booking_row[] = $data['booking_source'];
            $booking_row[] = ($data['booking_count']) ? $data['booking_count'] : '0 (0.00%)';
            $booking_row[] = ($data['revPAR']) ? number_format($data['revPAR'], 2, ".", ",") : '0.00';
            $booking_row[] = $ADR;
            $booking_row[] = ($data['room_charge_total']) ? number_format($data['room_charge_total'], 2, ".", ",") : '0.00';
            $booking_row[] = ($data['charge_total']) ? number_format($data['charge_total'], 2, ".", ",") : '0.00';
            $booking_row[] = ($data['charge_total']) ? number_format($data['commission'], 2, ".", ",") : '0.00';

            $bookings[] = $booking_row;
        }

        force_download_csv($bookings, "booking_source.csv");
    }

   

}