<?php 

class Registration_card extends MY_Controller
{
    public $module_name;
	function __construct()
	{
        parent::__construct();

        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Booking_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Booking_room_history_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Booking_extra_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Booking_field_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Company_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Customer_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Customer_field_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Image_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Payment_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Room_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Room_type_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Employee_log_model');

        $global_data['menu_on'] = true;
        $this->load->vars($global_data);
	}

    function booking_registration_card()
    {
        $data['company_data'] = $this->Company_model->get_company($this->company_id);

        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/registration_card_settings';

        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

    function update_registration_card_settings_AJAX()
    {
        if ($this->input->post()) {
            $company_data = array(
                'show_logo_on_registration_card' => $this->input->post('show_logo_on_registration_card'),
                'show_rate_on_registration_card' => $this->input->post('show_rate_on_registration_card'),
            );
            $this->Company_model->update_company($this->company_id, $company_data);
            $this->_create_reservation_log("Registration Card settings updated");
            echo json_encode(array('status' => true));
            return;
        }
        echo json_encode(array('status' => false));
    }

    function _create_reservation_log($log) {
        $log_detail =  array(
                    "user_id" => $this->user_id,
                    "selling_date" => $this->selling_date,
                    "date_time" => gmdate('Y-m-d H:i:s'),
                    "log" => $log,
                );   
        
        $this->Employee_log_model->insert_log($log_detail);     
    }
	
    function get_registration_card_info_AJAX()
    {
        $booking_id = sqli_clean($this->security->xss_clean($this->input->post('booking_id')));
        $number_of_days = $this->input->post('number_of_days');
        $data['company'] = $this->company_data;

        // if logo settings enable then only get the logo
        if ($this->company_data['show_logo_on_registration_card']) {
            $company_logo = $this->Image_model->get_images($this->company_data['logo_image_group_id']);
            $data['company_logo'] = !empty($company_logo[0]['filename']) ? $company_logo[0]['filename'] : null;
        }

        $data['check_in_policies'] = $this->Company_model->get_check_in_policies($this->company_id);

        $booking = $this->Booking_model->get_booking($booking_id);
        $booking['booking_blocks'] = $this->Booking_room_history_model->get_booking_blocks($booking_id);
        $customer = $this->Customer_model->get_customer($booking['booking_customer_id']);

        if($customer)
        {
            $data['customer'] = $customer;
        }
        else
        {
            $data['customer'] = '';
        }

        $booking['staying_customers'] = $this->Customer_model->get_staying_customers($booking_id);
        $booking['extras'] = $this->Booking_extra_model->get_booking_extras($booking_id);

        //If current selling date is between check-in and check-out date
        //use current selling date as the check in date for checking available rooms
        $current_booking_block = $this->Booking_room_history_model->get_booking_detail($booking_id);
        $booking['check_in_date'] = $current_booking_block['check_in_date'];
        $booking['check_out_date'] = $current_booking_block['check_out_date'];
        $booking['room_type_name'] = $this->Room_type_model->get_room_type_by_room_id($current_booking_block['room_id'])['name'];

        $room = $this->Room_model->get_room($current_booking_block['room_id']);
        $booking['room_name'] = $room['room_name'];

        $data['customer_fields'] = $this->Customer_field_model->get_customer_fields_for_registration_card($this->company_id);
        $data['custom_booking_fields'] = $this->Booking_field_model->get_booking_fields_data($booking_id,'show_on_registration_card');

        $data['booking_fields'] = $this->Booking_field_model->get_booking_fields($this->company_id,'show_on_registration_card');
        $common_customer_fields = json_decode(COMMON_CUSTOMER_FIELDS, true);
        $get_common_customer_fields = $this->Customer_field_model->get_common_customer_fields_settings($this->company_id);

        foreach($common_customer_fields as $id => $name)
        {
            $data['common_customer_fields'][] = array(
                'id' => $id,
                'name' => $name,
                'company_id' => $this->company_id,
                'show_on_customer_form'=> ($get_common_customer_fields && isset($get_common_customer_fields[$id]) && isset($get_common_customer_fields[$id]['show_on_customer_form'])) ? $get_common_customer_fields[$id]['show_on_customer_form'] : 1,
                'show_on_registration_card'=>  ($get_common_customer_fields && isset($get_common_customer_fields[$id]) && isset($get_common_customer_fields[$id]['show_on_registration_card'])) ? $get_common_customer_fields[$id]['show_on_registration_card'] : 0,
                'is_required' => ($id == FIELD_NAME) ? 1 : (($get_common_customer_fields && isset($get_common_customer_fields[$id]) && isset($get_common_customer_fields[$id]['is_required'])) ? $get_common_customer_fields[$id]['is_required'] : 0),
                'show_on_in_house_report' => ($get_common_customer_fields && isset($get_common_customer_fields[$id]) && isset($get_common_customer_fields[$id]['show_on_in_house_report'])) ? $get_common_customer_fields[$id]['show_on_in_house_report'] : 0
            );
            $common_name = strtolower($name);
            $cn = "";
            if(isset($data['customer'][$common_name]) && $data['customer'][$common_name] != '')
            {
                $data['customer']['customer_fields'][$id] = $data['customer'][$common_name];
            }
            elseif(isset($data['customer']['customer_'.$common_name]) && $data['customer']['customer_'.$common_name] != '')
            {
                $data['customer']['customer_fields'][$id] = $data['customer']['customer_'.$common_name];
            }
            else
            {
                $explode_name = explode(' ',$common_name);
                $cn = $explode_name[0].''.(isset($explode_name[1]) && $explode_name[1] ? $explode_name[1] : '');
                if(isset($data['customer'][$cn]) && $data['customer'][$cn] != '')
                {
                    $data['customer']['customer_fields'][$id] = $data['customer'][$cn];
                }
                else
                {
                    $cn = (isset($explode_name[0]) && $explode_name[0] ? $explode_name[0] : '').'_'.(isset($explode_name[1]) && $explode_name[1] ? $explode_name[1] : '');
                    if(isset($data['customer'][$cn]) && $data['customer'][$cn] != "") {
                        if($cn == 'customer_type') {
                            $cn = 'customer_type_id';
                            $this->load->model('Customer_type_model');
                            $customer_type = $this->Customer_type_model->get_customer_type($data['customer'][$cn]); 
                            $data['customer']['customer_fields'][$id] = $customer_type[0]['name'] ?? null;
                        } else {
                            $data['customer']['customer_fields'][$id] = $data['customer'][$cn];
                        }
                    }
                }
            }
        }

        foreach ($data['common_customer_fields'] as $key => $value) {
            if($value['show_on_registration_card'])
                $data['customer_fields'][] = $value;
        }

        // if booking is using rate plan, get the rate of the check-in date of the booking
        if ($booking['use_rate_plan'] == 1)
        {
            $rate_array = $this->rate->get_rate_array(
                $booking['rate_plan_id'],
                $booking['check_in_date'],
                $booking['check_out_date'],
                $booking['adult_count'],
                $booking['children_count']
            );
            if(isset($rate_array[0]))
            {
                $booking['rate'] = $rate_array[0]['rate'];
            }
        }

        $payment_details = $this->Payment_model->get_payments($booking_id);
        $total_payment = 0;

        if($payment_details) {
            foreach ($payment_details as $payment) {
                $total_payment += $payment['amount'];
            }
        }
        $booking['charge_total'] = (float)$booking['balance'] + $total_payment;
        
        $charge_type_id = $booking['charge_type_id'];
        if($booking['use_rate_plan'] == 1){
            $rate_plan = $this->Room_type_model->get_rate_plan($booking['rate_plan_id']);
            
            $charge_type_id = $rate_plan['charge_type_id'];
        }

        $tax = $this->get_tax_amount_from_room_charge_JSON($charge_type_id, $booking['rate']);
        $booking['total_tax'] = (($booking['rate'] * floatval($tax['percentage'])) * $number_of_days );

        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        $data['menu_on'] = false;

        // Get signature info
        $this->load->model('../extensions/guest-signature-integration/models/Guest_signature_model');

        $signature = $this->Guest_signature_model->get_signature_detail($booking_id);

        if ($signature && !empty($signature->guest_signature)) {
            $signature_path = base_url() . 'application/extensions/guest-signature-integration/signatures/booking_' . $booking_id . '/' . $signature->guest_signature;
            $data['guest_signature'] = $signature_path;
            $data['signature_at'] = $signature->signature_at;
        } else {
            $data['guest_signature'] = null;
            $data['signature_at'] = null;
        }

        // Get guest document info
        $this->load->model('Option_model');

        $uploaded_document = $this->Option_model->get_option_by_name_and_json('guest_document_drive', 'booking_id', $booking_id, $this->company_id);

        // prx($uploaded_document);

        $data['guest_documents'] = [];

        if (!empty($uploaded_document)) {
            foreach ($uploaded_document as $row) {

                if (empty($row['option_value'])) {
                    continue;
                }

                $doc_image_data = json_decode($row['option_value'], true);

                if (
                    empty($doc_image_data['file_name']) ||
                    empty($doc_image_data['relative_path'])
                ) {
                    continue;
                }

                $data['guest_documents'][] = [
                    'file_name'     => $doc_image_data['file_name'],
                    'original_name' => $doc_image_data['original_name'] ?? '',
                    'document_type' => $doc_image_data['document_type'] ?? '',
                    'url'           => base_url().
                        'application/extensions/document_drive/guest_documents/' .
                        $doc_image_data['relative_path'] . '/' .
                        $doc_image_data['file_name']
                    
                ];
            }
        }


        $data['booking'] = $booking;
        echo json_encode($data);

    }

    function get_tax_amount_from_room_charge_JSON($charge_type_id, $rate) {
        $tax = $this->_get_tax_amount_from_charge_type_id($charge_type_id, null, $rate);
        return $tax;
    }

    function _get_tax_amount_from_charge_type_id($charge_type_id, $company_id = null, $rate = null)
    {
        $this->load->model('../extensions/'.$this->module_name.'/models/Tax_model');
        $tax = array();
        $tax['percentage'] = 0.01 * $this->Tax_model->get_total_tax_percentage_by_charge_type_id($charge_type_id, $company_id, $rate);
        $tax['inclusive_tax_percentage'] = 0.01 * $this->Tax_model->get_total_tax_percentage_by_charge_type_id($charge_type_id, $company_id, $rate, $is_tax_inclusive = true);
        $tax['flat_rate'] = $this->Tax_model->get_total_tax_flat_rate_by_charge_type_id($charge_type_id, $company_id, $rate);
        $tax['inclusive_tax_flat_rate'] = $this->Tax_model->get_total_tax_flat_rate_by_charge_type_id($charge_type_id, $company_id, $rate, $is_tax_inclusive = true);
        $tax['charge_type_id'] = $charge_type_id;
        return $tax;
    }
}