<?php

class Night_audit_model extends CI_Model {

	function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
	
	
function log_night_audit($company_id, $selling_date, $user_id)
	{		
		$this->load->model('Company_model');
		$this->load->helper('timezone');
		$company_time_zone = $this->Company_model->get_time_zone($company_id);
		$local_time =  convert_to_local_time(new DateTime(), $company_time_zone)->format("Y-m-d H:i:s");
		
		$data = Array("company_id" => $company_id, "selling_date" => $selling_date, "user_id" => $user_id, "local_time" => $local_time);
		$this->db->insert("night_audit_log", $data);
        if ($this->db->_error_message())
		{
			show_error($this->db->_error_message());
		}
	}	

	function delete_night_audit_log()
	{
		$this->load->model('Company_model');
		$this->db->empty_table("night_audit_log");
        if ($this->db->_error_message())
		{
			show_error($this->db->_error_message());
		}
	}
	
	function get_night_audit_logs()
	{
		
		$this->db->order_by('local_time', 'desc');
		$this->db->limit(500);
		$query = $this->db->get('night_audit_log');
		
		
		 if ($this->db->_error_message())
		{
			show_error($this->db->_error_message());
		}
		
		if ($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return null;
		}
	}
	
	function get_auto_night_audit_enabled_companies($company_batch = null)
	{
		$where_company_batch = "";
		if($company_batch && count($company_batch) > 0) {
			$company_batch_str = implode(",", $company_batch);
			$where_company_batch = "AND c.company_id IN ($company_batch_str)";
		}
		$sql = "
			SELECT 
				DISTINCT c.company_id, 
				c.name as company_name, 
				c.night_audit_auto_run_time, 
				c.time_zone, 
				c.selling_date, 
				c.send_invoice_email_automatically,
                c.automatic_email_confirmation,
                c.email_confirmation_for_ota_reservations,
                c.automatic_feedback_email
			FROM (company as c)
			LEFT JOIN (
				SELECT company_id, count(company_id) as disabled
				FROM company_x_tag
				WHERE tag = 'DISABLED'
				GROUP BY company_id
			)cxt ON cxt.company_id = c.company_id
			LEFT JOIN company_subscription as cs ON cs.company_id = c.company_id
			INNER JOIN (
				SELECT company_id
				FROM extensions_x_company
				WHERE `extension_name`='automated_night_audit' AND `is_active` = 1
				GROUP BY company_id
			)exc ON exc.company_id = c.company_id
			WHERE 
				c.night_audit_auto_run_is_enabled != '0' AND
				cxt.disabled IS NULL AND
				c.is_deleted = 0 AND
                cs.subscription_state != 'canceled' AND
                cs.subscription_state != 'trial_ended' AND
                cs.subscription_state != 'deleted' 
				$where_company_batch
			";
		
		$q = $this->db->query($sql);
		//echo $this->db->last_query();
		if ($this->db->_error_message()) // error checking
			show_error($this->db->_error_message());

			
		$result = "";
		if ($q)
			$result = $q->result_array();	
		return $result;
	}
}