<?php 

class Report extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();

        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Room_type_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Currency_model');
    
        $global_data['menu_on'] = true;
        $global_data['selected_menu'] = 'reports';      
        $global_data['submenu'] = 'reports/reports_submenu.php';
        $global_data['submenu_parent_url'] = base_url()."reports/";
        $global_data['sidebar_menu_url'] = base_url()."reports/ledger/";

        $this->load->vars($global_data);
    }

    function advanced_deposits($start_date = NULL, $end_date = NULL, $depositType = '')
    {
        $start_date = $start_date ? $start_date : date('Y-m-d', strtotime("-1 month +1 day"));
        $end_date = $end_date ? $end_date : date('Y-m-d');
        
        $data['start_date']  = $start_date;
        $data['end_date']    = $end_date;
        $data['deposit_type'] = $depositType;
        
        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);
        
        $data['default_currency'] = $this->Currency_model->get_default_currency($this->company_id);
       
        $data['bookings'] = $this->Room_type_model->get_bookings($this->company_id, $start_date, $end_date, $depositType);        
        $data['selected_submenu'] = 'Ledger';
        $data['selected_sidebar_link'] = 'Advance Deposits';
        $data['hotel_name'] = $this->company_name;        
       
        $data['main_content'] = '../extensions/'.$this->module_name.'/views/advanced_deposits';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

    function download_advanced_deposit_csv_export($start_date = null, $end_date = null, $depositType = null)
    {        
        $this->load->helper('download');
        $start_date = $start_date ? $start_date : date('Y-m-d', strtotime("-1 month +1 day"));
        $end_date = $end_date ? $end_date : date('Y-m-d');
        
        $data['start_date']  = $start_date;
        $data['end_date']    = $end_date;
        $data['deposit_type'] = $depositType;
        
        $data['bookings'] = $this->Room_type_model->get_bookings($this->company_id, $start_date, $end_date, $depositType);        
        
        $csv_keys = array(
            "Reservation",
            "Customer",
            "Telephone",
            "Arrival",
            "Deposit",
            "Deposit Made",
            "Employee"
        );
        
        $bookings = array($csv_keys);
        foreach($data['bookings'] as $key => $booking){
            $amount = ($booking['amount']) ? $booking['amount'] : "0.00";
                    $deposit_date = ($booking['amount']) ? date('M d, Y', strtotime($booking['deposit_date'])) : '';            
            $booking_row = array();
            $booking_row[] = $booking['booking_id'] ? $booking['booking_id'] : "";
            $booking_row[] = $booking['customer_name'] ? $booking['customer_name'] : "";
            $booking_row[] = $booking['phone'] == 10 ? $booking['phone'] : "";;
            $booking_row[] = $booking['check_in_date'] ? date('M d, Y', strtotime($booking['check_in_date'])) : "";
            $booking_row[] = "$".$amount;
            $booking_row[] = $deposit_date;
            $booking_row[] = $booking['first_name']." ".$booking['last_name'];
           
            
            $bookings[] = $booking_row;
        }
        force_download_csv($bookings, "advance_deposit_report.csv");
    }
}